/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class HTTPProxyAuthenticator2Tests
extends SingleClusterTest {
    public void testAdditionalAttributes(RestHelper restHelper, BasicHeader basicHeader) throws Exception {
        RestHelper.HttpResponse httpResponse = restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), basicHeader});
        Assert.assertTrue((String)("Expected no attributes to be set for user: " + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("\"custom_attribute_names\":[\"attr.proxy2.username\"]"));
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusCode());
        httpResponse = restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), basicHeader, new BasicHeader("x-proxy-attribute-2", "attributeValue2")});
        Assert.assertTrue((String)("Expected (only) 'attribute-2' to be set for user'" + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("attr.proxy2.x-proxy-attribute-2"));
        Assert.assertTrue((String)("Expected (only) 'attribute-2' to be set for user'" + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("attr.proxy2.username"));
        Assert.assertTrue((String)("Expected (only) 'attribute-2' to be set for user'" + httpResponse.getBody()), (httpResponse.toDocNode().getAsListOfNodes("custom_attribute_names").size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusCode());
        httpResponse = restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), basicHeader, new BasicHeader("x-proxy-attribute-1", "attributeValue1"), new BasicHeader("x-proxy-attribute-2", "attributeValue2")});
        Assert.assertTrue((String)("Expected 'attribute-1' and 'attribute-2' to be set for user'" + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("attr.proxy2.x-proxy-attribute-1"));
        Assert.assertTrue((String)("Expected 'attribute-1' and 'attribute-2' to be set for user'" + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("attr.proxy2.x-proxy-attribute-2"));
        Assert.assertTrue((String)("Expected 'attribute-1' and 'attribute-2' to be set for user'" + httpResponse.getBody()), (boolean)httpResponse.getBody().contains("attr.proxy2.username"));
        Assert.assertTrue((String)("Expected 'attribute-1' and 'attribute-2' to be set for user'" + httpResponse.getBody()), (httpResponse.toDocNode().getAsListOfNodes("custom_attribute_names").size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)200L, (long)httpResponse.getStatusCode());
    }

    @Test
    public void testHTTPEnterpriseProxyIpMode() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_proxy2_ip_mode.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HTTPProxyAuthenticator2Tests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), HTTPProxyAuthenticator2Tests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user-wrong", "scotty"), HTTPProxyAuthenticator2Tests.encodeBasicHeader("nagilum", "nagilum")}).getStatusCode());
        Assert.assertEquals((long)400L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a"), new BasicHeader("x-proxy-user", "scotty"), HTTPProxyAuthenticator2Tests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)400L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a,b,c"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("X-Proxy-User", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
        this.testAdditionalAttributes(this.nonSslRestHelper(), new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"));
    }

    public void setupClientCertTest(String configPath) throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).putList("searchguard.ssl.http.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.http.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig(configPath), settings, true);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
    }

    public void testCert(String configPath) throws Exception {
        this.setupClientCertTest(configPath);
        RestHelper restHelper = this.restHelper();
        restHelper.enableHTTPClientSSL = true;
        restHelper.trustHTTPServerCertificate = true;
        restHelper.sendHTTPClientCertificate = true;
        restHelper.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
        Assert.assertEquals((long)403L, (long)restHelper.executePutRequest("searchguard/_doc/x", "{}", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
        this.testAdditionalAttributes(restHelper, null);
        restHelper.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)restHelper.executePutRequest("searchguard/_doc/y", "{}", new Header[0]).getStatusCode());
        RestHelper.HttpResponse res = restHelper.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testHTTPEnterpriseProxyCertMode() throws Exception {
        this.testCert("sg_config_proxy2_cert_mode.yml");
    }

    @Test
    public void testHTTPEnterpriseProxyDefaultMode() throws Exception {
        this.setupClientCertTest("sg_config_proxy2_both_mode.yml");
        RestHelper restHelper = this.restHelper();
        restHelper.enableHTTPClientSSL = true;
        restHelper.trustHTTPServerCertificate = true;
        restHelper.sendHTTPClientCertificate = true;
        Assert.assertEquals((long)401L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "99.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        restHelper.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)401L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "99.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "99.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        Assert.assertEquals((long)403L, (long)restHelper.executePutRequest("searchguard/_doc/x", "{}", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "99.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        this.testAdditionalAttributes(restHelper, new BasicHeader("x-forwarded-for", "99.0.0.1,192.168.0.1,10.0.0.2"));
        restHelper.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)restHelper.executePutRequest("searchguard/_doc/y", "{}", new Header[0]).getStatusCode());
        RestHelper.HttpResponse res = restHelper.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testHTTPEnterpriseProxyEitherMode() throws Exception {
        String configPath = "sg_config_proxy2_either_mode.yml";
        this.testCert(configPath);
        this.tearDown();
        this.setupClientCertTest(configPath);
        RestHelper restHelper = this.restHelper();
        restHelper.enableHTTPClientSSL = true;
        restHelper.trustHTTPServerCertificate = true;
        restHelper.sendHTTPClientCertificate = true;
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        restHelper.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        Assert.assertEquals((long)403L, (long)restHelper.executePutRequest("searchguard/_doc/x", "{}", new Header[]{new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer"), new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2")}).getStatusCode());
        this.tearDown();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig(configPath), Settings.EMPTY, true);
        restHelper = this.nonSslRestHelper();
        Assert.assertEquals((long)400L, (long)restHelper.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a,b,c"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("X-Proxy-User", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)restHelper.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)restHelper.executeGetRequest("", new Header[0]).getStatusCode());
        this.testAdditionalAttributes(restHelper, new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"));
    }
}

