/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HttpIntegrationTests
extends SingleClusterTest {
    @Test
    public void testHTTPBasic() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).put("action.destructive_requires_name", false).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("v2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("v3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("_search", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/2", "{}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("xxxxyyyy/_doc/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("abc", "abc:abc")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithnopassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithblankpassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic wrongheader")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic ")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("picard", "picard")).getStatusCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        }
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("/theindex", "{}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("/theindex/_doc/1?refresh=true", "{\"a\":0}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("/theindex/_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("/theindex", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("/klingonempire", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_close", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("/searchguard/_mapping", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/2", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/0", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_cat/indices/public?v", HttpIntegrationTests.encodeBasicHeader("bug108", "nagilum"));
        Assert.assertTrue((boolean)resc.getBody().contains("green"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("role01_role02/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01_role02_role03", "user_role01_role02_role03")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("role01_role02/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01", "user_role01")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("spock/_search?pretty", HttpIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("spock/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("kirk/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("*/_mapping", "{\"i\" : [\"4\"]}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("searchguard/_mget", "{\"ids\" : [\"0\"]}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("searchguard").id("roles").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"roles", FileHelper.readYamlContent((String)"sg_roles_deny.yml")})).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"roles"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("starfleet/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("searchguard").id("roles").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"roles", FileHelper.readYamlContent((String)"sg_roles.yml")})).actionGet();
        cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"roles"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        RestHelper.HttpResponse res = rh.executeGetRequest("_search?pretty", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"value\" : 11"));
        Assert.assertTrue((!res.getBody().contains("searchguard") ? 1 : 0) != 0);
        res = rh.executeGetRequest("_nodes/stats?pretty", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("total_in_bytes"));
        Assert.assertTrue((boolean)res.getBody().contains("max_file_descriptors"));
        Assert.assertTrue((boolean)res.getBody().contains("buffer_pools"));
        Assert.assertFalse((boolean)res.getBody().contains("\"nodes\" : { }"));
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
        res = rh.executePostRequest("_bulk", bulkBody, HttpIntegrationTests.encodeBasicHeader("writer", "writer"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\":201"));
        res = rh.executeGetRequest("_searchguard/authinfo?pretty", HttpIntegrationTests.encodeBasicHeader("custattr", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_requested_tenant\" : null"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\" : \"custattr\""));
        Assert.assertTrue((boolean)res.getBody().contains("\"custom_attribute_names\" : ["));
        Assert.assertTrue((boolean)res.getBody().contains("attr.internal.c3"));
        Assert.assertTrue((boolean)res.getBody().contains("attr.internal.c1"));
        res = rh.executeGetRequest("v3/_search", HttpIntegrationTests.encodeBasicHeader("custattr", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        String reindex = "{\"source\": {\"index\": \"starfleet\"},\"dest\": {\"index\": \"copysf\"}}";
        res = rh.executePostRequest("_reindex?pretty", "{\"source\": {\"index\": \"starfleet\"},\"dest\": {\"index\": \"copysf\"}}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"total\" : 1"));
        Assert.assertTrue((boolean)res.getBody().contains("\"batches\" : 1"));
        Assert.assertTrue((boolean)res.getBody().contains("\"failures\" : [ ]"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("User knuddel"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("attr.internal.test1"));
        Assert.assertFalse((String)res.getBody(), (boolean)res.getBody().contains("worf"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "nonexists"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "notallowed"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testHTTPSCompressionEnabled() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).put("http.compression", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.restHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/sslinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*ssl_protocol\":\"TLSv1.2*");
        res = rh.executeGetRequest("_nodes", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertNotContains(res, "*\"compression\":\"false\"*");
        this.assertContains(res, "*\"compression\":\"true\"*");
    }

    @Test
    public void testHTTPSCompression() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.restHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/sslinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*ssl_protocol\":\"TLSv1.2*");
        res = rh.executeGetRequest("_nodes", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*\"compression\":\"false\"*");
        this.assertNotContains(res, "*\"compression\":\"true\"*");
    }

    @Test
    public void testHTTPAnon() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_anon.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertTrue((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo?pretty=true", new Header[0]);
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\" : \""));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((boolean)resc.getBody().contains("nagilum"));
        Assert.assertFalse((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("searchguard").id("config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"config", FileHelper.readYamlContent((String)"sg_config.yml")})).actionGet();
        tc.index(((IndexRequest)new IndexRequest("searchguard").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("internalusers").source(new Object[]{"internalusers", FileHelper.readYamlContent((String)"sg_internal_users.yml")})).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("_searchguard/authinfo", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testHTTPClientCert() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).putList("searchguard.ssl.http.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.http.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_clientcert.yml"), settings, true);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        rh.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", new Header[0]).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/" + this.getType() + "/x", "{}", new Header[0]).getStatusCode());
        rh.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("searchguard/" + this.getType() + "/y", "{}", new Header[0]).getStatusCode());
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    @Ignore(value="TODO why is this ignored?")
    public void testHTTPPlaintextErrMsg() throws Exception {
        try {
            Settings settings = Settings.builder().put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).put("searchguard.ssl.http.enabled", true).build();
            this.setup(settings);
            RestHelper rh = this.nonSslRestHelper();
            rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf"));
            Assert.fail((String)"NoHttpResponseException expected");
        }
        catch (NoHttpResponseException e) {
            String log = FileUtils.readFileToString((File)new File("unittest.log"), (Charset)StandardCharsets.UTF_8);
            Assert.assertTrue((String)log, (boolean)log.contains("speaks http plaintext instead of ssl, will close the channel"));
        }
        catch (Exception e) {
            Assert.fail((String)("NoHttpResponseException expected but was " + e.getClass() + "#" + e.getMessage()));
        }
    }

    @Test
    public void testHTTPProxyDefault() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_proxy.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user-wrong", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")}).getStatusCode());
        Assert.assertEquals((long)400L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a"), new BasicHeader("x-proxy-user", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)400L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a,b,c"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("X-Proxy-User", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
    }

    @Test
    public void testHTTPProxyRolesSeparator() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_proxy_custom.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("user", "scotty"), new BasicHeader("roles", "starfleet,engineer")});
        Assert.assertTrue((String)"Expected one backend role since separator is incorrect", (boolean)res.getBody().contains("\"backend_roles\":[\"starfleet,engineer\"]"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "127.0.0.1,192.168.0.1,10.0.0.2"), new BasicHeader("user", "scotty"), new BasicHeader("roles", "starfleet;engineer")});
        Assert.assertTrue((String)("Expected two backend roles string since separator is correct: " + res.getBody()), (boolean)res.getBody().contains("\"backend_roles\":[\"starfleet\",\"engineer\"]"));
    }

    @Test
    public void testHTTPBasic2() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/2", "{}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("xxxxyyyy/_doc/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("abc", "abc:abc")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithnopassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithblankpassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic wrongheader")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic ")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("picard", "picard")).getStatusCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        }
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("/theindex", "{}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("/theindex/_doc/1?refresh=true", "{\"a\":0}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("/theindex/_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_analyze", "{\"text\": \"sample text\"}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("/theindex", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("/klingonempire", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_close", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("/searchguard/_mapping", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/2", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/_doc/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/_doc/0", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_cat/indices/public", HttpIntegrationTests.encodeBasicHeader("bug108", "nagilum"));
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("role01_role02/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01_role02_role03", "user_role01_role02_role03")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("role01_role02/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01", "user_role01")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("spock/_search?pretty", HttpIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("spock/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("kirk/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
    }

    @Test
    public void testBulk() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgRoles("sg_roles_bulk.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\",  \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\",  \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
        RestHelper.HttpResponse res = rh.executePostRequest("_bulk", bulkBody, HttpIntegrationTests.encodeBasicHeader("bulk", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\":201"));
    }

    @Ignore(value="Fails because the NOOP auth domain no longer allows impersonation. Are there any real-life uses for this?")
    @Test
    public void testRestImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"someotherusernotininternalusersfile"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_rest_impersonation.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "someotherusernotininternalusersfile"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("User someotherusernotininternalusersfile"));
        Assert.assertFalse((String)res.getBody(), (boolean)res.getBody().contains("worf"));
    }

    @Test
    public void testSslOnlyMode() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl_only", true).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/sslinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/xyz/_doc/1", "{\"a\":5}", new Header[0]);
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_mappings", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_search", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    @Ignore(value="fails after rebase")
    public void testAll() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("abcdef").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_all/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("*/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Ignore(value="TODO replacement")
    @Test
    public void testRateLimiting() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_auth_ratelimiting.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x1", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x2", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x3", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x4", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x5", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x6", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x7", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x8", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testEnvReplace() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("index1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("index2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("index3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("env.replace@example.comp.com").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/index1/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/index2/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/env.replace@example.comp.com/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
    }
}

