/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.junit.AsyncAssert;
import java.time.Duration;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.TimeValue;
import org.junit.Assert;
import org.junit.Test;

public class InitializationIntegrationTests
extends SingleClusterTest {
    @Test
    public void testEnsureInitViaRestDoesWork() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"truststore.jks")).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertEquals((long)503L, (long)rh.executePutRequest("searchguard/_doc/0", "{}", InitializationIntegrationTests.encodeBasicHeader("___", "")).getStatusCode());
        rh.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("searchguard/_doc/config", "{}", InitializationIntegrationTests.encodeBasicHeader("___", "")).getStatusCode());
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testConfigHotReload() throws Exception {
        RestHelper.HttpResponse res;
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Header spock = InitializationIntegrationTests.encodeBasicHeader("spock", "spock");
        for (TransportAddress TransportAddress2 : this.clusterInfo.httpAdresses) {
            RestHelper.HttpResponse res2 = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + TransportAddress2.getAddress() + ":" + TransportAddress2.getPort() + "/_searchguard/authinfo?pretty=true"), spock);
            Assert.assertTrue((boolean)res2.getBody().contains("spock"));
            Assert.assertFalse((boolean)res2.getBody().contains("additionalrole"));
            Assert.assertTrue((boolean)res2.getBody().contains("vulcan"));
        }
        Client tc = this.getPrivilegedInternalNodeClient();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        tc.index(((IndexRequest)new IndexRequest("searchguard").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("internalusers").source(new Object[]{"internalusers", FileHelper.readYamlContent((String)"sg_internal_users_spock_add_roles.yml")})).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        for (TransportAddress TransportAddress3 : this.clusterInfo.httpAdresses) {
            this.log.debug("http://" + TransportAddress3.getAddress() + ":" + TransportAddress3.getPort());
            res = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + TransportAddress3.getAddress() + ":" + TransportAddress3.getPort() + "/_searchguard/authinfo?pretty=true"), spock);
            Assert.assertTrue((boolean)res.getBody().contains("spock"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole1"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole2"));
            Assert.assertFalse((boolean)res.getBody().contains("starfleet"));
        }
        tc = this.getPrivilegedInternalNodeClient();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        tc.index(((IndexRequest)new IndexRequest("searchguard").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("config").source(new Object[]{"config", FileHelper.readYamlContent((String)"sg_config_anon.yml")})).actionGet();
        cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        for (TransportAddress TransportAddress3 : this.clusterInfo.httpAdresses) {
            res = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + TransportAddress3.getAddress() + ":" + TransportAddress3.getPort() + "/_searchguard/authinfo?pretty=true"), new Header[0]);
            this.log.debug(res.getBody());
            Assert.assertTrue((boolean)res.getBody().contains("sg_role_host1"));
            Assert.assertTrue((boolean)res.getBody().contains("sg_anonymous"));
            Assert.assertTrue((boolean)res.getBody().contains("User sg_anonymous"));
            Assert.assertTrue((boolean)res.getBody().contains("roles=[sg_anonymous_backendrole]"));
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
        }
    }

    @Test
    public void testDefaultConfig() throws Exception {
        Settings settings = Settings.builder().put("searchguard.allow_default_init_sgindex", true).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.nonSslRestHelper();
        AsyncAssert.awaitAssert((String)"Index was initialized", () -> rh.executeGetRequest("", InitializationIntegrationTests.encodeBasicHeader("admin", "admin")).getStatusCode() == 200, (Duration)Duration.ofSeconds(15L));
    }

    @Test
    public void testDisabled() throws Exception {
        Settings settings = Settings.builder().put("searchguard.disabled", true).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("hits"));
    }

    @Test
    public void testDiscoveryWithoutInitialization() throws Exception {
        this.setup(Settings.EMPTY, null, Settings.EMPTY, false);
        TimeValue masterNodeTimeout = TimeValue.timeValueSeconds((long)40L);
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(masterNodeTimeout).waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(masterNodeTimeout).waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testDefaultInit() throws Exception {
        Settings b = Settings.builder().put("searchguard.allow_default_init_sgindex", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), b, false);
        RestHelper rh = this.nonSslRestHelper();
        AsyncAssert.awaitAssert((String)"License present", () -> {
            Thread.sleep(5000L);
            RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", new Header[0]);
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
            this.assertContains(res, "*TRIAL*");
            this.assertNotContains(res, "*FULL*");
            return true;
        }, (Duration)Duration.ofSeconds(10L));
    }
}

