/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.certificate.NodeCertificateType;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.test.helper.cluster.TestCertificateBasedSSLContextProvider;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.junit.Assert;
import org.junit.Test;

public class SSLReloadCertsActionTests
extends SingleClusterTest {
    private final String GET_CERT_DETAILS_ENDPOINT = "/_searchguard/sslinfo?show_server_certs=true";
    private final String GET_CERT_FULL_DETAILS_ENDPOINT = "/_searchguard/sslinfo?show_full_server_certs=true";
    private final String RELOAD_TRANSPORT_CERTS_ENDPOINT = "/_searchguard/api/ssl/transport/reloadcerts";
    private final String RELOAD_HTTP_CERTS_ENDPOINT = "/_searchguard/api/ssl/http/reloadcerts";

    @Test
    public void testReloadTransportSSLCertsPass() throws Exception {
        TestCertificates certificatesContext = this.prepareTestCertificates(2);
        TestCertificate initialNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(0);
        TestCertificate newNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(1);
        LocalCluster cluster = this.initTestCluster(certificatesContext, initialNodeCertificate, initialNodeCertificate, true);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse certDetailsResponse = restClient.get("/_searchguard/sslinfo?show_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            List<String> nodeCertsAsStrings = this.certificatesToListOfString(initialNodeCertificate.getCertificate());
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("transport_certificates_list"));
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("http_certificates_list"));
            GenericRestClient.HttpResponse certDetailsResponseFull = restClient.get("/_searchguard/sslinfo?show_full_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponseFull.getBodyAsDocNode().getAsListOfStrings("transport_certificates_list"));
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponseFull.getBodyAsDocNode().getAsListOfStrings("http_certificates_list"));
            FileHelper.copyFileContents((String)newNodeCertificate.getCertificateFile().getAbsolutePath(), (String)initialNodeCertificate.getCertificateFile().getAbsolutePath());
            FileHelper.copyFileContents((String)newNodeCertificate.getPrivateKeyFile().getAbsolutePath(), (String)initialNodeCertificate.getPrivateKeyFile().getAbsolutePath());
            GenericRestClient.HttpResponse reloadCertsResponse = restClient.post("/_searchguard/api/ssl/transport/reloadcerts");
            Assert.assertEquals((long)200L, (long)reloadCertsResponse.getStatusCode());
            Assert.assertEquals((String)reloadCertsResponse.getBody(), (Object)ImmutableMap.of((Object)"message", (Object)"updated transport certs"), (Object)DocReader.json().read(reloadCertsResponse.getBody()));
            certDetailsResponse = restClient.get("/_searchguard/sslinfo?show_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            List<String> newNodeCertsAsStrings = this.certificatesToListOfString(newNodeCertificate.getCertificate());
            Assert.assertEquals(newNodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("transport_certificates_list"));
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("http_certificates_list"));
        }
    }

    @Test
    public void testReloadHttpSSLCertsPass() throws Exception {
        TestCertificates certificatesContext = this.prepareTestCertificates(2);
        TestCertificate initialNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(0);
        TestCertificate newNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(1);
        LocalCluster cluster = this.initTestCluster(certificatesContext, initialNodeCertificate, initialNodeCertificate, true);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse certDetailsResponse = restClient.get("/_searchguard/sslinfo?show_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            List<String> nodeCertsAsStrings = this.certificatesToListOfString(initialNodeCertificate.getCertificate());
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("transport_certificates_list"));
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("http_certificates_list"));
            FileHelper.copyFileContents((String)newNodeCertificate.getCertificateFile().getAbsolutePath(), (String)initialNodeCertificate.getCertificateFile().getAbsolutePath());
            FileHelper.copyFileContents((String)newNodeCertificate.getPrivateKeyFile().getAbsolutePath(), (String)initialNodeCertificate.getPrivateKeyFile().getAbsolutePath());
            GenericRestClient.HttpResponse reloadCertsResponse = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
            Assert.assertEquals((long)200L, (long)reloadCertsResponse.getStatusCode());
            Assert.assertEquals((String)reloadCertsResponse.getBody(), (Object)ImmutableMap.of((Object)"message", (Object)"updated http certs"), (Object)DocReader.json().read(reloadCertsResponse.getBody()));
            certDetailsResponse = restClient.get("/_searchguard/sslinfo?show_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("transport_certificates_list"));
            List<String> newNodeCertsAsStrings = this.certificatesToListOfString(newNodeCertificate.getCertificate());
            Assert.assertEquals(newNodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getAsListOfStrings("http_certificates_list"));
        }
    }

    @Test
    public void testReloadHttpSSLCerts_FailWrongUri() throws Exception {
        TestCertificates certificatesContext = this.prepareTestCertificates(1);
        TestCertificate initialNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(0);
        LocalCluster cluster = this.initTestCluster(certificatesContext, initialNodeCertificate, initialNodeCertificate, true);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse reloadCertsResponse = restClient.post("_searchguard/_security/api/ssl/wrong/reloadcerts");
            Assert.assertEquals((long)400L, (long)reloadCertsResponse.getStatusCode());
            Assert.assertEquals((String)reloadCertsResponse.getBody(), (Object)ImmutableMap.of((Object)"error", (Object)"no handler found for uri [/_searchguard/_security/api/ssl/wrong/reloadcerts] and method [POST]"), (Object)DocReader.json().read(reloadCertsResponse.getBody()));
        }
    }

    @Test
    public void testSSLReloadFail_UnAuthorizedUser() throws Exception {
        TestCertificates certificatesContext = this.prepareTestCertificates(1);
        TestCertificate initialNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(0);
        LocalCluster cluster = this.initTestCluster(certificatesContext, initialNodeCertificate, initialNodeCertificate, true);
        try (GenericRestClient restClient = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse reloadCertsResponse = restClient.post("/_searchguard/api/ssl/transport/reloadcerts");
            Assert.assertEquals((long)401L, (long)reloadCertsResponse.getStatusCode());
            Assert.assertEquals((Object)"Unauthorized", (Object)reloadCertsResponse.getStatusReason());
        }
    }

    @Test
    public void testSSLReloadFail_NoReloadSet() throws Exception {
        TestCertificates certificatesContext = this.prepareTestCertificates(1);
        TestCertificate initialNodeCertificate = (TestCertificate)certificatesContext.getNodesCertificates().get(0);
        LocalCluster cluster = this.initTestCluster(certificatesContext, initialNodeCertificate, initialNodeCertificate, false);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse reloadCertsResponse = restClient.post("/_searchguard/api/ssl/transport/reloadcerts");
            Assert.assertEquals((long)400L, (long)reloadCertsResponse.getStatusCode());
            Assert.assertEquals((Object)"SSL Reload action called while searchguard.ssl.cert_reload_enabled is set to false.", (Object)reloadCertsResponse.getBody());
        }
    }

    @Test
    public void testReloadCa() throws Exception {
        GenericRestClient.HttpResponse reloadCertsResponse;
        TestCertificates initialCertificatesContext = this.prepareTestCertificates(1);
        TestCertificate initialNodeCertificate = (TestCertificate)initialCertificatesContext.getNodesCertificates().get(0);
        TestCertificate initialAdminCertificate = initialCertificatesContext.getAdminCertificate();
        TestCertificate initialRootCertificate = initialCertificatesContext.getCaCertificate();
        TestCertificates newCertificatesContext = this.prepareTestCertificates(1);
        TestCertificate newNodeCertificate = (TestCertificate)newCertificatesContext.getNodesCertificates().get(0);
        TestCertificate newAdminCertificate = newCertificatesContext.getAdminCertificate();
        TestCertificate newRootCertificate = newCertificatesContext.getCaCertificate();
        LocalCluster cluster = this.initTestCluster(initialCertificatesContext, initialNodeCertificate, initialNodeCertificate, true);
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse certDetailsResponse = restClient.get("/_searchguard/sslinfo?show_server_certs=true", new Header[0]);
            Assert.assertEquals((long)200L, (long)certDetailsResponse.getStatusCode());
            List<String> nodeCertsAsStrings = this.certificatesToListOfString(initialNodeCertificate.getCertificate());
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getListOfStrings("transport_certificates_list"));
            Assert.assertEquals(nodeCertsAsStrings, (Object)certDetailsResponse.getBodyAsDocNode().getListOfStrings("http_certificates_list"));
            String initialAndNewRootCa = String.join((CharSequence)"\n", FileUtils.readFileToString((File)new File(initialRootCertificate.getCertificateFile().getAbsolutePath()), (Charset)StandardCharsets.UTF_8), FileUtils.readFileToString((File)new File(newRootCertificate.getCertificateFile().getAbsolutePath()), (Charset)StandardCharsets.UTF_8));
            FileHelper.writeFile((String)initialRootCertificate.getCertificateFile().getAbsolutePath(), (String)initialAndNewRootCa);
            GenericRestClient.HttpResponse reloadCertsResponse2 = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
            Assert.assertEquals((String)reloadCertsResponse2.getBody(), (long)200L, (long)reloadCertsResponse2.getStatusCode());
            FileHelper.copyFileContents((String)newNodeCertificate.getCertificateFile().getAbsolutePath(), (String)initialNodeCertificate.getCertificateFile().getAbsolutePath());
            FileHelper.copyFileContents((String)newNodeCertificate.getPrivateKeyFile().getAbsolutePath(), (String)initialNodeCertificate.getPrivateKeyFile().getAbsolutePath());
            reloadCertsResponse2 = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
            Assert.assertEquals((String)reloadCertsResponse2.getBody(), (long)200L, (long)reloadCertsResponse2.getStatusCode());
            FileHelper.copyFileContents((String)newRootCertificate.getCertificateFile().getAbsolutePath(), (String)initialRootCertificate.getCertificateFile().getAbsolutePath());
            try {
                reloadCertsResponse2 = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
                Assert.fail((String)("REST request was successful even though node uses new certificate which is not known by local HTTP client: " + reloadCertsResponse2));
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                // empty catch block
            }
        }
        restClient = this.prepareRestClient(cluster.getHttpAddress(), newRootCertificate, initialAdminCertificate, true);
        try {
            reloadCertsResponse = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
            Assert.assertEquals((String)reloadCertsResponse.getBody(), (long)200L, (long)reloadCertsResponse.getStatusCode());
            try {
                reloadCertsResponse = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
                Assert.fail((String)("REST request was successful even though node does not know the old CA anymore. The client however used an admin cert signed with the old CA: " + reloadCertsResponse));
            }
            catch (SocketException | SSLException iOException) {
                // empty catch block
            }
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        FileHelper.copyFileContents((String)newAdminCertificate.getCertificateFile().getAbsolutePath(), (String)initialAdminCertificate.getCertificateFile().getAbsolutePath());
        FileHelper.copyFileContents((String)newAdminCertificate.getPrivateKeyFile().getAbsolutePath(), (String)initialAdminCertificate.getPrivateKeyFile().getAbsolutePath());
        restClient = cluster.getAdminCertRestClient();
        try {
            reloadCertsResponse = restClient.post("/_searchguard/api/ssl/http/reloadcerts");
            Assert.assertEquals((String)reloadCertsResponse.getBody(), (long)200L, (long)reloadCertsResponse.getStatusCode());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    private TestCertificates prepareTestCertificates(int numberOfNodeCerts) {
        TestCertificates.TestCertificatesBuilder builder = TestCertificates.builder();
        builder.ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard");
        builder.addClients(new String[]{"CN=client-0.example.com,OU=SearchGuard,O=SearchGuard"});
        builder.addAdminClients(new String[]{"CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard"});
        IntStream.range(0, numberOfNodeCerts).forEach(i -> builder.addNodes(Collections.singletonList(String.format("CN=node-%s.example.com,OU=SearchGuard,O=SearchGuard", i)), i + 1, null, null, null, NodeCertificateType.transport_and_rest, null));
        return builder.build();
    }

    private LocalCluster initTestCluster(TestCertificates certificatesContext, TestCertificate transportCertificate, TestCertificate httpCertificate, boolean sslCertReload) {
        TestCertificate rootCertificate = certificatesContext.getCaCertificate();
        TestCertificate adminCertificate = certificatesContext.getAdminCertificate();
        return new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).nodeSettings(new Object[]{"searchguard.authcz.admin_dn", Collections.singletonList(adminCertificate.getCertificate().getSubject().toString())}).nodeSettings(new Object[]{"searchguard.nodes_dn", Collections.singletonList(transportCertificate.getCertificate().getSubject().toString())}).nodeSettings(new Object[]{"searchguard.ssl.transport.enabled", true}).nodeSettings(new Object[]{"searchguard.ssl.http.enabled", true}).nodeSettings(new Object[]{"searchguard.ssl.transport.enforce_hostname_verification", false}).nodeSettings(new Object[]{"searchguard.ssl.transport.resolve_hostname", false}).nodeSettings(new Object[]{"searchguard.ssl.transport.pemcert_filepath", transportCertificate.getCertificateFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.transport.pemkey_filepath", transportCertificate.getPrivateKeyFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.transport.pemtrustedcas_filepath", rootCertificate.getCertificateFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.http.pemcert_filepath", httpCertificate.getCertificateFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.http.pemkey_filepath", httpCertificate.getPrivateKeyFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.http.pemtrustedcas_filepath", rootCertificate.getCertificateFile().getAbsolutePath()}).nodeSettings(new Object[]{"searchguard.ssl.cert_reload_enabled", sslCertReload}).embedded().start();
    }

    private GenericRestClient prepareRestClient(InetSocketAddress address, TestCertificate rootCertificate, TestCertificate clientCertificate, boolean clientAuthentication) {
        TestCertificateBasedSSLContextProvider sslContextProvider = new TestCertificateBasedSSLContextProvider(rootCertificate, clientCertificate);
        return new GenericRestClient(address, Collections.emptyList(), sslContextProvider.getSslContext(clientAuthentication), EsClientProvider.UserCredentialsHolder.basic((String)"cert", null), null);
    }

    private List<String> certificatesToListOfString(X509CertificateHolder ... certificates) {
        return Arrays.stream(certificates).map(this::certificateHolderToString).collect(Collectors.toList());
    }

    private String certificateHolderToString(X509CertificateHolder certificateHolder) {
        try {
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
            StringBuilder sb = new StringBuilder("{");
            sb.append("issuer_dn=");
            sb.append(certificate.getIssuerX500Principal().getName()).append(", ");
            sb.append("subject_dn=");
            sb.append(certificate.getSubjectX500Principal().getName()).append(", ");
            sb.append("san=");
            sb.append(certificate.getSubjectAlternativeNames() != null ? certificate.getSubjectAlternativeNames().toString() : "").append(", ");
            sb.append("not_before=");
            sb.append(certificate.getNotBefore().toInstant().toString()).append(", ");
            sb.append("not_after=");
            sb.append(certificate.getNotAfter().toInstant().toString());
            sb.append("}");
            return sb.toString();
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to map certificate holder to string", e);
        }
    }
}

