/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchsupport.junit.AsyncAssert;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SlowIntegrationTests
extends SingleClusterTest {
    public static final TimeValue MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds((long)40L);

    @Ignore(value="TODO why is this ignored?")
    @Test
    public void testCustomInterclusterRequestEvaluator() throws Exception {
        Settings settings = Settings.builder().put("searchguard.cert.intercluster_request_evaluator_class", "com.floragunn.searchguard.AlwaysFalseInterClusterRequestEvaluator").put("discovery.initial_state_timeout", "8s").build();
        this.setup(Settings.EMPTY, null, settings, false, ClusterConfiguration.DEFAULT, 5, 1);
        Assert.assertEquals((long)1L, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testNodeClientAllowedWithServerCertificate() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getStatus());
        Path tmp = Files.createTempDirectory("sgunit", new FileAttribute[0]);
        tmp.toFile().deleteOnExit();
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.roles", "").put("path.home", tmp).put("node.name", "transportclient").put("discovery.initial_state_timeout", "18s").putList("cluster.initial_master_nodes", this.clusterInfo.tcpMasterPortsOnly).putList("discovery.seed_hosts", this.clusterInfo.tcpMasterPortsOnly).build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings).start();){
            Assert.assertFalse((boolean)((ClusterHealthResponse)node.client().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForNodes(String.valueOf(this.clusterInfo.numNodes + 1))).actionGet()).isTimedOut());
            Assert.assertEquals((long)(this.clusterInfo.numNodes + 1), (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificate() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getStatus());
        Path tmp = Files.createTempDirectory("sgunit", new FileAttribute[0]);
        tmp.toFile().deleteOnExit();
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.roles", "").put("path.home", tmp).put("node.name", "transportclient").put("discovery.initial_state_timeout", "8s").putList("cluster.initial_master_nodes", this.clusterInfo.tcpMasterPortsOnly).putList("discovery.seed_hosts", this.clusterInfo.tcpMasterPortsOnly).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"kirk-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "kirk").build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings).start();){
            AsyncAssert.awaitAssert((String)"Node has started", () -> ((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size() == 1, (Duration)Duration.ofSeconds(10L));
        }
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificate2() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForGreenStatus()).actionGet()).getStatus());
        Path tmp = Files.createTempDirectory("sgunit", new FileAttribute[0]);
        tmp.toFile().deleteOnExit();
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.roles", "").put("path.home", tmp).put("node.name", "transportclient").put("discovery.initial_state_timeout", "8s").putList("cluster.initial_master_nodes", this.clusterInfo.tcpMasterPortsOnly).putList("discovery.seed_hosts", this.clusterInfo.tcpMasterPortsOnly).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings).start();){
            AsyncAssert.awaitAssert((String)"Node has started", () -> ((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size() == 1, (Duration)Duration.ofSeconds(10L));
        }
    }
}

