/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotRestoreTests
extends SingleClusterTest {
    @Parameterized.Parameter
    public ClusterConfiguration currentClusterConfig;

    @Parameterized.Parameters
    public static Collection<ClusterConfiguration> data() {
        return Arrays.asList(ClusterConfiguration.DEFAULT);
    }

    @Ignore
    @Test
    public void testSnapshotEnableSgIndexRestore() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.check_snapshot_restore_write_privileges", false).put("searchguard.unsupported.restore.sgindex.enabled", true).build();
        this.setup(settings, this.currentClusterConfig);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "vulcangov").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "searchguard").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "all").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse response = rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("searchguard_copy", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("searchguard/_close", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("searchguard/_open", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testSnapshot() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.check_snapshot_restore_write_privileges", false).build();
        this.setup(settings, this.currentClusterConfig);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "vulcangov").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "searchguard").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "all").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testSnapshotCheckWritePrivileges() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).build();
        this.setup(settings, this.currentClusterConfig);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "vulcangov").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "searchguard").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "all").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all")).get();
        tc.admin().cluster().createSnapshot(new CreateSnapshotRequest(TimeValue.timeValueSeconds((long)30L), "all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.currentClusterConfig.getNodes(), (long)cur.getNodes().size());
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse response = rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((String)response.getBody(), (long)403L, (long)response.getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_restore_1\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_restore_2a\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_1\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_2\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_3\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_4\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
    }

    @Test
    public void testSnapshotRestore() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgActionGroups("sg_action_groups_packaged.yml"), settings, true, this.currentClusterConfig);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("testsnap1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("testsnap2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("testsnap3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("testsnap4").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("testsnap5").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("testsnap6").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().cluster().preparePutRepository(TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), "bckrepo").setType("fs").setSettings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/bckrepo")).get();
        RestHelper rh = this.nonSslRestHelper();
        String putSnapshot = "{\"indices\": \"testsnap1\",\"ignore_unavailable\": false,\"include_global_state\": false}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        putSnapshot = "{\"indices\": \"searchguard\",\"ignore_unavailable\": false,\"include_global_state\": false}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        putSnapshot = "{\"indices\": \"testsnap2\",\"ignore_unavailable\": false,\"include_global_state\": true}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
    }
}

