/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.test;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SGTestWatcher;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.DefaultBuiltInExecutorBuilders;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.internal.BuiltInExecutorBuilders;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;

public abstract class AbstractSGUnitTest {
    protected static boolean withRemoteCluster;
    protected final Logger log = LogManager.getLogger(this.getClass());
    public static final ThreadPool MOCK_POOL;
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TemporaryFolder repositoryPath = new TemporaryFolder();
    @Rule
    public final TestWatcher testWatcher = new SGTestWatcher();

    public static Header encodeBasicHeader(String username, String password) {
        return new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    @SafeVarargs
    protected static Collection<Class<? extends Plugin>> asCollection(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings.Builder minimumSearchGuardSettingsBuilder(int node, boolean sslOnly, boolean hasCustomTransportSettings) {
        try {
            String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
            Settings.Builder builder = Settings.builder();
            if (!hasCustomTransportSettings) {
                builder.put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "node-0-keystore.jks"))).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "truststore.jks"))).put("searchguard.ssl.transport.enforce_hostname_verification", false);
            }
            if (!sslOnly) {
                builder.putList("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"});
                builder.put("searchguard.background_init_if_sgindex_not_exist", false);
            }
            return builder;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected NodeSettingsSupplier minimumSearchGuardSettings(final Settings other) {
        return new NodeSettingsSupplier(){

            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, false, AbstractSGUnitTest.this.hasCustomTransportSettings(other)).put(other).build();
            }
        };
    }

    protected boolean hasCustomTransportSettings(Settings customSettings) {
        return customSettings.get("searchguard.ssl.transport.pemcert_filepath") != null;
    }

    protected NodeSettingsSupplier minimumSearchGuardSettingsSslOnly(final Settings other) {
        return new NodeSettingsSupplier(){

            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, true, AbstractSGUnitTest.this.hasCustomTransportSettings(other)).put(other).build();
            }
        };
    }

    protected void initialize(Client client) {
        this.initialize(client, new DynamicSgConfig());
    }

    protected void initialize(Client tc, DynamicSgConfig sgconfig) {
        try (ThreadContext.StoredContext ctx = tc.threadPool().getThreadContext().stashContext();){
            tc.threadPool().getThreadContext().putHeader("_sg_conf_request", "true");
            try {
                tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (IndexRequest ir : sgconfig.getDynamicConfig(this.getResourceFolder())) {
                DocWriteResponse docWriteResponse = (DocWriteResponse)tc.index(ir).actionGet();
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0]))).actionGet();
            Assert.assertFalse((String)cur.failures().toString(), (boolean)cur.hasFailures());
            SearchResponse sr = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            sr.decRef();
            sr = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            sr.decRef();
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "config")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "internalusers")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "roles")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "rolesmapping")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "actiongroups")).actionGet()).isExists());
            Assert.assertFalse((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "rolesmapping_xcvdnghtu165759i99465")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "config")).actionGet()).isExists());
        }
    }

    protected final void assertContains(RestHelper.HttpResponse res, String pattern) {
        Assert.assertTrue((boolean)WildcardMatcher.match((String)pattern, (String)res.getBody()));
    }

    protected final void assertNotContains(RestHelper.HttpResponse res, String pattern) {
        Assert.assertFalse((boolean)WildcardMatcher.match((String)pattern, (String)res.getBody()));
    }

    protected String getResourceFolder() {
        return null;
    }

    protected final String getType() {
        return "_doc";
    }

    static {
        System.out.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        System.out.println("Java Version: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        System.out.println("JVM Impl.: " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name"));
        withRemoteCluster = Boolean.parseBoolean(System.getenv("TESTARG_unittests_with_remote_cluster"));
        System.out.println("With remote cluster: " + withRemoteCluster);
        MOCK_POOL = new ThreadPool(Settings.builder().put("node.name", "mock").build(), MeterRegistry.NOOP, (BuiltInExecutorBuilders)new DefaultBuiltInExecutorBuilders(), new ExecutorBuilder[0]);
    }
}

