/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class LicenseTests
extends SingleClusterTest {
    ClusterService cs = (ClusterService)Mockito.mock(ClusterService.class);
    DiscoveryNodes dns = (DiscoveryNodes)Mockito.mock(DiscoveryNodes.class);
    ClusterState cstate = (ClusterState)Mockito.mock(ClusterState.class);

    @Override
    @Before
    public void setup() {
        Mockito.when((Object)this.dns.getSize()).thenReturn((Object)10);
        Mockito.when((Object)this.cstate.getNodes()).thenReturn((Object)this.dns);
        Mockito.when((Object)this.cs.state()).thenReturn((Object)this.cstate);
    }

    @Ignore(value="TODO test invalid license signature when uploading new license")
    @Test
    public void testInvalidLicense() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_invalidlic.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*TRIAL*");
        this.assertContains(res, "*Invalid license signature*");
        this.assertNotContains(res, "*FULL*");
    }

    @Test
    public void testTrialLicense() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*TRIAL*");
        this.assertNotContains(res, "*FULL*");
    }

    @Test
    public void testFullLicense() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_lic.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", LicenseTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("FULL"));
        Assert.assertTrue((boolean)res.getBody().contains("is_valid\" : true"));
    }

    @Test
    public void testComplianceLicense() throws Exception {
        String now = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).format(new Date());
        SearchGuardLicense license = SearchGuardLicense.createTrialLicense((String)now, (String)"");
        license.dynamicValidate(this.cs);
        Assert.assertTrue((boolean)license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE));
        Assert.assertArrayEquals((Object[])license.getFeatures(), (Object[])SearchGuardLicense.Feature.values());
        Assert.assertTrue((boolean)license.isValid());
        Assert.assertFalse((boolean)license.isExpired());
        Assert.assertEquals((long)60L, (long)license.getExpiresInDays());
    }

    @Test
    public void testComplianceLicenseMap() throws Exception {
        SearchGuardLicense license = new SearchGuardLicense((Map)XContentHelper.convertToMap((BytesReference)new BytesArray(FileHelper.loadFile((String)"license1.json")), (boolean)false, (XContentType)JsonXContent.jsonXContent.type()).v2());
        Assert.assertFalse((boolean)license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE));
        Assert.assertArrayEquals((Object[])license.getFeatures(), (Object[])new SearchGuardLicense.Feature[0]);
        license = new SearchGuardLicense((Map)XContentHelper.convertToMap((BytesReference)new BytesArray(FileHelper.loadFile((String)"license3.json")), (boolean)false, (XContentType)JsonXContent.jsonXContent.type()).v2());
        Assert.assertFalse((boolean)license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE));
        Assert.assertArrayEquals((Object[])license.getFeatures(), (Object[])new SearchGuardLicense.Feature[0]);
        license = new SearchGuardLicense((Map)XContentHelper.convertToMap((BytesReference)new BytesArray(FileHelper.loadFile((String)"license2.json")), (boolean)false, (XContentType)JsonXContent.jsonXContent.type()).v2());
        Assert.assertTrue((boolean)license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE));
        Assert.assertArrayEquals((Object[])license.getFeatures(), (Object[])SearchGuardLicense.Feature.values());
    }

    @Test
    public void testFullLicenseRK() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_lic_rk.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", LicenseTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("FULL"));
        Assert.assertTrue((boolean)res.getBody().contains("is_valid\" : true"));
    }

    @Test
    public void testFullLicenseReload() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_lic.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", LicenseTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("FULL"));
        Assert.assertTrue((boolean)res.getBody().contains("is_valid\" : true"));
        this.initialize(this.getPrivilegedInternalNodeClient(), new DynamicSgConfig().setSgConfig("sg_config_lic.yml"));
        res = rh.executeGetRequest("_searchguard/license?pretty", LicenseTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("FULL"));
        Assert.assertFalse((boolean)res.getBody().contains("TRIAL"));
        Assert.assertTrue((boolean)res.getBody().contains("is_valid\" : true"));
    }
}

