/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;

public class CrossClusterSearchWithoutRemoteClusterSetupTest {
    public static final TestSgConfig.User USER_ADMIN = new TestSgConfig.User("admin").roles(new TestSgConfig.Role[]{TestSgConfig.Role.ALL_ACCESS});
    public static final TestSgConfig.User USER_LIMITED = new TestSgConfig.User("limited").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("limited").clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).on(new String[]{"my-index"})});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")})).users(new TestSgConfig.User[]{USER_ADMIN, USER_LIMITED}).sslEnabled().enterpriseModulesEnabled().build();

    @Test
    public void shouldPerformCrossClusterSearchForNonExistingIndex() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_ADMIN, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/*:.monitoring-es/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }

    @Test
    public void shouldPerformCrossClusterSearchForNonExistingIndexWhenLackingPermissionForTheIndex() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_LIMITED, new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/*:.monitoring-es/_search", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
    }
}

