/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RemoteReindexTests
extends AbstractSGUnitTest {
    private final ClusterHelper cl1 = new ClusterHelper("crl1_n", 0);
    private final ClusterHelper cl2 = new ClusterHelper("crl2_n", 1);
    private ClusterInfo cl1Info;
    private ClusterInfo cl2Info;

    private void setupReindex() throws Exception {
        System.setProperty("sg.display_lic_none", "true");
        this.cl2Info = this.cl2.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.DEFAULT);
        this.initialize((Client)PrivilegedConfigClient.adapt((Client)this.cl2.nodeClient()));
        this.cl1Info = this.cl1.startCluster(this.minimumSearchGuardSettings(this.crossClusterNodeSettings(this.cl2Info)), ClusterConfiguration.DEFAULT);
        this.initialize((Client)PrivilegedConfigClient.adapt((Client)this.cl1.nodeClient()));
    }

    @After
    public void tearDown() throws Exception {
        this.cl1.stopCluster();
        this.cl2.stopCluster();
    }

    private Settings crossClusterNodeSettings(ClusterInfo remote) {
        Settings.Builder builder = Settings.builder().putList("reindex.remote.whitelist", new String[]{remote.httpHost + ":" + remote.httpPort});
        return builder.build();
    }

    @Test
    public void testNonSSLReindex() throws Exception {
        this.setupReindex();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        Client tc = this.cl1.nodeClient();
        tc.admin().indices().create(new CreateIndexRequest("twutter")).actionGet();
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        String reindex = "{\"source\": {\"remote\": {\"host\": \"http://" + this.cl2Info.httpHost + ":" + this.cl2Info.httpPort + "\",\"username\": \"nagilum\",\"password\": \"nagilum\"},\"index\": \"twitter\",\"size\": 10,\"query\": {\"match_all\": {}}},\"dest\": {\"index\": \"twutter\"}}";
        RestHelper.HttpResponse ccs = null;
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("_reindex?pretty", reindex, RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((String)ccs.getBody(), (long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("created\" : 1"));
    }
}

