/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.auth;

import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class HTTPProxyAuthenticator2
implements LegacyHTTPAuthenticator {
    private static final String ATTR_PROXY_PREFIX = "attr.proxy2.";
    private static final String ATTR_PROXY_USERNAME = "attr.proxy2.username";
    private static final String AUTHENTICATION_MODE = "auth_mode";
    private static final String USER_HEADER = "user_header";
    private static final String ROLES_HEADER = "roles_header";
    private static final String ROLES_SEPARATOR = "roles_separator";
    private static final String ALLOWED_DN_S = "allowed_dn_s";
    private static final String ATTRIBUTE_HEADERS = "attribute_headers";
    private static final String BOTH_MODE = "both";
    private static final String CERTIFICATE_MODE = "cert";
    private static final String IP_MODE = "ip";
    private static final String EITHER_MODE = "either";
    private static final String DEFAULT_MODE = "both";
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Settings settings;
    private Map<String, String> attributeMapping;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "proxy2", HTTPProxyAuthenticator2.class).initialized();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "proxy2";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPProxyAuthenticator2::new);
        }
    };

    public HTTPProxyAuthenticator2(Settings settings, Path configPath) {
        this.settings = settings;
        this.attributeMapping = Attributes.getFlatAttributeMapping((Settings)settings.getAsSettings("map_headers_to_user_attrs"));
    }

    public AuthCredentials extractCredentials(RestRequest restRequest, ThreadContext threadContext) {
        String authMode = this.settings.get(AUTHENTICATION_MODE);
        if (Strings.isNullOrEmpty((String)authMode)) {
            authMode = "both";
            if (this.log.isWarnEnabled()) {
                this.log.warn("Authentication mode not configured using default mode '{}'", (Object)"both");
            }
        } else if (!(authMode.equals("both") || authMode.equals(CERTIFICATE_MODE) || authMode.equals(IP_MODE) || authMode.equals(EITHER_MODE))) {
            authMode = "both";
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unknown authentication mode set. Using default authentication mode '{}'.", (Object)"both");
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication mode: '{}'", (Object)authMode);
        }
        if (authMode.equals(EITHER_MODE)) {
            if (!this.xffDone(threadContext) && !this.certificateDone(threadContext)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Authentication failed.");
                }
                return null;
            }
        } else if (authMode.equals("both") ? !this.xffDone(threadContext) || !this.certificateDone(threadContext) : (authMode.equals(CERTIFICATE_MODE) ? !this.certificateDone(threadContext) : authMode.equals(IP_MODE) && !this.xffDone(threadContext))) {
            return null;
        }
        String userHeader = this.settings.get(USER_HEADER);
        String rolesHeader = this.settings.get(ROLES_HEADER);
        String rolesSeparator = this.settings.get(ROLES_SEPARATOR, ",");
        if (this.log.isDebugEnabled()) {
            this.log.debug("headers {}", (Object)restRequest.getHeaders());
            this.log.debug("userHeader {}, value {}", (Object)userHeader, userHeader == null ? null : restRequest.header(userHeader));
            this.log.debug("rolesHeader {}, value {}", (Object)rolesHeader, rolesHeader == null ? null : restRequest.header(rolesHeader));
        }
        if (Strings.isNullOrEmpty((String)userHeader) || Strings.isNullOrEmpty((String)restRequest.header(userHeader))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No '{}' header, send 401", (Object)userHeader);
            }
            return null;
        }
        String[] backendRoles = null;
        if (!Strings.isNullOrEmpty((String)rolesHeader) && !Strings.isNullOrEmpty((String)restRequest.header(rolesHeader))) {
            backendRoles = restRequest.header(rolesHeader).split(rolesSeparator);
        }
        AuthCredentials.Builder authCredentialsBuilder = AuthCredentials.forUser((String)restRequest.header(userHeader)).authenticatorType(this.getType()).backendRoles(backendRoles).complete();
        this.addAdditionalAttributes(authCredentialsBuilder, restRequest);
        this.addAdditionalOldAttributes(authCredentialsBuilder, restRequest);
        return authCredentialsBuilder.build();
    }

    private boolean xffDone(ThreadContext threadContext) {
        if (threadContext.getTransient("_sg_xff_done") != Boolean.TRUE) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("XFF not done, send 401");
            }
            return false;
        }
        return true;
    }

    private boolean certificateDone(ThreadContext threadContext) {
        String principal = (String)threadContext.getTransient("_sg_ssl_principal");
        if (Strings.isNullOrEmpty((String)principal)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No CLIENT CERT, send 401.");
            }
            return false;
        }
        List allowedDNs = this.settings.getAsList(ALLOWED_DN_S);
        if (allowedDNs.isEmpty()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("No trusted DNs configured, send 401.");
            }
            return false;
        }
        if (!WildcardMatcher.matchAny((Collection)allowedDNs, (String)principal)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("DN: {} not trusted, send 401.", (Object)principal);
            }
            return false;
        }
        return true;
    }

    private void addAdditionalAttributes(AuthCredentials.Builder credentials, RestRequest restRequest) {
        for (Map.Entry<String, String> entry : this.attributeMapping.entrySet()) {
            String sourceAttributeName = entry.getValue();
            String targetAttributeName = entry.getKey();
            String attributeValue = restRequest.header(sourceAttributeName);
            if (attributeValue == null) continue;
            credentials.attribute(targetAttributeName, (Object)attributeValue);
        }
    }

    private void addAdditionalOldAttributes(AuthCredentials.Builder credentials, RestRequest restRequest) {
        credentials.oldAttribute(ATTR_PROXY_USERNAME, credentials.getUserName());
        if (this.settings.getAsList(ATTRIBUTE_HEADERS).isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No additional attributes configured.");
            }
            return;
        }
        for (String attributeHeaderName : this.settings.getAsList(ATTRIBUTE_HEADERS)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Configured attribute header name: {}", (Object)attributeHeaderName);
            }
            if (!Strings.isNullOrEmpty((String)attributeHeaderName) && !Strings.isNullOrEmpty((String)restRequest.header(attributeHeaderName))) {
                String attributeValue = restRequest.header(attributeHeaderName);
                credentials.oldAttribute(ATTR_PROXY_PREFIX + attributeHeaderName, attributeValue);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("attributeHeader {}, value {}", (Object)attributeHeaderName, (Object)attributeValue);
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("No additional attributes send.");
        }
    }

    public String getType() {
        return "proxy2";
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

