/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.legacy.auth.HTTPClientCertAuthenticator;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class IntegrationTests
extends SingleClusterTest {
    @Test
    public void testSearchScroll() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> e.printStackTrace());
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        res = rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testDnParsingCertAuth() throws Exception {
        Settings settings = Settings.builder().put("username_attribute", "cn").put("roles_attribute", "l").build();
        HTTPClientCertAuthenticator auth = new HTTPClientCertAuthenticator(settings, null);
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,cn=xxx,l=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("CN=abc,L=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("l=ert,cn=abc,st=zui,c=qwe")).getUsername());
        Assert.assertNull((Object)auth.extractCredentials(null, this.newThreadContext("L=ert,CN=abc,c,st=zui,c=qwe")));
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("l=ert,st=zui,c=qwe,cn=abc")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("L=ert,st=zui,c=qwe,CN=abc")).getUsername());
        Assert.assertEquals((Object)"L=ert,st=zui,c=qwe", (Object)auth.extractCredentials(null, this.newThreadContext("L=ert,st=zui,c=qwe")).getUsername());
        Assert.assertArrayEquals((Object[])new String[]{"ert"}, (Object[])auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getBackendRoles().toArray(new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"bleh", "ert"}, (Object[])new TreeSet(auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,L=bleh,st=zui,c=qwe")).getBackendRoles()).toArray(new String[0]));
        settings = Settings.builder().build();
        auth = new HTTPClientCertAuthenticator(settings, null);
        Assert.assertEquals((Object)"cn=abc,l=ert,st=zui,c=qwe", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
    }

    private ThreadContext newThreadContext(String sslPrincipal) {
        ThreadContext threadContext = new ThreadContext(Settings.EMPTY);
        threadContext.putTransient("_sg_ssl_principal", (Object)sslPrincipal);
        return threadContext;
    }

    @Test
    public void testDNSpecials() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-untspec5-keystore.p12")).put("searchguard.ssl.transport.keystore_alias", "1").put("searchguard.ssl.transport.keystore_type", "PKCS12").putList("searchguard.nodes_dn", new String[]{"EMAILADDRESS=unt@tst.com,CN=node-untspec5.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).putList("searchguard.authcz.admin_dn", new String[]{"EMAILADDRESS=unt@xxx.com,CN=node-untspec6.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).put("searchguard.cert.oid", "1.2.3.4.5.6").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testDNSpecials1() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"node-untspec5-keystore.p12")).put("searchguard.ssl.transport.keystore_alias", "1").put("searchguard.ssl.transport.keystore_type", "PKCS12").putList("searchguard.nodes_dn", new String[]{"EMAILADDRESS=unt@tst.com,CN=node-untspec5.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).putList("searchguard.authcz.admin_dn", new String[]{"EMAILADDREss=unt@xxx.com,  cn=node-untspec6.example.com, OU=SSL,O=Te\\, st,L=Test, c=DE"}).put("searchguard.cert.oid", "1.2.3.4.5.6").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testMultiget() throws Exception {
        this.setup();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("mindex1").id("1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("mindex2").id("2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        String mgetBody = "{\"docs\" : [{\"_index\" : \"mindex1\",\"_id\" : \"1\" }, {\"_index\" : \"mindex2\", \"_id\" : \"2\"}]}";
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executePostRequest("_mget?refresh=true", mgetBody, IntegrationTests.encodeBasicHeader("picard", "picard"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((boolean)resc.getBody().contains("type2"));
    }

    @Test
    public void testRestImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.spock", new String[]{"knuddel", "userwhonotexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), IntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        Assert.assertEquals((long)200L, (long)resp.getStatusCode());
        Assert.assertTrue((String)resp.getBody(), (boolean)resp.getBody().contains("User knuddel"));
        Assert.assertFalse((boolean)resp.getBody().contains("spock"));
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "userwhonotexists"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "invalid"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
    }

    @Test
    public void testSingle() throws Exception {
        this.setup();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("shakespeare").id("1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
        Assert.assertFalse((boolean)cur.hasFailures());
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("shakespeare/_search", IntegrationTests.encodeBasicHeader("picard", "picard"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\":1"));
        resc = rh.executeHeadRequest("shakespeare", IntegrationTests.encodeBasicHeader("picard", "picard"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testSpecialUsernames() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("bug.99", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("a", "b")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("\"'+-,;_?*@<>!$%&/()=#", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("\u00a7\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df", "nagilum")).getStatusCode());
    }

    @Test
    public void testXff() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_xff.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "10.0.0.7"), IntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("10.0.0.7"));
    }

    @Test
    public void testRegexExcludes() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("indexa").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"indexa\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("indexb").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"indexb\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("isallowed").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"isallowed\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("special").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"special\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("alsonotallowed").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"alsonotallowed\":1}", XContentType.JSON)).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("index*/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("indexa/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("isallowed/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("special/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("alsonotallowed/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
    }

    @Test
    public void testMultiRoleSpan2() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_multirolespan.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("mindex_1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("mindex_2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("mindex_3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("mindex_4").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executeGetRequest("/mindex_1,mindex_2/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mindex_1,mindex_3/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mindex_1,mindex_4/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testSGUnderscore() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executePostRequest("abc_xyz_2018_05_24/_doc/1", "{\"content\":1}", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        res = rh.executeGetRequest("abc_xyz_2018_05_24/_doc/1", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("abc_xyz_2018_05_24/_refresh", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("aaa_bbb_2018_05_24/_refresh", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testUpdate() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("indexc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executePostRequest("indexc/_update/0?pretty=true&refresh=true", "{\"doc\" : {\"content\":2}}", IntegrationTests.encodeBasicHeader("user_c", "user_c"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testSgIndexSecurity() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("indexa").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executePutRequest("searchguard,inde*/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*earc*gua*/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePostRequest("searchguard/_close", "", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("searchguard", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("_all", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchgu*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePostRequest("searchguard/_freeze", "", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((res.getStatusCode() >= 400 ? 1 : 0) != 0);
        String bulkBody = "{ \"index\" : { \"_index\" : \"searchguard\", \"_id\" : \"1\" } }\n{ \"field1\" : \"value1\" }\n{ \"index\" : { \"_index\" : \"searchguard\", \"_id\" : \"2\" } }\n{ \"field2\" : \"value2\" }\n{ \"index\" : { \"_index\" : \"myindex\", \"_id\" : \"2\" } }\n{ \"field2\" : \"value2\" }\n{ \"delete\" : { \"_index\" : \"searchguard\", \"_id\" : \"config\" } }\n";
        res = rh.executePostRequest("_bulk?refresh=true&pretty", bulkBody, IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertEquals((long)4L, (long)res.getBody().split("\"status\" : 403,").length);
    }

    @Test
    public void testSgIndexSecurityWithSgIndexExcluded() throws Exception {
        Settings settings = Settings.builder().put("action.destructive_requires_name", false).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("indexa").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executePutRequest("searchguard*,inde*/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*earc*gua*/_mapping?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_mapping?pretty&ignore_unavailable=true", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_mapping?pretty&ignore_unavailable=true", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePostRequest("searchguard/_close", "", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("searchguard", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_settings?ignore_unavailable=true", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_settings?ignore_unavailable=true", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_settings?ignore_unavailable=true", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchgu*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard,-index*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("_all?ignore_unavailable=true", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }
}

