/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class AggregationTests
extends SingleClusterTest {
    @Test
    public void testBasicAggregations() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("xyz").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"xyz"}).alias("alias1"))).actionGet();
        RestHelper.HttpResponse res = rh.executePostRequest("_search?pretty", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertNotContains(res, "*xception*");
        this.assertNotContains(res, "*erial*");
        this.assertNotContains(res, "*mpty*");
        this.assertNotContains(res, "*earchguard*");
        this.assertContains(res, "*vulcangov*");
        this.assertContains(res, "*starfleet*");
        this.assertContains(res, "*klingonempire*");
        this.assertContains(res, "*xyz*");
        this.assertContains(res, "*role01_role02*");
        this.assertContains(res, "*\"failed\" : 0*");
        res = rh.executePostRequest("*/_search?pretty", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":40}}}}", AggregationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertNotContains(res, "*xception*");
        this.assertNotContains(res, "*erial*");
        this.assertNotContains(res, "*mpty*");
        this.assertNotContains(res, "*earchguard*");
        this.assertContains(res, "*vulcangov*");
        this.assertContains(res, "*starfleet*");
        this.assertContains(res, "*klingonempire*");
        this.assertContains(res, "*xyz*");
        this.assertContains(res, "*role01_role02*");
        this.assertContains(res, "*\"failed\" : 0*");
    }
}

