/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class HealthTests
extends SingleClusterTest {
    @Test
    public void testHealth() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty&mode=lenient", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*UP*");
        this.assertNotContains(res, "*DOWN*");
        this.assertNotContains(res, "*strict*");
        res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*UP*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*DOWN*");
    }

    @Test
    public void testHealthUnitialized() throws Exception {
        this.setup(Settings.EMPTY, null, Settings.EMPTY, false);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty&mode=lenient", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*UP*");
        this.assertNotContains(res, "*DOWN*");
        this.assertNotContains(res, "*strict*");
        res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)503L, (long)res.getStatusCode());
        this.assertContains(res, "*DOWN*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*UP*");
    }
}

