/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class IndexIntegrationTests
extends SingleClusterTest {
    @Test
    public void testComposite() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_composite_config.yml").setSgRoles("sg_roles_composite.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        String msearchBody = "{\"index\":\"starfleet\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"klingonempire\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        RestHelper.HttpResponse resc = rh.executePostRequest("_msearch", msearchBody, IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("\"_index\":\"klingonempire\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("hits"));
    }

    @Test
    public void testBulkShards() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgRoles("sg_roles_bs.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("test").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("lorem").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field2\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\",  \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"3\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\",  \"_id\" : \"4\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_id\" : \"5\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\",  \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\",  \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\",  \"_id\" : \"3\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_id\" : \"4\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_id\" : \"5\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"lorem\", \"_id\" : \"5\" } }" + System.lineSeparator();
        RestHelper.HttpResponse res = rh.executePostRequest("_bulk?refresh=true&pretty=true", bulkBody, IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\" : true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\" : 201"));
        Assert.assertTrue((boolean)res.getBody().contains("Insufficient permissions"));
    }

    @Test
    public void testCreateIndex() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((String)"Unable to create index 'nag'", (long)200L, (long)rh.executePutRequest("nag1", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((String)"Unable to create index 'starfleet_library'", (long)200L, (long)rh.executePutRequest("starfleet_library", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        this.clusterHelper.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)10L), this.clusterInfo.numNodes);
        Assert.assertEquals((String)"Unable to close index 'starfleet_library'", (long)200L, (long)rh.executePostRequest("starfleet_library/_close", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse res = rh.executePostRequest("starfleet_library/_open", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((String)"Unable to open index 'starfleet_library'", (long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)"open index 'starfleet_library' not acknowledged", (boolean)res.getBody().contains("acknowledged"));
        Assert.assertFalse((String)"open index 'starfleet_library' not acknowledged", (boolean)res.getBody().contains("false"));
        this.clusterHelper.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)10L), this.clusterInfo.numNodes);
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("public", null, IndexIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
    }

    @Test
    public void testIndices() throws Exception {
        this.setup();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("nopermindex").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-4").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd", Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date());
        DocWriteResponse indexResponse = (DocWriteResponse)tc.index(((IndexRequest)new IndexRequest("logstash-" + date).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = null;
        res = rh.executeGetRequest("/logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex,logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nopermindex/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/does-not-exist-and-no-perm/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", IndexIntegrationTests.encodeBasicHeader("nouser", "nosuer"));
        Assert.assertEquals((long)401L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_all/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nopermindex,logstash-1,nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-1,nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Cnonex-%7Bnow%2Fd%7D%3E/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E,logstash-*/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E,logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/logstash-b/_doc/1", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("/%3Clogstash-cnew-%7Bnow%2Fd%7D%3E", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/%3Clogstash-new-%7Bnow%2Fd%7D%3E/_doc/1", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_cat/indices?v", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("logstash-b"));
        Assert.assertTrue((boolean)res.getBody().contains("logstash-new-20"));
        Assert.assertTrue((boolean)res.getBody().contains("logstash-cnew-20"));
        Assert.assertFalse((boolean)res.getBody().contains("<"));
    }

    @Test
    public void testAliases() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(settings);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("nopermindex").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-4").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-5").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-del").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("logstash-del-ok").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        String date = new SimpleDateFormat("YYYY.MM.dd").format(new Date());
        tc.index(((IndexRequest)new IndexRequest("logstash-" + date).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"nopermindex"}).alias("nopermalias"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"searchguard"}).alias("mysgi"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = null;
        res = rh.executePostRequest("/mysgi/_doc/sg", "{}", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mysgi/_search?pretty", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("/logstash-1/_alias/alog1", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/nonexitent/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("/logstash-nonex/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executePutRequest("/nopermindex/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        String aliasRemoveIndex = "{\"actions\" : [{ \"add\":  { \"index\": \"logstash-del-ok\", \"alias\": \"logstash-del\" } },{ \"remove_index\": { \"index\": \"logstash-del\" } }  ]}";
        res = rh.executePostRequest("/_aliases", aliasRemoveIndex, IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-1/_alias/alog1", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_alias/alog1", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_alias/nopermalias", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        String alias = "{\"aliases\": {\"alias1\": {}}}";
        res = rh.executePutRequest("/beats-withalias", alias, IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    @Ignore(value="Cross-cluster calls are not supported in this context but remote indices were requested")
    public void testCCSIndexResolve() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest(".abc-6").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executeGetRequest("ggg:.abc-6,.abc-6/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc-6,.abc-6/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    @Ignore(value="TODO why is this ignored?")
    public void testCCSIndexResolve2() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest(".abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("xyz").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("noperm").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse res = rh.executeGetRequest("/*:.abc,.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        res = rh.executeGetRequest("/ba*bcuzh/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":12"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz,xyz/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":2"));
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        res = rh.executeGetRequest("/*:xyz/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":2"));
        res = rh.executeGetRequest("/.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc,.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz,xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:noperm/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:noperm/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:noexists/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testIndexResolveIndicesAlias() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.index(((IndexRequest)new IndexRequest("foo-index").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"foo-index"}).alias("foo-alias"))).actionGet();
        tc.admin().indices().delete(new DeleteIndexRequest("foo-index")).actionGet();
        RestHelper.HttpResponse resc = rh.executeGetRequest("/_cat/aliases", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertFalse((boolean)resc.getBody().contains("foo"));
        resc = rh.executeGetRequest("/foo-alias/_search", IndexIntegrationTests.encodeBasicHeader("foo_index", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo-index/_search", IndexIntegrationTests.encodeBasicHeader("foo_index", "nagilum"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo-alias/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
    }
}

