/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class SearchGuardRolesTests
extends SingleClusterTest {
    @Test
    public void testSGRAnon() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgInternalUsers("sg_internal_users_sgr.yml").setSgConfig("sg_config_anon.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo?pretty", new Header[0]);
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertFalse((boolean)resc.getBody().contains("xyz_sgr"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo?pretty", SearchGuardRolesTests.encodeBasicHeader("sgr_user", "nagilum"));
        Assert.assertTrue((boolean)resc.getBody().contains("sgr_user"));
        Assert.assertTrue((boolean)resc.getBody().contains("xyz_sgr"));
        Assert.assertTrue((boolean)resc.getBody().contains("backend_roles=[abc_ber]"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testSGR() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgInternalUsers("sg_internal_users_sgr.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo?pretty", SearchGuardRolesTests.encodeBasicHeader("sgr_user", "nagilum"));
        Assert.assertTrue((boolean)resc.getBody().contains("sgr_user"));
        Assert.assertTrue((boolean)resc.getBody().contains("xyz_sgr"));
        Assert.assertTrue((boolean)resc.getBody().contains("backend_roles=[abc_ber]"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testSGRImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.sgr_user", new String[]{"sgr_impuser"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgInternalUsers("sg_internal_users_sgr.yml"), settings, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo?pretty", new Header[]{SearchGuardRolesTests.encodeBasicHeader("sgr_user", "nagilum"), new BasicHeader("sg_impersonate_as", "sgr_impuser")});
        Assert.assertFalse((boolean)resc.getBody().contains("sgr_user"));
        Assert.assertTrue((boolean)resc.getBody().contains("sgr_impuser"));
        Assert.assertFalse((boolean)resc.getBody().contains("xyz_sgr"));
        Assert.assertTrue((boolean)resc.getBody().contains("xyz_impsgr"));
        Assert.assertTrue((boolean)resc.getBody().contains("backend_roles=[ert_ber]"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("*/_search?pretty", new Header[]{SearchGuardRolesTests.encodeBasicHeader("sgr_user", "nagilum"), new BasicHeader("sg_impersonate_as", "sgr_impuser")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }
}

