/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="subject for manual execution")
public class TracingTests
extends SingleClusterTest {
    @Test
    public void testAdvancedMapping() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("myindex1").mapping(FileHelper.loadFile((String)"mapping1.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex2").mapping(FileHelper.loadFile((String)"mapping2.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex3").mapping(FileHelper.loadFile((String)"mapping3.json"))).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("myindex4").mapping(FileHelper.loadFile((String)"mapping4.json"))).actionGet();
        RestHelper rh = this.nonSslRestHelper();
        String data1 = FileHelper.loadFile((String)"data1.json");
        String parent = FileHelper.loadFile((String)"data2.json");
        String child = FileHelper.loadFile((String)"data3.json");
    }

    @Test
    public void testHTTPTraceNoSource() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("a")).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("c")).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("test")).actionGet();
        tc.admin().indices().create(new CreateIndexRequest("u")).actionGet();
        tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"a"}).source(new String[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
        tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"c"}).source(new String[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
        tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"test"}).source(new String[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
        tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"u"}).source(new String[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
        for (int i = 0; i < 50; ++i) {
            tc.index(((IndexRequest)new IndexRequest("a").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("c").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        String msearchBody = "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        String mgetBody = "{\"docs\" : [{\"_index\" : \"a\",\"_type\" : \"b\",\"_id\" : \"1\" }, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"12\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"13\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"14\"}]}";
        String dbqBody = "{  \"query\": {     \"match\": {      \"content\": 12    }  }}";
        Thread.sleep(5000L);
    }

    @Test
    public void testHTTPSingle() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
        tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_academy").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("starfleet_library").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("klingonempire").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("spock").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("kirk").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("role01_role02").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        Thread.sleep(5000L);
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", TracingTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Thread.sleep(5000L);
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator();
        Thread.sleep(5000L);
    }

    @Test
    public void testSearchScroll() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        Client tc = this.getPrivilegedInternalNodeClient();
        for (int i = 0; i < 3; ++i) {
            tc.index(((IndexRequest)new IndexRequest("vulcangov").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", TracingTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        res = rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", TracingTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testHTTPTrace() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        Client tc = this.getPrivilegedInternalNodeClient();
        for (int i = 0; i < 50; ++i) {
            tc.index(((IndexRequest)new IndexRequest("a").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("c").id("" + i).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        String reindex = "{  \"source\": {    \"index\": \"a\"  },  \"dest\": {    \"index\": \"new_a\"  }}";
        String msearchBody = "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        String mgetBody = "{\"docs\" : [{\"_index\" : \"a\",\"_type\" : \"b\",\"_id\" : \"1\" }, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"12\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"13\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"14\"}]}";
        String dbqBody = "{  \"query\": {     \"match\": {      \"content\": 12    }  }}";
        Thread.sleep(5000L);
    }
}

