/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authc.rest.AuthenticatingRestFilter;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.InetSocketAddress;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class Double401ResponsesIntTest {
    private static final Logger log = LogManager.getLogger(Double401ResponsesIntTest.class);
    private static TestSgConfig.User USER = new TestSgConfig.User("user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("role").indexPermissions(new String[]{"*"}).on(new String[]{"*"})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().singleNode().sslEnabled().resources("doubleUnauthorized").users(new TestSgConfig.User[]{USER}).embedded().build();
    @Mock
    private RestRequest restRequest;
    @Mock
    private RestChannel restChannel;
    @Mock
    private HttpChannel httpChannel;
    @Captor
    private ArgumentCaptor<RestResponse> responseCaptor;
    @Mock
    private HttpServerTransport.Dispatcher genuineDispatcher;
    @Mock
    private ThreadContext threadContext;
    @Mock
    private HttpRequest httpRequest;
    private HttpServerTransport.Dispatcher searchGuarddispatcher;
    private AuthenticatingRestFilter authenticatingRestFilter;

    @Before
    public void before() {
        this.authenticatingRestFilter = (AuthenticatingRestFilter)cluster.getInjectable(AuthenticatingRestFilter.class);
        this.searchGuarddispatcher = this.authenticatingRestFilter.wrap(this.genuineDispatcher);
    }

    @Test
    @Ignore(value="This test is for manual execution only, to reproduce bug related to double 401 responses")
    public void reproduceDouble401ResponsesBug() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "Bearer invalid_token")});){
            GenericRestClient.HttpResponse response = client.get("_searchguard/authinfo", new Header[0]);
            log.debug("Actual response is '{}'", (Object)response.getBody());
        }
    }

    @Test
    public void shouldSend401ResponseOnce() {
        Mockito.when((Object)this.restRequest.getHttpRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.restChannel.request()).thenReturn((Object)this.restRequest);
        Mockito.when((Object)this.restRequest.getHttpChannel()).thenReturn((Object)this.httpChannel);
        Mockito.when((Object)this.restRequest.path()).thenReturn((Object)"/_searchguard/authinfo");
        Mockito.when((Object)this.restRequest.method()).thenReturn((Object)RestRequest.Method.GET);
        Mockito.when((Object)this.restRequest.getHeaders()).thenReturn((Object)ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)"Bearer invalid_token")));
        Mockito.when((Object)this.restRequest.getRequestId()).thenReturn((Object)-1234L);
        Mockito.when((Object)this.restRequest.getSpanId()).thenReturn((Object)"test span id");
        Mockito.when((Object)this.httpChannel.getRemoteAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        this.searchGuarddispatcher.dispatchRequest(this.restRequest, this.restChannel, this.threadContext);
        ((RestChannel)Mockito.verify((Object)this.restChannel, (VerificationMode)Mockito.times((int)1))).sendResponse((RestResponse)this.responseCaptor.capture());
        RestResponse response = (RestResponse)this.responseCaptor.getValue();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)Matchers.is((Object)RestStatus.UNAUTHORIZED));
        MatcherAssert.assertThat((Object)response.getHeaders(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"WWW-Authenticate"), (Matcher)Matchers.contains((Object[])new String[]{"Basic realm=\"Search Guard\""})));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.genuineDispatcher, this.threadContext});
    }
}

