/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.test;

import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfig;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import java.net.InetAddress;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;
import org.junit.Assert;

public abstract class SingleClusterTest
extends AbstractSGUnitTest {
    protected ClusterHelper clusterHelper = new ClusterHelper("utest_n", 0);
    protected ClusterInfo clusterInfo;
    ClusterHelper remoteClusterHelper = null;

    protected void setup(Settings nodeOverride) throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), nodeOverride, true);
    }

    protected void setup(Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), nodeOverride, true, clusterConfiguration);
    }

    protected void setup() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride) throws Exception {
        this.setup(initTransportClientSettings, dynamicSgSettings, nodeOverride, true);
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex) throws Exception {
        this.setup(initTransportClientSettings, dynamicSgSettings, nodeOverride, initSearchGuardIndex, ClusterConfiguration.DEFAULT);
    }

    protected void setupWithHttps(DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex) throws Exception {
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "node-0-keystore.jks"))).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)(prefix + "truststore.jks"))).put(nodeOverride).build();
        this.setup(Settings.EMPTY, dynamicSgSettings, settings, initSearchGuardIndex, ClusterConfiguration.DEFAULT);
    }

    private Settings ccs(Settings nodeOverride) throws Exception {
        if (withRemoteCluster) {
            this.remoteClusterHelper = new ClusterHelper("crl2_n", 1);
            ClusterInfo cl2Info = this.remoteClusterHelper.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.SINGLENODE);
            Settings.Builder builder = Settings.builder().put(nodeOverride).putList("cluster.remote.cross_cluster_two.seeds", new String[]{cl2Info.nodeHost + ":" + cl2Info.nodePort});
            return builder.build();
        }
        return nodeOverride;
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration) throws Exception {
        Assert.assertEquals((Object)Settings.EMPTY, (Object)initTransportClientSettings);
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(this.ccs(nodeOverride)), clusterConfiguration);
        if (initSearchGuardIndex && dynamicSgSettings != null) {
            this.initialize(this.getPrivilegedInternalNodeClient(), dynamicSgSettings);
        }
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration, int timeout, Integer nodes) throws Exception {
        Assert.assertEquals((Object)Settings.EMPTY, (Object)initTransportClientSettings);
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(this.ccs(nodeOverride)), clusterConfiguration, timeout, nodes);
        if (initSearchGuardIndex) {
            this.initialize(this.getPrivilegedInternalNodeClient(), dynamicSgSettings);
        }
    }

    protected void setupSslOnlyMode(Settings nodeOverride) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettingsSslOnly(nodeOverride), ClusterConfiguration.DEFAULT);
    }

    protected void setupSslOnlyMode(Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettingsSslOnly(nodeOverride), clusterConfiguration);
    }

    protected RestHelper restHelper() {
        return new RestHelper(this.clusterInfo, this.getResourceFolder());
    }

    protected RestHelper restHelper(InetAddress bindAddress) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setLocalAddress(bindAddress);
        return result;
    }

    protected RestHelper restHelper(GenericSSLConfig sslConfig) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setSslConfig(sslConfig);
        return result;
    }

    protected RestHelper restHelper(int nodeIndex) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setNodeIndex(nodeIndex);
        return result;
    }

    protected RestHelper restHelper(int nodeIndex, GenericSSLConfig sslConfig) {
        RestHelper result = new RestHelper(this.clusterInfo, this.getResourceFolder());
        result.setNodeIndex(nodeIndex);
        result.setSslConfig(sslConfig);
        return result;
    }

    protected RestHelper nonSslRestHelper() {
        return new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
    }

    protected RestHelper nonSslRestHelper(InetAddress bindAddress) {
        RestHelper result = new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
        result.setLocalAddress(bindAddress);
        return result;
    }

    protected Client getNodeClient() {
        return this.clusterHelper.nodeClient();
    }

    public Client getPrivilegedInternalNodeClient() {
        return PrivilegedConfigClient.adapt((Client)this.getNodeClient());
    }

    @After
    public void tearDown() throws Exception {
        if (this.remoteClusterHelper != null) {
            this.remoteClusterHelper.stopCluster();
        }
        if (this.clusterInfo != null) {
            this.clusterHelper.stopCluster();
        }
    }
}

