/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy;

import com.floragunn.searchguard.legacy.test.AbstractSGUnitTest;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CrossClusterSearchTests
extends AbstractSGUnitTest {
    private final ClusterHelper cl1 = new ClusterHelper("crl1_n", 0);
    private final ClusterHelper cl2 = new ClusterHelper("crl2_n", 1);
    private ClusterInfo cl1Info;
    private ClusterInfo cl2Info;
    @Parameterized.Parameter
    public boolean ccsMinimizeRoundtrips;

    @Parameterized.Parameters
    public static Object[] parameters() {
        return new Object[]{Boolean.FALSE, Boolean.TRUE};
    }

    private void setupCcs() throws Exception {
        this.setupCcs(new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"));
    }

    private void setupCcs(DynamicSgConfig dynamicSgConfig) throws Exception {
        System.setProperty("sg.display_lic_none", "true");
        this.cl2Info = this.cl2.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.DEFAULT);
        this.initialize((Client)PrivilegedConfigClient.adapt((Client)this.cl2.nodeClient()), dynamicSgConfig);
        this.cl1Info = this.cl1.startCluster(this.minimumSearchGuardSettings(this.crossClusterNodeSettings(this.cl2Info)), ClusterConfiguration.DEFAULT);
        this.initialize((Client)PrivilegedConfigClient.adapt((Client)this.cl1.nodeClient()), dynamicSgConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.cl1.stopCluster();
        this.cl2.stopCluster();
    }

    private Settings crossClusterNodeSettings(ClusterInfo remote) {
        Settings.Builder builder = Settings.builder().putList("cluster.remote.cross_cluster_two.seeds", new String[]{remote.nodeHost + ":" + remote.nodePort});
        return builder.build();
    }

    @Test
    public void testCcs() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        Client tc = this.cl1.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("twutter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("twutter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse ccs = null;
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("twitter"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:xx,xx/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:abcnonext/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"no such index"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twutter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster"));
    }

    @Test
    public void testCcsNonadmin() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        Client tc = this.cl1.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("twutter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("coordalias"))).actionGet();
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("twutter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("remotealias"))).actionGet();
        RestHelper.HttpResponse ccs = null;
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twit*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter,twutter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1_"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2_"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twutter,twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"Insufficient permissions\""));
        String msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter,twitter/_msearch?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter/_msearch?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_all/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:*/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth*/_search?ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("\"hits\":[]"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"Insufficient permissions\""));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"Insufficient permissions\""));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E,%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"Insufficient permissions\""));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips + "&ignore_unavailable=true", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips + "&ignore_unavailable=true", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips + "&ignore_unavailable=true", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("notexist,coordalias/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("crusherw", "crusherw"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"Insufficient permissions\""));
    }

    @Test
    public void testCcsEmptyCoord() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        Client tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse ccs = null;
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty&ccs_minimize_roundtrips=" + this.ccsMinimizeRoundtrips, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:twitter"));
    }

    @Test
    public void testCcsKibanaAggregations() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        Client tc = this.cl1.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse ccs = null;
        String kibanaIndicesAgg = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"no such index"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*,coo*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remote/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*,ab*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
    }

    @Test
    public void testCcsAggregations() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        Client tc = this.cl1.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc.index(((IndexRequest)new IndexRequest("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        tc = this.cl2.nodeClient();
        tc.index(((IndexRequest)new IndexRequest("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        RestHelper.HttpResponse ccs = null;
        String agg = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("*:*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("coordin*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl2"));
        Assert.assertFalse((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertFalse((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"status\" : \"skipped\""));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"reason\" : \"no such index"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl2"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfou*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfou*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:not*,notf*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
    }

    @Test
    public void shouldPerformQueryForNotExistingIndex() throws Exception {
        this.setupCcs();
        RestHelper.HttpResponse response = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("/*:.monitoring-es/_search", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertTrue((boolean)response.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)response.getBody().contains("\"status\":\"skipped\""));
        Assert.assertTrue((boolean)response.getBody().contains("\"reason\":\"no such index"));
    }
}

