/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.SearchGuardCapabilities;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.action.whoami.TransportWhoAmIAction;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auditlog.AuditLogRelay;
import com.floragunn.searchguard.auditlog.AuditLogSslExceptionHandler;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersAuthenticationBackend;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersConfigApi;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersDatabase;
import com.floragunn.searchguard.authc.rest.AuthcCacheApi;
import com.floragunn.searchguard.authc.rest.AuthenticatingRestFilter;
import com.floragunn.searchguard.authc.rest.RestAuthcConfigApi;
import com.floragunn.searchguard.authc.session.FrontendAuthcConfigApi;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.authc.session.backend.SessionModule;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.AuthorizationConfigApi;
import com.floragunn.searchguard.authz.indices.SearchGuardDirectoryReaderWrapper;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.configuration.api.BulkConfigApi;
import com.floragunn.searchguard.configuration.api.GenericTypeLevelConfigApi;
import com.floragunn.searchguard.configuration.api.MigrateConfigIndexApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarRefreshAction;
import com.floragunn.searchguard.configuration.variables.ConfigVarService;
import com.floragunn.searchguard.configuration.variables.EncryptionKeys;
import com.floragunn.searchguard.filter.SearchGuardFilter;
import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import com.floragunn.searchguard.http.SearchGuardNonSslHttpServerTransport;
import com.floragunn.searchguard.internalauthtoken.InternalAuthTokenProvider;
import com.floragunn.searchguard.license.LicenseRepository;
import com.floragunn.searchguard.license.SearchGuardLicenseInfoAction;
import com.floragunn.searchguard.license.SearchGuardLicenseKeyApi;
import com.floragunn.searchguard.modules.api.ComponentStateRestAction;
import com.floragunn.searchguard.modules.api.GetComponentStateAction;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.privileges.extended_action_handling.ExtendedActionHandlingService;
import com.floragunn.searchguard.privileges.extended_action_handling.ResourceOwnerService;
import com.floragunn.searchguard.rest.KibanaInfoAction;
import com.floragunn.searchguard.rest.PermissionAction;
import com.floragunn.searchguard.rest.SSLReloadCertAction;
import com.floragunn.searchguard.rest.SearchGuardHealthAction;
import com.floragunn.searchguard.rest.SearchGuardInfoAction;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.floragunn.searchguard.ssl.SslExceptionHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLNettyTransport;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.ReflectionHelper;
import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.SearchGuardInterceptor;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class SearchGuardPlugin
extends SearchGuardSSLPlugin
implements ClusterPlugin,
MapperPlugin,
ScriptPlugin {
    private volatile AuthenticatingRestFilter sgRestHandler;
    private volatile SearchGuardInterceptor sgi;
    private AuthorizationService authorizationService;
    private volatile PrivilegesEvaluator evaluator;
    private volatile ThreadPool threadPool;
    private volatile NamedXContentRegistry xContentRegistry;
    private volatile ConfigurationRepository cr;
    private volatile AdminDNs adminDns;
    private volatile ClusterService clusterService;
    private final AuditLogRelay auditLog = new AuditLogRelay();
    private volatile SslExceptionHandler sslExceptionHandler;
    private volatile Client localClient;
    private final boolean disabled;
    private final boolean enterpriseModulesEnabled;
    private final boolean sslOnly;
    private boolean sslCertReloadEnabled;
    private final List<String> demoCertHashes = new ArrayList<String>(3);
    private volatile ComplianceConfig complianceConfig;
    private volatile ActionRequestIntrospector actionRequestIntrospector;
    private ScriptService scriptService;
    private static ProtectedIndices protectedIndices;
    private ProtectedConfigIndexService protectedConfigIndexService;
    private SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry = new SpecialPrivilegesEvaluationContextProviderRegistry();
    private SearchGuardModulesRegistry moduleRegistry;
    private SearchGuardCapabilities capabilities;
    private StaticSgConfig staticSgConfig;
    private AuthInfoService authInfoService;
    private DiagnosticContext diagnosticContext;
    private ConfigVarService configVarService;
    private LicenseRepository licenseRepository;
    private Actions actions;

    public void close() throws IOException {
        if (this.auditLog != null) {
            try {
                this.auditLog.close();
            }
            catch (Exception e) {
                this.log.error("Error while closing auditLog", (Throwable)e);
            }
        }
    }

    private final SslExceptionHandler evaluateSslExceptionHandler() {
        if (this.client || this.disabled || this.sslOnly) {
            return new SslExceptionHandler(){};
        }
        return Objects.requireNonNull(this.sslExceptionHandler);
    }

    private static boolean isDisabled(Settings settings) {
        return settings.getAsBoolean("searchguard.disabled", Boolean.valueOf(false));
    }

    private static boolean isSslOnlyMode(Settings settings) {
        return settings.getAsBoolean("searchguard.ssl_only", Boolean.valueOf(false));
    }

    private static boolean isSslCertReloadEnabled(Settings settings) {
        return settings.getAsBoolean("searchguard.ssl.cert_reload_enabled", Boolean.valueOf(false));
    }

    public SearchGuardPlugin(final Settings settings, final Path configPath) {
        super(settings, configPath, SearchGuardPlugin.isDisabled(settings));
        List<Path> filesWithWrongPermissions;
        this.disabled = SearchGuardPlugin.isDisabled(settings);
        this.sslCertReloadEnabled = SearchGuardPlugin.isSslCertReloadEnabled(settings);
        this.moduleRegistry = new SearchGuardModulesRegistry(settings);
        if (this.disabled) {
            this.enterpriseModulesEnabled = false;
            this.sslOnly = false;
            this.sslCertReloadEnabled = false;
            this.complianceConfig = null;
            protectedIndices = new ProtectedIndices();
            this.log.warn("Search Guard plugin installed but disabled. This can expose your configuration (including passwords) to the public.");
            return;
        }
        this.sslOnly = SearchGuardPlugin.isSslOnlyMode(settings);
        if (this.sslOnly) {
            this.enterpriseModulesEnabled = false;
            this.sslCertReloadEnabled = false;
            this.complianceConfig = null;
            protectedIndices = new ProtectedIndices();
            this.log.warn("Search Guard plugin run in ssl only mode. No authentication or authorization is performed");
            return;
        }
        protectedIndices = new ProtectedIndices(settings, new String[0]);
        this.staticSgConfig = new StaticSgConfig(settings);
        this.demoCertHashes.add("54a92508de7a39d06242a0ffbf59414d7eb478633c719e6af03938daf6de8a1a");
        this.demoCertHashes.add("742e4659c79d7cad89ea86aab70aea490f23bbfc7e72abd5f0a5d3fb4c84d212");
        this.demoCertHashes.add("db1264612891406639ecd25c894f256b7c5a6b7e1d9054cbe37b77acd2ddd913");
        this.demoCertHashes.add("2a5398e20fcb851ec30aa141f37233ee91a802683415be2945c3c312c65c97cf");
        this.demoCertHashes.add("33129547ce617f784c04e965104b2c671cce9e794d1c64c7efe58c77026246ae");
        this.demoCertHashes.add("c4af0297cc75546e1905bdfe3934a950161eee11173d979ce929f086fdf9794d");
        this.demoCertHashes.add("7a355f42c90e7543a267fbe3976c02f619036f5a34ce712995a22b342d83c3ce");
        this.demoCertHashes.add("a9b5eca1399ec8518081c0d4a21a34eec4589087ce64c04fb01a488f9ad8edc9");
        this.demoCertHashes.add("d14aefe70a592d7a29e14f3ff89c3d0070c99e87d21776aa07d333ee877e758f");
        this.demoCertHashes.add("54a70016e0837a2b0c5658d1032d7ca32e432c62c55f01a2bf5adcb69a0a7ba9");
        this.demoCertHashes.add("bdc141ab2272c779d0f242b79063152c49e1b06a2af05e0fd90d505f2b44d5f5");
        this.demoCertHashes.add("3e839e2b059036a99ee4f742814995f2fb0ced7e9d68a47851f43a3c630b5324");
        this.demoCertHashes.add("9b13661c073d864c28ad7b13eda67dcb6cbc2f04d116adc7c817c20b4c7ed361");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (Security.getProvider("BC") == null) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
                return null;
            }
        });
        this.enterpriseModulesEnabled = settings.getAsBoolean("searchguard.enterprise_modules_enabled", Boolean.valueOf(true));
        ReflectionHelper.init(this.enterpriseModulesEnabled);
        ReflectionHelper.registerMngtRestApiHandler(settings);
        this.log.info("Clustername: {}", (Object)settings.get("cluster.name", "elasticsearch"));
        if (!this.transportSSLEnabled && !this.sslOnly) {
            throw new IllegalStateException("searchguard.ssl.transport.enabled must be set to 'true'");
        }
        if (!this.client && (filesWithWrongPermissions = AccessController.doPrivileged(new PrivilegedAction<List<Path>>(){

            @Override
            public List<Path> run() {
                Path confPath = new Environment(settings, configPath).configFile().toAbsolutePath();
                if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                    List<Path> list;
                    block9: {
                        Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                        try {
                            list = s.distinct().filter(p -> SearchGuardPlugin.this.checkFilePermissions(p)).collect(Collectors.toList());
                            if (s == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (s != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                SearchGuardPlugin.this.log.error((Object)e);
                                return null;
                            }
                        }
                        s.close();
                    }
                    return list;
                }
                return Collections.emptyList();
            }
        })) != null && filesWithWrongPermissions.size() > 0) {
            for (Path p : filesWithWrongPermissions) {
                if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
                    this.log.warn("Directory " + p + " has insecure file permissions (should be 0700)");
                    continue;
                }
                this.log.warn("File " + p + " has insecure file permissions (should be 0600)");
            }
        }
        if (!this.client && !settings.getAsBoolean("searchguard.allow_unsafe_democertificates", Boolean.valueOf(false)).booleanValue()) {
            List<String> files = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    Path confPath = new Environment(settings, configPath).configFile().toAbsolutePath();
                    if (Files.isDirectory(confPath, LinkOption.NOFOLLOW_LINKS)) {
                        List<String> list;
                        block9: {
                            Stream<Path> s = Files.walk(confPath, new FileVisitOption[0]);
                            try {
                                list = s.distinct().map(p -> SearchGuardPlugin.this.sha256(p)).collect(Collectors.toList());
                                if (s == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (s != null) {
                                        try {
                                            s.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    SearchGuardPlugin.this.log.error((Object)e);
                                    return null;
                                }
                            }
                            s.close();
                        }
                        return list;
                    }
                    return Collections.emptyList();
                }
            });
            if (files != null) {
                this.demoCertHashes.retainAll(files);
                if (!this.demoCertHashes.isEmpty()) {
                    this.log.error("Demo certificates found but searchguard.allow_unsafe_democertificates is set to false.See http://docs.search-guard.com/latest/demo-installer-generated-artefacts#allow-demo-certificates-and-auto-initialization");
                    throw new RuntimeException("Demo certificates found " + this.demoCertHashes);
                }
            } else {
                throw new RuntimeException("Unable to look for demo certificates");
            }
        }
        if (this.enterpriseModulesEnabled) {
            this.moduleRegistry.add("com.floragunn.searchguard.enterprise.auth.EnterpriseAuthFeaturesModule", "com.floragunn.searchguard.authtoken.AuthTokenModule", "com.floragunn.dlic.auth.LegacyEnterpriseSecurityModule", "com.floragunn.searchguard.enterprise.femt.FeMultiTenancyModule", "com.floragunn.searchguard.enterprise.dlsfls.DlsFlsModule", "com.floragunn.searchguard.enterprise.dlsfls.legacy.LegacyDlsFlsModule", "com.floragunn.searchguard.enterprise.auditlog.AuditLogModule");
        }
        this.moduleRegistry.add(SessionModule.class.getName());
        this.moduleRegistry.add("com.floragunn.signals.SignalsModule");
        this.moduleRegistry.add("com.floragunn.searchguard.legacy.LegacySecurityModule");
    }

    private String sha256(Path p) {
        if (!Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
            return "";
        }
        if (!Files.isReadable(p)) {
            this.log.debug("Unreadable file " + p + " found");
            return "";
        }
        if (!FileSystems.getDefault().getPathMatcher("regex:(?i).*\\.(pem|jks|pfx|p12)").matches(p)) {
            this.log.debug("Not a .pem, .jks, .pfx or .p12 file, skipping");
            return "";
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA256");
            String hash = Hex.toHexString((byte[])digester.digest(Files.readAllBytes(p)));
            this.log.debug(hash + " :: " + p);
            return hash;
        }
        catch (Exception e) {
            throw new ElasticsearchSecurityException("Unable to digest file " + p, e, new Object[0]);
        }
    }

    private boolean checkFilePermissions(Path p) {
        Set<PosixFilePermission> perms;
        if (p == null) {
            return false;
        }
        try {
            perms = Files.getPosixFilePermissions(p, LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot determine posix file permissions for {} due to {}", (Object)p, (Object)e);
            }
            return false;
        }
        if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS) ? perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE) : perms.contains((Object)PosixFilePermission.OWNER_EXECUTE) || perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) || perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            return true;
        }
        return perms.contains((Object)PosixFilePermission.OTHERS_READ) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        if (!this.client && !this.disabled) {
            handlers.addAll(super.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
            if (!this.sslOnly) {
                handlers.add((RestHandler)new SearchGuardInfoAction(settings, restController, this.authorizationService, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool), this.clusterService, this.adminDns));
                handlers.add((RestHandler)new KibanaInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.add((RestHandler)new SearchGuardHealthAction(settings, restController, this.cr));
                handlers.add((RestHandler)new PermissionAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
                handlers.addAll(ReflectionHelper.instantiateMngtRestApiHandler(settings, this.configPath, restController, this.localClient, this.adminDns, this.cr, this.staticSgConfig, this.clusterService, Objects.requireNonNull(this.principalExtractor), this.authorizationService, this.specialPrivilegesEvaluationContextProviderRegistry, this.threadPool, Objects.requireNonNull(this.auditLog)));
                handlers.add((RestHandler)new SSLReloadCertAction(this.sgks, Objects.requireNonNull(this.threadPool), this.adminDns, this.sslCertReloadEnabled));
                handlers.add((RestHandler)new ComponentStateRestAction());
                handlers.add((RestHandler)BulkConfigApi.REST_API);
                handlers.add((RestHandler)GenericTypeLevelConfigApi.REST_API);
                handlers.add((RestHandler)ConfigVarApi.REST_API);
                handlers.add((RestHandler)InternalUsersConfigApi.REST_API);
                handlers.add((RestHandler)RestAuthcConfigApi.REST_API);
                handlers.add((RestHandler)AuthorizationConfigApi.REST_API);
                handlers.add((RestHandler)new AuthcCacheApi.RestHandler());
                handlers.add((RestHandler)FrontendAuthcConfigApi.TypeLevel.REST_API);
                handlers.add((RestHandler)FrontendAuthcConfigApi.DocumentLevel.REST_API);
                handlers.add((RestHandler)SearchGuardLicenseKeyApi.REST_API);
                handlers.add((RestHandler)SearchGuardLicenseInfoAction.REST_API);
                handlers.add((RestHandler)SearchGuardCapabilities.GetCapabilitiesAction.REST_API);
                handlers.add((RestHandler)ProtectedConfigIndexService.TriggerConfigIndexCreationAction.REST_API);
                handlers.add((RestHandler)GetActivatedFrontendConfigAction.REST_API);
                handlers.add((RestHandler)MigrateConfigIndexApi.REST_API);
                handlers.add((RestHandler)new AuthenticatingRestFilter.DebugApi());
            }
            handlers.addAll(this.moduleRegistry.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, this.scriptService, nodesInCluster));
        }
        return handlers;
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (this.client || this.disabled || this.sslOnly) {
            return rh -> rh;
        }
        return rh -> this.sgRestHandler.wrap((RestHandler)rh);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(1);
        if (!this.disabled && !this.sslOnly) {
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)WhoAmIAction.INSTANCE, TransportWhoAmIAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)GetComponentStateAction.INSTANCE, GetComponentStateAction.TransportAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)SearchGuardLicenseInfoAction.INSTANCE, SearchGuardLicenseInfoAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)BulkConfigApi.GetAction.INSTANCE, BulkConfigApi.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)BulkConfigApi.UpdateAction.INSTANCE, BulkConfigApi.UpdateAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)GenericTypeLevelConfigApi.DeleteAction.INSTANCE, GenericTypeLevelConfigApi.DeleteAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarRefreshAction.INSTANCE, ConfigVarRefreshAction.TransportAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarApi.GetAction.INSTANCE, ConfigVarApi.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarApi.UpdateAction.INSTANCE, ConfigVarApi.UpdateAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarApi.DeleteAction.INSTANCE, ConfigVarApi.DeleteAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarApi.GetAllAction.INSTANCE, ConfigVarApi.GetAllAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ConfigVarApi.UpdateAllAction.INSTANCE, ConfigVarApi.UpdateAllAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)InternalUsersConfigApi.GetAction.INSTANCE, InternalUsersConfigApi.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)InternalUsersConfigApi.DeleteAction.INSTANCE, InternalUsersConfigApi.DeleteAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)InternalUsersConfigApi.PutAction.INSTANCE, InternalUsersConfigApi.PutAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)InternalUsersConfigApi.PatchAction.INSTANCE, InternalUsersConfigApi.PatchAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)GetActivatedFrontendConfigAction.INSTANCE, GetActivatedFrontendConfigAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RestAuthcConfigApi.GetAction.INSTANCE, RestAuthcConfigApi.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RestAuthcConfigApi.PutAction.INSTANCE, RestAuthcConfigApi.PutAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RestAuthcConfigApi.PatchAction.INSTANCE, RestAuthcConfigApi.PatchAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)RestAuthcConfigApi.DeleteAction.INSTANCE, RestAuthcConfigApi.DeleteAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)AuthcCacheApi.DeleteAction.INSTANCE, AuthcCacheApi.DeleteAction.TransportAction.class, new Class[0]));
            actions.addAll((Collection<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>)AuthorizationConfigApi.ACTION_HANDLERS);
            actions.addAll((Collection<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>)SearchGuardLicenseKeyApi.ACTION_HANDLERS);
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.TypeLevel.GetAction.INSTANCE, FrontendAuthcConfigApi.TypeLevel.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.TypeLevel.PutAction.INSTANCE, FrontendAuthcConfigApi.TypeLevel.PutAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.TypeLevel.PatchAction.INSTANCE, FrontendAuthcConfigApi.TypeLevel.PatchAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.DocumentLevel.GetAction.INSTANCE, FrontendAuthcConfigApi.DocumentLevel.GetAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.DocumentLevel.PutAction.INSTANCE, FrontendAuthcConfigApi.DocumentLevel.PutAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)FrontendAuthcConfigApi.DocumentLevel.PatchAction.INSTANCE, FrontendAuthcConfigApi.DocumentLevel.PatchAction.Handler.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)SearchGuardCapabilities.GetCapabilitiesAction.INSTANCE, SearchGuardCapabilities.GetCapabilitiesAction.TransportAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)ProtectedConfigIndexService.TriggerConfigIndexCreationAction.INSTANCE, ProtectedConfigIndexService.TriggerConfigIndexCreationAction.TransportAction.class, new Class[0]));
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((ActionType)MigrateConfigIndexApi.INSTANCE, MigrateConfigIndexApi.Handler.class, new Class[0]));
        }
        actions.addAll(this.moduleRegistry.getActions());
        return actions;
    }

    public List<ScriptContext<?>> getContexts() {
        return this.moduleRegistry.getContexts();
    }

    public void onIndexModule(IndexModule indexModule) {
        if (!(this.disabled || this.client || this.sslOnly)) {
            if (this.adminDns == null) {
                throw new IllegalStateException("adminDns is not yet initialized");
            }
            ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> directoryReaderWrappersForNormalOperations = this.moduleRegistry.getDirectoryReaderWrappersForNormalOperations();
            ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> directoryReaderWrappersForAllOperations = this.moduleRegistry.getDirectoryReaderWrappersForAllOperations();
            indexModule.setReaderWrapper(indexService -> new SearchGuardDirectoryReaderWrapper((IndexService)indexService, this.adminDns, directoryReaderWrappersForNormalOperations, directoryReaderWrappersForAllOperations));
            ImmutableList<SearchGuardModule.QueryCacheWeightProvider> queryCacheWeightProviders = this.moduleRegistry.getQueryCacheWeightProviders();
            if (!queryCacheWeightProviders.isEmpty()) {
                indexModule.forceQueryCacheProvider((indexSettings, nodeCache) -> new QueryCache((IndexSettings)indexSettings, (IndicesQueryCache)nodeCache, (ImmutableList)queryCacheWeightProviders){
                    final /* synthetic */ IndexSettings val$indexSettings;
                    final /* synthetic */ IndicesQueryCache val$nodeCache;
                    final /* synthetic */ ImmutableList val$queryCacheWeightProviders;
                    {
                        this.val$indexSettings = indexSettings;
                        this.val$nodeCache = indicesQueryCache;
                        this.val$queryCacheWeightProviders = immutableList;
                    }

                    public Index index() {
                        return this.val$indexSettings.getIndex();
                    }

                    public void close() throws ElasticsearchException {
                        this.clear("close");
                    }

                    public void clear(String reason) {
                        this.val$nodeCache.clearIndex(this.index().getName());
                    }

                    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
                        for (SearchGuardModule.QueryCacheWeightProvider provider : this.val$queryCacheWeightProviders) {
                            Weight result = provider.apply(this.index(), weight, policy);
                            if (result == null) continue;
                            return result;
                        }
                        return this.val$nodeCache.doCache(weight, policy);
                    }
                });
            }
            indexModule.addSearchOperationListener(new SearchOperationListener(){

                public void onNewScrollContext(ReaderContext context) {
                    boolean interClusterRequest = HeaderHelper.isInterClusterRequest(SearchGuardPlugin.this.threadPool.getThreadContext());
                    if (AuditLog.Origin.LOCAL.toString().equals(SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(SearchGuardPlugin.this.threadPool.getThreadContext()))) {
                        context.putInContext("_sg_scroll_auth_local", (Object)Boolean.TRUE);
                    } else {
                        context.putInContext("_sg_scroll_auth", SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user"));
                    }
                }

                public void validateReaderContext(ReaderContext context, TransportRequest transportRequest) {
                    ScrollContext scrollContext = context.scrollContext();
                    if (scrollContext != null) {
                        Object _isLocal = context.getFromContext("_sg_scroll_auth_local");
                        Object _user = context.getFromContext("_sg_scroll_auth");
                        if (_user != null && _user instanceof User) {
                            User scrollUser = (User)_user;
                            User currentUser = (User)SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user");
                            if (!scrollUser.equals(currentUser)) {
                                SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, null);
                                SearchGuardPlugin.this.log.error("Wrong user {} in scroll context, expected {}", (Object)scrollUser, (Object)currentUser);
                                throw new ElasticsearchSecurityException("Wrong user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                            }
                        } else if (_isLocal != Boolean.TRUE) {
                            SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest, null);
                            throw new ElasticsearchSecurityException("No user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                        }
                    }
                }
            });
            for (SearchOperationListener searchOperationListener : this.moduleRegistry.getSearchOperationListeners()) {
                indexModule.addSearchOperationListener(searchOperationListener);
            }
            for (IndexingOperationListener indexOperationListener : this.moduleRegistry.getIndexOperationListeners()) {
                indexModule.addIndexOperationListener(indexOperationListener);
            }
        }
    }

    public List<ActionFilter> getActionFilters() {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>(1);
        if (!(this.client || this.disabled || this.sslOnly)) {
            ResourceOwnerService resourceOwnerService = new ResourceOwnerService(this.localClient, this.clusterService, this.threadPool, this.protectedConfigIndexService, this.evaluator, this.settings);
            ExtendedActionHandlingService extendedActionHandlingService = new ExtendedActionHandlingService(resourceOwnerService, this.settings);
            SearchGuardFilter searchGuardFilter = new SearchGuardFilter(this.authorizationService, this.evaluator, this.adminDns, this.moduleRegistry.getSyncAuthorizationFilters(), this.auditLog, this.threadPool, this.clusterService, this.diagnosticContext, this.complianceConfig, this.actions, this.actionRequestIntrospector, this.specialPrivilegesEvaluationContextProviderRegistry, extendedActionHandlingService, this.xContentRegistry);
            filters.add(searchGuardFilter);
            DiagnosticContext.ActionTraceFilter actionTraceFilter = this.diagnosticContext.getActionTraceFilter();
            if (actionTraceFilter != null) {
                filters.add((ActionFilter)actionTraceFilter);
            }
            filters.addAll((Collection<ActionFilter>)this.moduleRegistry.getActionFilters());
        }
        return filters;
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (!(this.client || this.disabled || this.sslOnly)) {
            interceptors.add(new TransportInterceptor(){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                    return (request, channel, task) -> SearchGuardPlugin.this.sgi.getHandler(action, actualHandler).messageReceived(request, channel, task);
                }

                public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
                    return new TransportInterceptor.AsyncSender(){

                        public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                            SearchGuardPlugin.this.sgi.sendRequestDecorate(sender, connection, action, request, options, handler);
                        }
                    };
                }
            });
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (this.sslOnly) {
            return super.getTransports(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        }
        if (this.transportSSLEnabled) {
            transports.put("com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport", () -> new SearchGuardSSLNettyTransport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, this.sharedGroupFactory, this.sgks, this.evaluateSslExceptionHandler()));
        }
        return transports;
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher, BiConsumer<HttpPreRequest, ThreadContext> perRequestThreadContext, ClusterSettings clusterSettings) {
        if (this.sslOnly) {
            return super.getHttpTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, xContentRegistry, networkService, dispatcher, perRequestThreadContext, clusterSettings);
        }
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>(1);
        if (!this.disabled) {
            if (!this.client && this.httpSSLEnabled) {
                ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings, this.configPath, this.evaluateSslExceptionHandler());
                SearchGuardHttpServerTransport sghst = new SearchGuardHttpServerTransport(settings, networkService, bigArrays, threadPool, this.sgks, this.evaluateSslExceptionHandler(), xContentRegistry, validatingDispatcher, clusterSettings, this.sharedGroupFactory, perRequestThreadContext);
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> sghst);
            } else if (!this.client) {
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> new SearchGuardNonSslHttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, this.sharedGroupFactory, perRequestThreadContext));
            }
        }
        return httpTransports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        if (this.sslOnly) {
            return super.createComponents(localClient, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier);
        }
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.localClient = localClient;
        this.scriptService = scriptService;
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.client || this.disabled) {
            return components;
        }
        GuiceDependencies guiceDependencies = new GuiceDependencies();
        components.add(guiceDependencies);
        ClusterInfoHolder cih = new ClusterInfoHolder();
        this.clusterService.addListener((ClusterStateListener)cih);
        this.actionRequestIntrospector = new ActionRequestIntrospector(indexNameExpressionResolver, clusterService, cih, guiceDependencies);
        String DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = DefaultInterClusterRequestEvaluator.class.getName();
        InterClusterRequestEvaluator interClusterRequestEvaluator = new DefaultInterClusterRequestEvaluator(this.settings);
        String className = this.settings.get("searchguard.cert.intercluster_request_evaluator_class", DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS);
        this.log.debug("Using {} as intercluster request evaluator class", (Object)className);
        if (!DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS.equals(className)) {
            interClusterRequestEvaluator = ReflectionHelper.instantiateInterClusterRequestEvaluator(className, this.settings);
        }
        this.adminDns = new AdminDNs(this.settings);
        this.protectedConfigIndexService = new ProtectedConfigIndexService(localClient, clusterService, threadPool, protectedIndices);
        this.moduleRegistry.addComponentStateProvider(this.protectedConfigIndexService);
        this.configVarService = new ConfigVarService(localClient, clusterService, threadPool, this.protectedConfigIndexService, new EncryptionKeys(this.settings));
        this.moduleRegistry.addComponentStateProvider(this.configVarService);
        this.cr = new ConfigurationRepository(this.staticSettings, threadPool, localClient, clusterService, this.configVarService, this.moduleRegistry, this.staticSgConfig, xContentRegistry, environment, indexNameExpressionResolver);
        this.moduleRegistry.addComponentStateProvider(this.cr);
        this.licenseRepository = new LicenseRepository(this.settings, localClient, clusterService, this.cr);
        this.sslExceptionHandler = new AuditLogSslExceptionHandler(this.auditLog);
        this.complianceConfig = new ComplianceConfig(environment, this.actionRequestIntrospector, this.cr);
        this.licenseRepository.subscribeOnLicenseChange(this.complianceConfig);
        this.moduleRegistry.addComponentStateProvider(this.licenseRepository);
        Actions actions = new Actions(this.moduleRegistry);
        this.authInfoService = new AuthInfoService(threadPool, this.specialPrivilegesEvaluationContextProviderRegistry);
        this.authorizationService = new AuthorizationService(this.cr, this.staticSettings, this.authInfoService);
        this.evaluator = new PrivilegesEvaluator(localClient, clusterService, threadPool, this.cr, this.authorizationService, indexNameExpressionResolver, this.auditLog, this.staticSettings, cih, actions, this.actionRequestIntrospector, this.specialPrivilegesEvaluationContextProviderRegistry, guiceDependencies, xContentRegistry, this.enterpriseModulesEnabled);
        this.moduleRegistry.addComponentStateProvider(this.evaluator);
        InternalAuthTokenProvider internalAuthTokenProvider = new InternalAuthTokenProvider(this.authorizationService, this.evaluator, actions, this.cr);
        this.specialPrivilegesEvaluationContextProviderRegistry.add(internalAuthTokenProvider::userAuthFromToken);
        this.diagnosticContext = new DiagnosticContext(this.settings, threadPool.getThreadContext());
        InternalUsersDatabase internalUsersDatabase = new InternalUsersDatabase(this.cr);
        this.moduleRegistry.addComponentStateProvider(internalUsersDatabase);
        this.moduleRegistry.getTypedComponentRegistry().register(new InternalUsersAuthenticationBackend.Info(internalUsersDatabase));
        this.moduleRegistry.getTypedComponentRegistry().register(new InternalUsersAuthenticationBackend.UserInformationBackendInfo(internalUsersDatabase));
        String principalExtractorClass = this.settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        this.principalExtractor = principalExtractorClass == null ? new DefaultPrincipalExtractor() : ReflectionHelper.instantiatePrincipalExtractor(principalExtractorClass);
        BlockedIpRegistry blockedIpRegistry = new BlockedIpRegistry(this.cr);
        BlockedUserRegistry blockedUserRegistry = new BlockedUserRegistry(this.cr);
        BaseDependencies baseDependencies = new BaseDependencies(this.settings, this.staticSettings, localClient, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, indexNameExpressionResolver, this.staticSgConfig, this.cr, this.licenseRepository, this.protectedConfigIndexService, internalAuthTokenProvider, this.specialPrivilegesEvaluationContextProviderRegistry, this.configVarService, this.diagnosticContext, this.auditLog, this.evaluator, blockedIpRegistry, blockedUserRegistry, this.moduleRegistry, internalUsersDatabase, actions, this.authorizationService, guiceDependencies, this.authInfoService, this.actionRequestIntrospector);
        this.sgi = new SearchGuardInterceptor(this.settings, threadPool, this.auditLog, this.principalExtractor, interClusterRequestEvaluator, clusterService, Objects.requireNonNull(this.sslExceptionHandler), Objects.requireNonNull(cih), guiceDependencies, this.diagnosticContext, this.adminDns);
        components.add(this.principalExtractor);
        components.add(this.adminDns);
        components.add(this.cr);
        components.add(this.evaluator);
        components.add(this.authorizationService);
        components.add(this.sgi);
        components.add(internalAuthTokenProvider);
        components.add(this.moduleRegistry);
        components.add(this.protectedConfigIndexService);
        components.add(this.staticSgConfig);
        components.add(this.authInfoService);
        components.add(this.diagnosticContext);
        components.add(this.configVarService);
        components.add(this.auditLog);
        components.add(this.licenseRepository);
        components.add(baseDependencies);
        Collection<Object> moduleComponents = this.moduleRegistry.createComponents(baseDependencies);
        components.addAll(moduleComponents);
        this.capabilities = new SearchGuardCapabilities(this.moduleRegistry.getModules(), clusterService, localClient);
        components.add(this.capabilities);
        AuditLog auditLog = this.moduleRegistry.getAuditLog();
        if (auditLog != null) {
            this.auditLog.setAuditLog(auditLog);
        }
        this.sgRestHandler = new AuthenticatingRestFilter(this.cr, this.moduleRegistry, this.adminDns, blockedIpRegistry, blockedUserRegistry, this.auditLog, threadPool, this.principalExtractor, this.evaluator, this.settings, this.configPath, this.diagnosticContext);
        components.add(this.sgRestHandler);
        this.evaluator.setPrivilegesInterceptor(this.moduleRegistry.getPrivilegesInterceptor());
        this.moduleRegistry.addComponentStateProvider(this.sgRestHandler);
        this.actions = actions;
        return components;
    }

    public Settings additionalSettings() {
        if (this.disabled) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        builder.put(super.additionalSettings());
        if (!this.sslOnly) {
            builder.put("transport.type", "com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport");
            builder.put("http.type", "com.floragunn.searchguard.http.SearchGuardHttpServerTransport");
        }
        return builder.build();
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(super.getSettings());
        settings.add(Setting.boolSetting((String)"searchguard.ssl_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        if (!this.sslOnly) {
            settings.add(Setting.listSetting((String)"searchguard.authcz.admin_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.cert.oid", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.cert.intercluster_request_evaluator_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.nodes_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.disabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.enterprise_modules_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.allow_unsafe_democertificates", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.authcz.rest_impersonation_user.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.audit.routes.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"searchguard.audit.endpoints.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.intSetting((String)"searchguard.audit.threadpool.size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.intSetting((String)"searchguard.audit.threadpool.max_queue_len", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.log_request_body", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.resolve_indices", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.enable_rest", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.enable_transport", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            ArrayList<String> disabledCategories = new ArrayList<String>(2);
            disabledCategories.add("AUTHENTICATED");
            disabledCategories.add("GRANTED_PRIVILEGES");
            settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_transport_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_rest_categories", disabledCategories, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            ArrayList<String> ignoredUsers = new ArrayList<String>(2);
            ignoredUsers.add("kibanaserver");
            settings.add(Setting.listSetting((String)"searchguard.audit.ignore_users", ignoredUsers, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.ignore_requests", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.resolve_bulk_requests", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.exclude_sensitive_headers", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_fields", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.index", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.groupSetting((String)"searchguard.audit.config.custom_attributes.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.http_endpoints", (List)Lists.newArrayList((Object[])new String[]{"localhost:9200"}), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.verify_hostnames", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl_client_auth", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemcert_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.cert_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.enabled_ssl_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.audit.config.enabled_ssl_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.format", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.audit.config.webhook.ssl.verify", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.ssl.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.ssl.pemtrustedcas_content", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.log4j.logger_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.audit.config.log4j.level", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.krb5_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_keytab_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_principal", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.restapi.roles_enabled", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.groupSetting((String)"searchguard.restapi.endpoints_disabled.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.restapi.accept_invalid_license", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.restapi.password_validation_regex", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.restapi.password_validation_error_message", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.write.watched_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.read.watched_fields", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.write.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.read.metadata_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.write.log_diffs", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.external_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.external_config.env_vars.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.read.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.history.write.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.disable_anonymous_authentication", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.compliance.immutable_indices", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.simpleString((String)"searchguard.compliance.salt", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.history.internal_config_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.compliance.local_hashing_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.compliance.mask_prefix", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.listSetting((String)"searchguard.allow_custom_headers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
            settings.add(Setting.boolSetting((String)"searchguard.dfm_empty_overrides_all", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.allow_now_in_dls", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.restapi.allow_sgconfig_modification", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.boolSetting((String)"searchguard.unsupported.load_static_resources", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(Setting.simpleString((String)"searchguard.dls.mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.addAll(ResourceOwnerService.SUPPORTED_SETTINGS);
            settings.add(Setting.boolSetting((String)"searchguard.ssl.cert_reload_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
            settings.add(SearchGuardModulesRegistry.DISABLED_MODULES);
            settings.add(EncryptionKeys.ENCRYPTION_KEYS_SETTING);
            settings.addAll((Collection<Setting<?>>)ConfigurationRepository.STATIC_SETTINGS.toPlatform());
            settings.addAll(this.moduleRegistry.getSettings());
            settings.addAll(DiagnosticContext.SETTINGS);
            settings.addAll((Collection<Setting<?>>)PrivilegesEvaluator.STATIC_SETTINGS.toPlatform());
            settings.addAll((Collection<Setting<?>>)AuthorizationService.STATIC_SETTINGS.toPlatform());
        }
        return settings;
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        if (this.disabled) {
            return settingsFilter;
        }
        settingsFilter.add("searchguard.*");
        return settingsFilter;
    }

    public void onNodeStarted() {
        this.log.info("Node started");
        if (!(this.sslOnly || this.client || this.disabled)) {
            this.cr.initOnNodeStart();
            this.moduleRegistry.onNodeStarted();
            this.protectedConfigIndexService.onNodeStart();
        }
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        if (this.client || this.disabled || this.sslOnly) {
            return Collections.emptyList();
        }
        return Arrays.asList(GuiceDependencies.GuiceRedirector.class);
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return index -> {
            ImmutableList<Function<String, Predicate<String>>> fieldFilters = this.moduleRegistry.getFieldFilters();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(fieldFilters.size());
            for (Function filter : fieldFilters) {
                predicates.add((Predicate)filter.apply(index));
            }
            return field -> {
                for (Predicate predicate : predicates) {
                    if (predicate.test(field)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static ProtectedIndices getProtectedIndices() {
        return Objects.requireNonNull(protectedIndices);
    }

    public static final class ProtectedIndices {
        final Set<String> protectedPatterns;
        Pattern protectedPatternsPattern = Pattern.blank();

        public ProtectedIndices() {
            this.protectedPatterns = new HashSet<String>();
        }

        private ProtectedIndices(Settings settings, String ... patterns) {
            this.protectedPatterns = new HashSet<String>();
            this.protectedPatterns.addAll((Collection<String>)ConfigurationRepository.getConfiguredSearchguardIndices(settings));
            if (patterns != null && patterns.length > 0) {
                this.protectedPatterns.addAll(Arrays.asList(patterns));
            }
            try {
                this.protectedPatternsPattern = Pattern.createWithoutExclusions(this.protectedPatterns);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Invalid index pattern", e);
            }
        }

        public void add(String pattern) {
            this.protectedPatterns.add(pattern);
            try {
                this.protectedPatternsPattern = Pattern.createWithoutExclusions(this.protectedPatterns);
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException("Invalid index pattern", e);
            }
        }

        public boolean isProtected(String index) {
            return this.protectedPatternsPattern.matches(index);
        }

        public boolean containsProtected(Collection<String> indices) {
            return this.protectedPatternsPattern.matches(indices);
        }

        public String printProtectedIndices() {
            return this.protectedPatterns == null ? "" : Joiner.on((char)',').join(this.protectedPatterns);
        }
    }
}

