/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.internal_users_db;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.authc.internal_users_db.InternalUser;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.NoSuchConfigEntryException;
import com.floragunn.searchguard.configuration.SgConfigEntry;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;

public class InternalUsersConfigApi {
    public static final RestApi REST_API = new RestApi().handlesGet("/_searchguard/internal_users/{id}").with((Action)GetAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).handlesDelete("/_searchguard/internal_users/{id}").with((Action)DeleteAction.INSTANCE, (params, body) -> new StandardRequests.IdRequest((String)params.get("id"))).handlesPut("/_searchguard/internal_users/{id}").with((Action)PutAction.INSTANCE, (params, body) -> new PutAction.Request((String)params.get("id"), InternalUser.check((Map<String, Object>)body.parseAsDocNode()))).handlesPatch("/_searchguard/internal_users/{id}").with((Action)PatchAction.INSTANCE, (params, body) -> new PatchAction.Request((String)params.get("id"), DocPatch.parse((UnparsedDocument)body))).name("Search Guard Config Management API for retrieving and updating entries in the internal user database");

    public static class PatchAction
    extends Action<Request, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(PatchAction.class);
        public static final PatchAction INSTANCE = new PatchAction();
        public static final String NAME = "cluster:admin:searchguard:config/internal_users/patch";

        protected PatchAction() {
            super(NAME, Request::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configRepository;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configRepository) {
                super((Action)INSTANCE, handlerDependencies);
                this.configRepository = configRepository;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.configRepository.applyPatch(CType.INTERNALUSERS, request.getId(), request.getPatch(), request.getIfMatch(), ConfigurationRepository.PatchDefaultHandling.FAIL_ON_MISSING_DOCUMENT);
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(null, e.getMessage(), (Object)e.getValidationErrors());
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                    catch (Exception e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }

        public static class Request
        extends Action.Request {
            private final String id;
            private final DocPatch patch;

            public Request(String id, DocPatch patch) {
                this.id = id;
                this.patch = patch;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                ValidationErrors validationErrors = new ValidationErrors();
                ValidatingDocNode vNode = new ValidatingDocNode(message.requiredDocNode(), validationErrors);
                this.id = vNode.get("id").required().asString();
                this.patch = (DocPatch)vNode.get("patch").required().by(DocPatch::parseTyped);
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"patch", (Object)this.patch);
            }

            public String getId() {
                return this.id;
            }

            public DocPatch getPatch() {
                return this.patch;
            }
        }
    }

    public static class DeleteAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(DeleteAction.class);
        public static final DeleteAction INSTANCE = new DeleteAction();
        public static final String NAME = "cluster:admin:searchguard:config/internal_users/delete";

        protected DeleteAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ConfigurationRepository configRepository;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository) {
                super((Action)INSTANCE, handlerDependencies);
                this.configRepository = configurationRepository;
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        return this.configRepository.delete(CType.INTERNALUSERS, request.getId());
                    }
                    catch (NoSuchConfigEntryException e) {
                        return new StandardResponse(404).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while deleting user", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                    catch (Exception e) {
                        log.error("Error while deleting user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }
    }

    public static class PutAction
    extends Action<Request, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(PutAction.class);
        public static final PutAction INSTANCE = new PutAction();
        public static final String NAME = "cluster:admin:searchguard:config/internal_users/put";

        protected PutAction() {
            super(NAME, Request::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configRepository;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configRepository) {
                super((Action)INSTANCE, handlerDependencies);
                this.configRepository = configRepository;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    try {
                        InternalUser internalUser = (InternalUser)InternalUser.parse(request.getValue().toDocNode(), this.configRepository.getParserContext().withoutLenientValidation()).get();
                        return this.configRepository.addOrUpdate(CType.INTERNALUSERS, request.getId(), internalUser, request.getIfMatch());
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(e);
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                    catch (Exception e) {
                        log.error("Error while adding user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }

        public static class Request
        extends Action.Request {
            private final String id;
            private final Document<InternalUser> value;

            public Request(String id, Document<InternalUser> value) {
                this.id = id;
                this.value = value;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                DocNode docNode = message.requiredDocNode();
                this.id = docNode.getAsString("id");
                this.value = Document.assertedType((Object)docNode.getAsNode("value"), InternalUser.class);
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", this.value);
            }

            public String getId() {
                return this.id;
            }

            public Document<InternalUser> getValue() {
                return this.value;
            }
        }
    }

    public static class GetAction
    extends Action<StandardRequests.IdRequest, StandardResponse> {
        protected static final Logger log = LogManager.getLogger(GetAction.class);
        public static final GetAction INSTANCE = new GetAction();
        public static final String NAME = "cluster:admin:searchguard:config/internal_users/get";

        protected GetAction() {
            super(NAME, StandardRequests.IdRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.IdRequest, StandardResponse> {
            private final ConfigurationRepository configRepository;
            private final ConfigurationLoader configLoader;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository, BaseDependencies baseDependencies) {
                super((Action)INSTANCE, handlerDependencies);
                this.configRepository = configurationRepository;
                this.configLoader = new ConfigurationLoader(baseDependencies.getLocalClient(), configurationRepository);
            }

            protected CompletableFuture<StandardResponse> doExecute(StandardRequests.IdRequest request) {
                return this.supplyAsync(() -> {
                    try {
                        SgConfigEntry<InternalUser> user = this.configLoader.loadEntrySync(CType.INTERNALUSERS, request.getId(), "API GET /_searchguard/internal_users/", this.configRepository.getParserContext());
                        return new StandardResponse(200).data(user.toRedactedBasicObject()).eTag(user.getETag());
                    }
                    catch (NoSuchConfigEntryException e) {
                        log.info(e.getMessage());
                        return new StandardResponse(404).error(e.getMessage());
                    }
                    catch (Exception e) {
                        log.error("Error while getting user", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                });
            }
        }
    }
}

