/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.legacy;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.base.RequestAuthenticationProcessor;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.legacy.LegacyAuthenticationDomain;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.authc.legacy.LegacyRestRequestMetaData;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.TenantAwareRestHandler;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class LegacyRestRequestAuthenticationProcessor
extends RequestAuthenticationProcessor<HttpAuthenticationFrontend> {
    private static final Logger log = LogManager.getLogger(LegacyRestRequestAuthenticationProcessor.class);
    private final MetaRequestInfo authDomainMetaRequest;
    private final boolean isAuthDomainMetaRequest;
    private final RestHandler restHandler;
    private final RestRequest restRequest;
    private final RestChannel restChannel;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private LinkedHashSet<String> challenges = new LinkedHashSet(2);

    public LegacyRestRequestAuthenticationProcessor(RestHandler restHandler, LegacyRestRequestMetaData request, RestChannel restChannel, org.elasticsearch.common.util.concurrent.ThreadContext threadContext, Collection<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains, AdminDNs adminDns, PrivilegesEvaluator privilegesEvaluator, Cache<AuthCredentials, User> userCache, Cache<String, User> impersonationCache, AuditLog auditLog, BlockedUserRegistry blockedUserRegistry, List<AuthFailureListener> ipAuthFailureListeners, List<String> requiredLoginPrivileges, boolean debug) {
        super(request, authenticationDomains, adminDns, privilegesEvaluator, userCache, impersonationCache, auditLog, blockedUserRegistry, ipAuthFailureListeners, requiredLoginPrivileges, debug);
        this.restHandler = restHandler;
        this.restRequest = (RestRequest)request.getRequest();
        this.restChannel = restChannel;
        this.authDomainMetaRequest = this.checkAuthDomainMetaRequest(this.restRequest);
        this.isAuthDomainMetaRequest = this.authDomainMetaRequest != null;
        this.threadContext = request.getThreadContext();
    }

    @Override
    protected RequestAuthenticationProcessor.AuthDomainState handleCurrentAuthenticationDomain(AuthenticationDomain<HttpAuthenticationFrontend> authenticationDomain, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
        AuthCredentials ac;
        HttpAuthenticationFrontend httpAuthenticator = authenticationDomain.getFrontend();
        if (this.isAuthDomainMetaRequest && this.authDomainMetaRequest.authDomainType.equals(httpAuthenticator.getType()) && ("_first".equals(this.authDomainMetaRequest.authDomainId) || authenticationDomain.getId().equals(this.authDomainMetaRequest.authDomainId)) && httpAuthenticator instanceof LegacyHTTPAuthenticator && ((LegacyHTTPAuthenticator)httpAuthenticator).handleMetaRequest(this.restRequest, this.restChannel, this.authDomainMetaRequest.authDomainPath, this.authDomainMetaRequest.remainingPath, this.threadContext)) {
            return RequestAuthenticationProcessor.AuthDomainState.STOP;
        }
        if (log.isTraceEnabled()) {
            log.trace("Try to extract auth creds from {} http authenticator", (Object)httpAuthenticator.getType());
        }
        try {
            ac = httpAuthenticator.extractCredentials(this.request);
        }
        catch (Exception e1) {
            log.warn("'{}' extracting credentials from {} http authenticator", (Object)e1.toString(), (Object)httpAuthenticator.getType(), (Object)e1);
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        if (ac != null && this.isUserBlocked(authenticationDomain.getType(), ac.getUsername())) {
            if (log.isDebugEnabled()) {
                log.debug("Rejecting REST request because of blocked user: " + ac.getUsername() + "; authDomain: " + authenticationDomain);
            }
            this.auditLog.logBlockedUser(ac, false, ac, this.restRequest);
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        if (ac == null) {
            log.trace("no {} credentials found in request", (Object)authenticationDomain.getFrontend().getType());
            if (this.isChallengeEnabled(authenticationDomain)) {
                if (httpAuthenticator instanceof LegacyHTTPAuthenticator && ((LegacyHTTPAuthenticator)httpAuthenticator).reRequestAuthentication(this.restChannel, ac)) {
                    return RequestAuthenticationProcessor.AuthDomainState.STOP;
                }
                String challenge = httpAuthenticator.getChallenge(ac);
                if (challenge != null) {
                    this.challenges.add(challenge);
                }
            }
            return RequestAuthenticationProcessor.AuthDomainState.SKIP;
        }
        ThreadContext.put((String)"user", (String)ac.getUsername());
        if (!ac.isComplete()) {
            if (this.isChallengeEnabled(authenticationDomain) && httpAuthenticator instanceof LegacyHTTPAuthenticator && ((LegacyHTTPAuthenticator)httpAuthenticator).reRequestAuthentication(this.restChannel, ac)) {
                ac.clearSecrets();
                return RequestAuthenticationProcessor.AuthDomainState.STOP;
            }
            String challenge = httpAuthenticator.getChallenge(ac);
            if (challenge != null) {
                this.challenges.add(challenge);
                ac.clearSecrets();
                return RequestAuthenticationProcessor.AuthDomainState.STOP;
            }
        }
        ac = ac.userMappingAttributes((ImmutableMap<String, Object>)ImmutableMap.of((Object)"request", (Object)ImmutableMap.of((Object)"headers", (Object)this.restRequest.getHeaders(), (Object)"direct_ip_address", (Object)String.valueOf(this.request.getDirectIpAddress()), (Object)"originating_ip_address", (Object)String.valueOf(this.request.getOriginatingIpAddress()))));
        return this.proceed(ac, authenticationDomain, onResult, onFailure);
    }

    @Override
    protected AuthcResult handleChallenge() {
        if (this.challenges.size() == 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending WWW-Authenticate: " + String.join((CharSequence)", ", this.challenges));
        }
        BytesRestResponse wwwAuthenticateResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED, "Unauthorized");
        for (String challenge : this.challenges) {
            wwwAuthenticateResponse.addHeader("WWW-Authenticate", challenge);
        }
        this.restChannel.sendResponse((RestResponse)wwwAuthenticateResponse);
        return AuthcResult.STOP;
    }

    @Override
    protected String getRequestedTenant() {
        if (this.restHandler instanceof TenantAwareRestHandler) {
            return ((TenantAwareRestHandler)this.restHandler).getTenantName(this.request);
        }
        return this.restRequest.header("sgtenant") != null ? this.restRequest.header("sgtenant") : this.restRequest.header("sg_tenant");
    }

    @Override
    protected String getImpersonationUser() {
        return this.restRequest.header("sg_impersonate_as");
    }

    private boolean isChallengeEnabled(AuthenticationDomain<?> authDomain) {
        if (authDomain instanceof LegacyAuthenticationDomain) {
            return ((LegacyAuthenticationDomain)authDomain).isChallenge();
        }
        return true;
    }

    private MetaRequestInfo checkAuthDomainMetaRequest(RestRequest restRequest) {
        String prefix = "/_searchguard/auth_domain/";
        String path = restRequest.path();
        if (!path.startsWith(prefix)) {
            return null;
        }
        int nextSlash = path.indexOf(47, prefix.length());
        if (nextSlash <= 0) {
            return null;
        }
        String authDomainId = path.substring(prefix.length(), nextSlash);
        int nextNextSlash = path.indexOf(47, nextSlash + 1);
        String authDomainType = null;
        String authDomainPath = null;
        String remainingPath = "";
        if (nextNextSlash > 0) {
            authDomainPath = path.substring(0, nextNextSlash);
            authDomainType = path.substring(nextSlash + 1, nextNextSlash);
            remainingPath = path.substring(nextNextSlash + 1);
        } else {
            authDomainPath = path;
            authDomainType = path.substring(nextSlash + 1);
        }
        return new MetaRequestInfo(authDomainId, authDomainType, authDomainPath, remainingPath);
    }

    private static class MetaRequestInfo {
        final String authDomainId;
        final String authDomainType;
        final String authDomainPath;
        final String remainingPath;

        public MetaRequestInfo(String authDomainId, String authDomainType, String authDomainPath, String remainingPath) {
            this.authDomainId = authDomainId;
            this.authDomainType = authDomainType;
            this.authDomainPath = authDomainPath;
            this.remainingPath = remainingPath;
        }
    }
}

