/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.support.IPAddressCollection;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IncompatibleAddressException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public abstract class ClientAddressAscertainer {
    private static final IPAddressNetwork.IPAddressGenerator ipAddressGenerator = new IPAddressNetwork.IPAddressGenerator();
    private static final Splitter splitter = Splitter.on((char)',').trimResults();
    private static final Logger log = LogManager.getLogger(ClientAddressAscertainer.class);

    public static ClientAddressAscertainer create(String remoteIpHeader, IPAddressCollection trustedProxies) {
        if (trustedProxies != null) {
            return new CIDRBased(remoteIpHeader, trustedProxies);
        }
        return new Inactive();
    }

    @Deprecated
    public static ClientAddressAscertainer create(String remoteIpHeader, Pattern trustedProxyPattern) {
        if (trustedProxyPattern != null) {
            return new PatternBased(remoteIpHeader, trustedProxyPattern);
        }
        return new Inactive();
    }

    public static ClientAddressAscertainer create(RestAuthcConfig.Network network) {
        if (network == null) {
            return new Inactive();
        }
        if (network.getTrustedProxies() != null) {
            return ClientAddressAscertainer.create(network.getRemoteIpHttpHeader(), network.getTrustedProxies());
        }
        return ClientAddressAscertainer.create(network.getRemoteIpHttpHeader(), network.getTrustedProxiesPattern());
    }

    public abstract ClientIpInfo getActualRemoteAddress(RestRequest var1);

    public static class ClientIpInfo {
        private final IPAddress directIpAddress;
        private final IPAddress originatingIpAddress;
        private final boolean trustedProxy;
        private final InetSocketAddress originalRemoteAddress;

        ClientIpInfo(IPAddress directIpAddress, IPAddress originatingIpAddress, boolean trustedProxy, InetSocketAddress originalRemoteAddress) {
            this.directIpAddress = directIpAddress;
            this.originatingIpAddress = originatingIpAddress;
            this.trustedProxy = trustedProxy;
            this.originalRemoteAddress = originalRemoteAddress;
        }

        public IPAddress getDirectIpAddress() {
            return this.directIpAddress;
        }

        public IPAddress getOriginatingIpAddress() {
            return this.originatingIpAddress;
        }

        public TransportAddress getOriginatingTransportAddress() {
            return new TransportAddress(new InetSocketAddress(this.originatingIpAddress.toInetAddress(), this.originalRemoteAddress.getPort()));
        }

        public boolean isTrustedProxy() {
            return this.trustedProxy;
        }

        static ClientIpInfo trusted(IPAddress directIpAddress, IPAddress originatingIpAddress, InetSocketAddress originalRemoteAddress) {
            return new ClientIpInfo(directIpAddress, originatingIpAddress, true, originalRemoteAddress);
        }

        static ClientIpInfo untrusted(IPAddress ipAddress, InetSocketAddress originalRemoteAddress) {
            return new ClientIpInfo(ipAddress, ipAddress, false, originalRemoteAddress);
        }

        public String toString() {
            return "ClientInfo [directIpAddress=" + this.directIpAddress + ", originatingIpAddress=" + this.originatingIpAddress + ", trustedProxy=" + this.trustedProxy + "]";
        }
    }

    static class Inactive
    extends ClientAddressAscertainer {
        Inactive() {
        }

        @Override
        public ClientIpInfo getActualRemoteAddress(RestRequest request) {
            return ClientIpInfo.untrusted(ipAddressGenerator.from(request.getHttpChannel().getRemoteAddress().getAddress()), request.getHttpChannel().getRemoteAddress());
        }
    }

    @Deprecated
    static class PatternBased
    extends ClientAddressAscertainer {
        private final String remoteIpHeader;
        private final Pattern trustedProxiesPattern;

        PatternBased(String remoteIpHeader, Pattern trustedProxiesPattern) {
            this.remoteIpHeader = remoteIpHeader;
            this.trustedProxiesPattern = trustedProxiesPattern;
        }

        @Override
        public ClientIpInfo getActualRemoteAddress(RestRequest request) {
            IPAddress directIpAddress = ipAddressGenerator.from(request.getHttpChannel().getRemoteAddress().getAddress());
            String ipAddressString = request.getHttpChannel().getRemoteAddress().getAddress().getHostAddress();
            if (!this.trustedProxiesPattern.matcher(ipAddressString).matches()) {
                if (log.isDebugEnabled()) {
                    log.debug("Request from untrusted host: " + directIpAddress);
                }
                return ClientIpInfo.untrusted(directIpAddress, request.getHttpChannel().getRemoteAddress());
            }
            List xffHeaders = (List)request.getHeaders().get(this.remoteIpHeader);
            if (xffHeaders == null || xffHeaders.isEmpty()) {
                return ClientIpInfo.trusted(directIpAddress, directIpAddress, request.getHttpChannel().getRemoteAddress());
            }
            List ipAddressStrings = xffHeaders.stream().flatMap(h -> splitter.splitToStream((CharSequence)h)).map(ip -> new IPAddressString(ip)).collect(Collectors.toList());
            for (IPAddressString ipString : Lists.reverse(ipAddressStrings)) {
                try {
                    IPAddress ip2 = ipString.toAddress();
                    if (this.trustedProxiesPattern.matcher(ipString.toString()).matches()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Request from trusted proxy " + directIpAddress + "; actual client: " + ip2);
                    }
                    return ClientIpInfo.trusted(directIpAddress, ip2, request.getHttpChannel().getRemoteAddress());
                }
                catch (AddressStringException | IncompatibleAddressException e) {
                    log.warn("Unparseable IP in XFF headers of request: " + xffHeaders, e);
                    throw new ElasticsearchStatusException("Invalid " + this.remoteIpHeader + "header", RestStatus.BAD_REQUEST, new Object[0]);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Request from trusted proxy " + directIpAddress + "; actual client: " + ipAddressStrings.get(0) + " (which is also trusted)");
            }
            try {
                return ClientIpInfo.trusted(directIpAddress, ((IPAddressString)ipAddressStrings.get(0)).toAddress(), request.getHttpChannel().getRemoteAddress());
            }
            catch (AddressStringException | IncompatibleAddressException e) {
                log.warn("Unparseable IP in XFF headers of request: " + xffHeaders, e);
                throw new ElasticsearchStatusException("Invalid " + this.remoteIpHeader + "header", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    static class CIDRBased
    extends ClientAddressAscertainer {
        private final String remoteIpHeader;
        private final IPAddressCollection trustedProxies;

        CIDRBased(String remoteIpHeader, IPAddressCollection trustedProxies) {
            this.remoteIpHeader = remoteIpHeader;
            this.trustedProxies = trustedProxies;
        }

        @Override
        public ClientIpInfo getActualRemoteAddress(RestRequest request) {
            IPAddress directIpAddress = ipAddressGenerator.from(request.getHttpChannel().getRemoteAddress().getAddress());
            if (!this.trustedProxies.contains(directIpAddress)) {
                if (log.isDebugEnabled()) {
                    log.debug("Request from untrusted host: " + directIpAddress);
                }
                return ClientIpInfo.untrusted(directIpAddress, request.getHttpChannel().getRemoteAddress());
            }
            List xffHeaders = (List)request.getHeaders().get(this.remoteIpHeader);
            if (xffHeaders == null || xffHeaders.isEmpty()) {
                return ClientIpInfo.trusted(directIpAddress, directIpAddress, request.getHttpChannel().getRemoteAddress());
            }
            List ipAddressStrings = xffHeaders.stream().flatMap(h -> splitter.splitToStream((CharSequence)h)).map(ip -> new IPAddressString(ip)).collect(Collectors.toList());
            for (IPAddressString ipString : Lists.reverse(ipAddressStrings)) {
                try {
                    IPAddress ip2 = ipString.toAddress();
                    if (this.trustedProxies.contains(ip2)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Request from trusted proxy " + directIpAddress + "; actual client: " + ip2);
                    }
                    return ClientIpInfo.trusted(directIpAddress, ip2, request.getHttpChannel().getRemoteAddress());
                }
                catch (AddressStringException | IncompatibleAddressException e) {
                    log.warn("Unparseable IP in XFF headers of request: " + xffHeaders, e);
                    throw new ElasticsearchStatusException("Invalid " + this.remoteIpHeader + "header", RestStatus.BAD_REQUEST, new Object[0]);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Request from trusted proxy " + directIpAddress + "; actual client: " + ipAddressStrings.get(0) + " (which is also trusted)");
            }
            try {
                return ClientIpInfo.trusted(directIpAddress, ((IPAddressString)ipAddressStrings.get(0)).toAddress(), request.getHttpChannel().getRemoteAddress());
            }
            catch (AddressStringException | IncompatibleAddressException e) {
                log.warn("Unparseable IP in XFF headers of request: " + xffHeaders, e);
                throw new ElasticsearchStatusException("Invalid " + this.remoteIpHeader + "header", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }
}

