/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthFailureListener;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.base.IPAddressAcceptanceRules;
import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.rest.ClientAddressAscertainer;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.rest.RestRequestAuthenticationProcessor;
import com.floragunn.searchguard.authc.rest.RestRequestMetaData;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.CacheStats;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.google.common.cache.Cache;
import inet.ipaddr.IPAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public interface RestAuthenticationProcessor
extends ComponentStateProvider {
    public void authenticate(RestHandler var1, RestRequest var2, RestChannel var3, Consumer<AuthcResult> var4, Consumer<Exception> var5);

    public boolean isDebugEnabled();

    public void clearCaches();

    public static class Default
    implements RestAuthenticationProcessor {
        private static final Logger log = LogManager.getLogger(RestAuthenticationProcessor.class);
        private final AuditLog auditLog;
        private final ThreadContext threadContext;
        private final AdminDNs adminDns;
        private final Cache<AuthCredentials, User> userCache;
        private final Cache<String, User> impersonationCache;
        private final PrivilegesEvaluator privilegesEvaluator;
        private final BlockedIpRegistry blockedIpRegistry;
        private final BlockedUserRegistry blockedUserRegistry;
        private final boolean debug;
        private final RestAuthcConfig authcConfig;
        private final List<AuthenticationDomain<HttpAuthenticationFrontend>> authenticationDomains;
        private final ClientAddressAscertainer clientAddressAscertainer;
        private final IPAddressAcceptanceRules ipAddressAcceptanceRules;
        private final List<String> requiredLoginPrivileges = Collections.emptyList();
        private final ComponentState componentState = new ComponentState(0, "rest_authentication_processor", "rest_authentication_processor");
        private final TimeAggregation authenticateMetrics = new TimeAggregation.Milliseconds();
        private List<AuthFailureListener> ipAuthFailureListeners = ImmutableList.empty();

        public Default(RestAuthcConfig config, SearchGuardModulesRegistry modulesRegistry, AdminDNs adminDns, BlockedIpRegistry blockedIpRegistry, BlockedUserRegistry blockedUserRegistry, AuditLog auditLog, ThreadPool threadPool, PrivilegesEvaluator privilegesEvaluator) {
            this.authcConfig = config;
            this.authenticationDomains = modulesRegistry.getImplicitHttpAuthenticationDomains().with(this.authcConfig.getAuthenticators());
            this.clientAddressAscertainer = ClientAddressAscertainer.create(this.authcConfig.getNetwork());
            this.ipAddressAcceptanceRules = this.authcConfig.getNetwork() != null ? this.authcConfig.getNetwork().getIpAddressAcceptanceRules() : IPAddressAcceptanceRules.ANY;
            this.debug = config.isDebugEnabled();
            this.auditLog = auditLog;
            this.threadContext = threadPool.getThreadContext();
            this.adminDns = adminDns;
            this.privilegesEvaluator = privilegesEvaluator;
            this.blockedIpRegistry = blockedIpRegistry;
            this.blockedUserRegistry = blockedUserRegistry;
            if (this.authcConfig.getMetricsLevel().basicEnabled()) {
                this.userCache = this.authcConfig.getUserCacheConfig().buildWithStats();
                this.impersonationCache = this.authcConfig.getUserCacheConfig().buildWithStats();
            } else {
                this.userCache = this.authcConfig.getUserCacheConfig().build();
                this.impersonationCache = this.authcConfig.getUserCacheConfig().build();
            }
            for (AuthenticationDomain<HttpAuthenticationFrontend> authenticationDomain : this.authenticationDomains) {
                this.componentState.addPart(authenticationDomain.getComponentState());
            }
            if (this.authcConfig.getMetricsLevel().basicEnabled()) {
                this.componentState.addMetrics("authenticate", (Measurement)this.authenticateMetrics);
                this.componentState.addMetrics("user_cache", (Measurement)CacheStats.from(this.userCache));
                this.componentState.addMetrics("impersonation_cache", (Measurement)CacheStats.from(this.impersonationCache));
            }
        }

        @Override
        public void authenticate(RestHandler restHandler, RestRequest request, RestChannel channel, Consumer<AuthcResult> onResult, Consumer<Exception> onFailure) {
            Meter meter = Meter.basic((MetricsLevel)this.authcConfig.getMetricsLevel(), (TimeAggregation)this.authenticateMetrics);
            String sslPrincipal = (String)this.threadContext.getTransient("_sg_ssl_principal");
            ClientAddressAscertainer.ClientIpInfo clientInfo = this.clientAddressAscertainer.getActualRemoteAddress(request);
            RestRequestMetaData requestMetaData = new RestRequestMetaData(request, clientInfo, sslPrincipal);
            IPAddress remoteIpAddress = clientInfo.getOriginatingIpAddress();
            if (!this.ipAddressAcceptanceRules.accept(requestMetaData)) {
                log.info("Not accepting request from {}", (Object)requestMetaData);
                meter.close();
                onResult.accept(AuthcResult.stop(RestStatus.FORBIDDEN, "Forbidden", (List<AuthcResult.DebugInfo>)ImmutableList.of((Object)new AuthcResult.DebugInfo("-/-", false, "Request denied because client IP address is denied by authc.network.accept configuration", (Map<String, Object>)ImmutableMap.of((Object)"direct_ip_address", (Object)clientInfo.getDirectIpAddress(), (Object)"originating_ip_address", (Object)clientInfo.getOriginatingIpAddress(), (Object)"trusted_proxy", (Object)clientInfo.isTrustedProxy())))));
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Rest authentication request from {} [original: {}]", (Object)remoteIpAddress, (Object)request.getHttpChannel().getRemoteAddress());
            }
            if (clientInfo.isTrustedProxy()) {
                this.threadContext.putTransient("_sg_xff_done", (Object)Boolean.TRUE);
            }
            this.threadContext.putTransient("_sg_remote_address", (Object)clientInfo.getOriginatingTransportAddress());
            if (this.blockedIpRegistry.isIpBlocked(remoteIpAddress)) {
                if (log.isDebugEnabled()) {
                    log.debug("Rejecting REST request because of blocked address: " + request.getHttpChannel().getRemoteAddress());
                }
                this.auditLog.logBlockedIp(request, request.getHttpChannel().getRemoteAddress());
                meter.close();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
                onResult.accept(new AuthcResult(AuthcResult.Status.STOP));
                return;
            }
            new RestRequestAuthenticationProcessor(restHandler, requestMetaData, this.authenticationDomains, this.adminDns, this.privilegesEvaluator, this.userCache, this.impersonationCache, this.auditLog, this.blockedUserRegistry, this.ipAuthFailureListeners, this.requiredLoginPrivileges, this.debug).authenticate(meter.consumer(onResult), meter.consumer(onFailure));
        }

        @Override
        public boolean isDebugEnabled() {
            return this.debug;
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }

        @Override
        public void clearCaches() {
            this.userCache.invalidateAll();
            this.impersonationCache.invalidateAll();
        }
    }
}

