/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.searchguard.authc.session.backend.SessionService;
import com.floragunn.searchguard.authc.session.backend.SessionToken;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class PushSessionTokenUpdateAction
extends ActionType<Response> {
    public static final PushSessionTokenUpdateAction INSTANCE = new PushSessionTokenUpdateAction();
    public static final String NAME = "cluster:admin/searchguard/session_token/update/push";

    protected PushSessionTokenUpdateAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse> {
        private final SessionService sessionService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SessionService sessionService) {
            super(PushSessionTokenUpdateAction.NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "management", NodeResponse.class);
            this.sessionService = sessionService;
        }

        protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            return new NodeResponse(in);
        }

        protected Response newResponse(Request request, List<NodeResponse> responses, List<FailedNodeException> failures) {
            return new Response(this.clusterService.getClusterName(), responses, failures);
        }

        protected NodeResponse nodeOperation(NodeRequest request) {
            String status = this.sessionService.pushAuthTokenUpdate(request.request);
            return new NodeResponse(this.clusterService.localNode(), status);
        }

        protected NodeRequest newNodeRequest(Request request) {
            return new NodeRequest(request);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private String message;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.message = in.readOptionalString();
        }

        public NodeResponse(DiscoveryNode node, String message) {
            super(node);
            this.message = message;
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            return new NodeResponse(in);
        }

        public String getMessage() {
            return this.message;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.message);
        }

        public String toString() {
            return "NodeResponse [message=" + this.message + "]";
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        Request request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new Request(in);
        }

        public NodeRequest(Request request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse> {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::readNodeResponse);
        }

        public void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }

        public String toString() {
            return "PushSessionTokenUpdateAction.Response [failures()=" + this.failures() + ", getNodes()=" + this.getNodes() + "]";
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private SessionToken updatedToken;
        private UpdateType updateType;
        private long newHash;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.updatedToken = new SessionToken(in);
            this.updateType = (UpdateType)in.readEnum(UpdateType.class);
            this.newHash = in.readLong();
        }

        public Request(SessionToken updatedToken, UpdateType updateType, long newHash) {
            super(new String[0]);
            this.updatedToken = updatedToken;
            this.updateType = updateType;
            this.newHash = newHash;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.updatedToken.writeTo(out);
            out.writeEnum((Enum)this.updateType);
            out.writeLong(this.newHash);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public SessionToken getUpdatedToken() {
            return this.updatedToken;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public String toString() {
            return "PushSessionTokenUpdateAction.Request [updatedToken=" + this.updatedToken + ", updateType=" + (Object)((Object)this.updateType) + "]";
        }

        public long getNewHash() {
            return this.newHash;
        }

        public static enum UpdateType {
            NEW,
            REVOKED;

        }
    }
}

