/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.user.User;
import java.util.HashMap;
import java.util.Map;

public class PrivilegesEvaluationContext {
    private boolean resolveLocalAll = true;
    private final User user;
    private final Action action;
    private final Object request;
    private final Map<Template<Pattern>, Pattern> renderedPatternTemplateCache = new HashMap<Template<Pattern>, Pattern>();
    private final ImmutableSet<String> mappedRoles;
    private final ActionRequestIntrospector actionRequestIntrospector;
    private final SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext;
    private final boolean debugEnabled;
    private ActionRequestIntrospector.ActionRequestInfo requestInfo;

    public PrivilegesEvaluationContext(User user, ImmutableSet<String> mappedRoles, Action action, Object request, boolean debugEnabled, ActionRequestIntrospector actionRequestIntrospector, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext) {
        this.user = user;
        this.mappedRoles = mappedRoles;
        this.action = action;
        this.request = request;
        this.actionRequestIntrospector = actionRequestIntrospector;
        this.debugEnabled = debugEnabled;
        this.specialPrivilegesEvaluationContext = specialPrivilegesEvaluationContext;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isResolveLocalAll() {
        return this.resolveLocalAll;
    }

    public void setResolveLocalAll(boolean resolveLocalAll) {
        this.resolveLocalAll = resolveLocalAll;
    }

    public Pattern getRenderedPattern(Template<Pattern> template) throws ExpressionEvaluationException {
        Pattern pattern = this.renderedPatternTemplateCache.get(template);
        if (pattern == null) {
            pattern = (Pattern)template.render((AttributeSource)this.user);
            this.renderedPatternTemplateCache.put(template, pattern);
        }
        return pattern;
    }

    public ActionRequestIntrospector.ActionRequestInfo getRequestInfo() {
        if (this.requestInfo == null) {
            this.requestInfo = this.actionRequestIntrospector.getActionRequestInfo(this.action.name(), this.request);
        }
        return this.requestInfo;
    }

    public Action getAction() {
        return this.action;
    }

    public Object getRequest() {
        return this.request;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public ImmutableSet<String> getMappedRoles() {
        return this.mappedRoles;
    }

    public PrivilegesEvaluationContext mappedRoles(ImmutableSet<String> mappedRoles) {
        if (this.mappedRoles != null && this.mappedRoles.equals(mappedRoles)) {
            return this;
        }
        return new PrivilegesEvaluationContext(this.user, mappedRoles, this.action, mappedRoles, this.debugEnabled, this.actionRequestIntrospector, this.specialPrivilegesEvaluationContext);
    }

    public SpecialPrivilegesEvaluationContext getSpecialPrivilegesEvaluationContext() {
        return this.specialPrivilegesEvaluationContext;
    }
}

