/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.CheckTable;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.actions.Action;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.rest.RestStatus;

public class PrivilegesEvaluationResult {
    public static final PrivilegesEvaluationResult OK = new PrivilegesEvaluationResult(Status.OK);
    public static final PrivilegesEvaluationResult PARTIALLY_OK = new PrivilegesEvaluationResult(Status.PARTIALLY_OK);
    public static final PrivilegesEvaluationResult EMPTY = new PrivilegesEvaluationResult(Status.EMPTY);
    public static final PrivilegesEvaluationResult INSUFFICIENT = new PrivilegesEvaluationResult(Status.INSUFFICIENT);
    public static final PrivilegesEvaluationResult PENDING = new PrivilegesEvaluationResult(Status.PENDING);
    private final Status status;
    private final CheckTable<String, Action> indexToActionPrivilegeTable;
    private final ImmutableList<Error> errors;
    private final ImmutableSet<String> availableIndices;
    private final String reason;
    private final ImmutableList<ActionFilter> additionalActionFilters;

    PrivilegesEvaluationResult(Status status) {
        this.status = status;
        this.indexToActionPrivilegeTable = null;
        this.errors = ImmutableList.empty();
        this.reason = null;
        this.availableIndices = null;
        this.additionalActionFilters = ImmutableList.empty();
    }

    PrivilegesEvaluationResult(Status status, String reason, ImmutableSet<String> availableIndices, CheckTable<String, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors, ImmutableList<ActionFilter> additionalActionFilters) {
        this.status = status;
        this.indexToActionPrivilegeTable = indexToActionPrivilegeTable;
        this.errors = errors;
        this.reason = reason;
        this.availableIndices = availableIndices;
        this.additionalActionFilters = additionalActionFilters;
    }

    public PrivilegesEvaluationResult reason(String reason) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.indexToActionPrivilegeTable, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult reason(String reason, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.indexToActionPrivilegeTable, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult reason(String reason, Error error) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, this.indexToActionPrivilegeTable, (ImmutableList<Error>)ImmutableList.of(this.errors), this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(CheckTable<String, Action> indexToActionPrivilegeTable) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, indexToActionPrivilegeTable, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(CheckTable<String, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, indexToActionPrivilegeTable, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(String reason, CheckTable<String, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, reason, this.availableIndices, indexToActionPrivilegeTable, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult with(ImmutableList<Error> errors) {
        if (errors.size() != 0) {
            return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.indexToActionPrivilegeTable, errors, this.additionalActionFilters);
        }
        return this;
    }

    public PrivilegesEvaluationResult with(ActionFilter additionalActionFilter) {
        if (additionalActionFilter != null) {
            return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, this.indexToActionPrivilegeTable, this.errors, (ImmutableList<ActionFilter>)this.additionalActionFilters.with((Object)additionalActionFilter));
        }
        return this;
    }

    public PrivilegesEvaluationResult availableIndices(ImmutableSet<String> availableIndices, CheckTable<String, Action> indexToActionPrivilegeTable, ImmutableList<Error> errors) {
        return new PrivilegesEvaluationResult(this.status, this.reason, availableIndices, indexToActionPrivilegeTable, errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult availableIndices(ImmutableSet<String> availableIndices, CheckTable<String, Action> indexToActionPrivilegeTable) {
        return new PrivilegesEvaluationResult(this.status, this.reason, availableIndices, indexToActionPrivilegeTable, this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult missingPrivileges(Action action) {
        return new PrivilegesEvaluationResult(this.status, this.reason, this.availableIndices, (CheckTable<String, Action>)CheckTable.create((Object)"_", (Set)ImmutableSet.of((Object)action)), this.errors, this.additionalActionFilters);
    }

    public PrivilegesEvaluationResult status(Status status) {
        return new PrivilegesEvaluationResult(status, this.reason, this.availableIndices, this.indexToActionPrivilegeTable, this.errors, this.additionalActionFilters);
    }

    public CheckTable<String, Action> getIndexToActionPrivilegeTable() {
        return this.indexToActionPrivilegeTable;
    }

    public ImmutableList<Error> getErrors() {
        return this.errors;
    }

    public Throwable getFirstThrowable() {
        if (this.errors.isEmpty()) {
            return null;
        }
        for (Error error : this.errors) {
            if (error.cause == null) continue;
            return error.cause;
        }
        return null;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public ImmutableSet<String> getAvailableIndices() {
        return this.availableIndices;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("");
        result.append("Status: ").append((Object)this.status).append("\n");
        if (this.reason != null) {
            result.append("Reason: ").append(this.reason).append("\n");
        }
        if (this.indexToActionPrivilegeTable != null) {
            String evaluatedPrivileges = this.indexToActionPrivilegeTable.toString("ok", "MISSING");
            if (evaluatedPrivileges.length() > 30 || evaluatedPrivileges.contains("\n")) {
                result.append("Evaluated Privileges:\n").append(evaluatedPrivileges).append("\n");
            } else {
                result.append("Evaluated Privileges: ").append(evaluatedPrivileges).append("\n");
            }
        }
        if (this.errors.size() == 1) {
            result.append("Errors: ").append(this.errors.only());
        } else if (this.errors.size() > 1) {
            result.append("Errors:\n").append(this.errors.stream().map(e -> " - " + e + "\n").collect(Collectors.toList())).append("\n");
        }
        return result.toString();
    }

    public ImmutableList<ActionFilter> getAdditionalActionFilters() {
        return this.additionalActionFilters;
    }

    public boolean hasAdditionalActionFilters() {
        return this.additionalActionFilters != null && this.additionalActionFilters.size() > 0;
    }

    public Exception toSecurityException(PrivilegesEvaluationContext context) {
        ElasticsearchSecurityException result = new ElasticsearchSecurityException("Insufficient permissions", RestStatus.FORBIDDEN, new Object[0]);
        if (context.isDebugEnabled()) {
            if (this.indexToActionPrivilegeTable != null) {
                if (!this.isRelatedToIndexPermission()) {
                    result.addMetadata("es.missing_permissions", this.indexToActionPrivilegeTable.getColumns().stream().map(a -> a.name()).collect(Collectors.toList()));
                } else {
                    result.addMetadata("es.missing_permissions", this.getFlattenedIndexToActionPrivilegeTable());
                }
            }
            if (this.reason != null) {
                result.addMetadata("es.reason_detail", new String[]{this.reason});
            }
            result.addMetadata("es.user", new String[]{String.valueOf(context.getUser())});
            if (context.getMappedRoles() != null) {
                result.addMetadata("es.effective_roles", context.getMappedRoles().stream().collect(Collectors.toList()));
            }
            result.addMetadata("es.user_attributes", context.getUser().getStructuredAttributes().keySet().stream().collect(Collectors.toList()));
            if (this.errors != null && !this.errors.isEmpty()) {
                result.addMetadata("es.errors", this.errors.stream().map(e -> e.toString()).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private boolean isRelatedToIndexPermission() {
        return this.indexToActionPrivilegeTable != null && ((Action)this.indexToActionPrivilegeTable.getColumns().any()).isIndexPrivilege();
    }

    private List<String> getFlattenedIndexToActionPrivilegeTable() {
        ArrayList<String> result = new ArrayList<String>();
        for (String index : this.indexToActionPrivilegeTable.getRows()) {
            for (Action action : this.indexToActionPrivilegeTable.getColumns()) {
                if (this.indexToActionPrivilegeTable.isChecked((Object)index, (Object)action)) continue;
                result.add(index + ": " + action);
            }
        }
        return result;
    }

    public static class Error {
        private final String message;
        private final Throwable cause;
        private final String role;
        private final Throwable rootCause;

        public Error(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
            this.role = null;
            this.rootCause = Error.getRootCause(cause);
        }

        public Error(String message, Throwable cause, String role) {
            this.message = message;
            this.cause = cause;
            this.role = role;
            this.rootCause = Error.getRootCause(cause);
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            if (this.rootCause != null) {
                return this.message + " [" + this.rootCause + "]";
            }
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Error)) {
                return false;
            }
            Error other = (Error)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String getRole() {
            return this.role;
        }

        private static Throwable getRootCause(Throwable t) {
            if (t == null) {
                return null;
            }
            for (int i = 0; t.getCause() != null && t.getCause() != t && i < 10; t = t.getCause(), ++i) {
            }
            return t;
        }
    }

    public static enum Status {
        OK,
        PARTIALLY_OK,
        EMPTY,
        INSUFFICIENT,
        PENDING;

    }
}

