/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.support.ActionFilter;

public class PrivilegesEvaluatorResponse {
    boolean allowed = false;
    Set<String> missingPrivileges = new HashSet<String>();
    List<ActionFilter> additionalActionFilters;
    ImmutableSet<String> mappedRoles;
    PrivilegesEvaluatorResponseState state = PrivilegesEvaluatorResponseState.PENDING;
    ActionRequestIntrospector.ActionRequestInfo actionRequestInfo;

    public ActionRequestIntrospector.ActionRequestInfo getActionRequestInfo() {
        return this.actionRequestInfo;
    }

    public ActionRequestIntrospector.ResolvedIndices getResolvedIndices() {
        return this.actionRequestInfo != null ? this.actionRequestInfo.getResolvedIndices() : null;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public Set<String> getMissingPrivileges() {
        return new HashSet<String>(this.missingPrivileges);
    }

    public PrivilegesEvaluatorResponse markComplete() {
        this.state = PrivilegesEvaluatorResponseState.COMPLETE;
        return this;
    }

    public PrivilegesEvaluatorResponse markPending() {
        this.state = PrivilegesEvaluatorResponseState.PENDING;
        return this;
    }

    public boolean isComplete() {
        return this.state == PrivilegesEvaluatorResponseState.COMPLETE;
    }

    public boolean isPending() {
        return this.state == PrivilegesEvaluatorResponseState.PENDING;
    }

    public String toString() {
        return "PrivEvalResponse [allowed=" + this.allowed + ", missingPrivileges=" + this.missingPrivileges + "]";
    }

    void addAdditionalActionFilter(ActionFilter actionFilter) {
        if (this.additionalActionFilters == null) {
            this.additionalActionFilters = new ArrayList<ActionFilter>(4);
        }
        this.additionalActionFilters.add(actionFilter);
    }

    public boolean hasAdditionalActionFilters() {
        return this.additionalActionFilters != null && this.additionalActionFilters.size() > 0;
    }

    public List<ActionFilter> getAdditionalActionFilters() {
        if (this.additionalActionFilters != null) {
            return this.additionalActionFilters;
        }
        return Collections.emptyList();
    }

    public ImmutableSet<String> getMappedRoles() {
        return this.mappedRoles;
    }

    public static enum PrivilegesEvaluatorResponseState {
        PENDING,
        COMPLETE;

    }
}

