/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigsRelationsValidator {
    private static final Logger log = LogManager.getLogger(ConfigsRelationsValidator.class);
    private ConfigMap configMap;

    ConfigsRelationsValidator(ConfigurationRepository configurationRepository) {
        Objects.requireNonNull(configurationRepository, "Configuration repository is required");
        configurationRepository.subscribeOnChange(this::onCofigurationChange);
    }

    public List<ValidationError> validateConfigsRelations(List<SgDynamicConfiguration<?>> newConfigs) {
        List<SgDynamicConfiguration<?>> notNullConfigs = newConfigs.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Optional<SgDynamicConfiguration<Role>> newRolesConfig = this.findConfigOfType(CType.ROLES.getType(), notNullConfigs);
        errors.addAll(newRolesConfig.map(roles -> this.validateRolesRelations((SgDynamicConfiguration<Role>)roles, notNullConfigs)).orElse(Collections.emptyList()));
        return errors;
    }

    public List<ValidationError> validateConfigRelations(SgDynamicConfiguration<?> config) {
        return this.validateConfigsRelations(Collections.singletonList(config));
    }

    public <T> List<ValidationError> validateConfigEntryRelations(T entry) {
        if (Objects.nonNull(entry)) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            if (CType.ROLES.getType().isAssignableFrom(entry.getClass())) {
                SgDynamicConfiguration<Tenant> tenantsConfig = this.getConfigFromMap(CType.TENANTS);
                errors.addAll(this.validateRoleEntryRelations(null, (Role)entry, tenantsConfig));
            }
            return errors;
        }
        return Collections.emptyList();
    }

    void onCofigurationChange(ConfigMap configMap) {
        this.configMap = configMap;
    }

    private List<ValidationError> validateRolesRelations(SgDynamicConfiguration<Role> newRolesConfig, List<SgDynamicConfiguration<?>> newConfigs) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SgDynamicConfiguration<Tenant> existingTenantsConfig = this.getConfigFromMap(CType.TENANTS);
        SgDynamicConfiguration<Tenant> newTenantsConfig = this.findConfigOfType(CType.TENANTS.getType(), newConfigs).map(newTenants -> newTenants.withStatic(this.getStaticConfigEntries(existingTenantsConfig))).orElse(existingTenantsConfig);
        newRolesConfig.getCEntries().forEach((roleName, role) -> {
            String attribute = String.format("%s.%s", CType.ROLES.getName(), roleName);
            errors.addAll(this.validateRoleEntryRelations(attribute, (Role)role, newTenantsConfig));
        });
        return errors;
    }

    private List<ValidationError> validateRoleEntryRelations(String attribute, Role roleConfig, SgDynamicConfiguration<Tenant> tenantsConfig) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ImmutableSet tenantNames = tenantsConfig.getCEntries().keySet().with((Object)"SGS_GLOBAL_TENANT");
        roleConfig.getTenantPermissions().forEach(tenant -> tenant.getTenantPatterns().forEach(tenantPattern -> {
            if (!this.tenantPatternMatchesAnyTenant((Template<Pattern>)tenantPattern, (ImmutableSet<String>)tenantNames)) {
                String msg = String.format("Tenant pattern: '%s' does not match any tenant", tenantPattern.getSource());
                errors.add(new ValidationError(attribute, msg));
            }
        }));
        return errors;
    }

    private <T> Optional<SgDynamicConfiguration<T>> findConfigOfType(Class<T> type, List<SgDynamicConfiguration<?>> newConfigs) {
        return newConfigs.stream().filter(config -> config.getCType().getType().isAssignableFrom(type)).findFirst().map(config -> config);
    }

    private <T> SgDynamicConfiguration<T> getConfigFromMap(CType<T> typeToLoad) {
        return Optional.ofNullable(this.configMap).map(confMap -> confMap.get(typeToLoad)).orElseGet(() -> {
            log.warn("Config of type {} is unavailable, an empty config will be used instead", (Object)typeToLoad.getName());
            return SgDynamicConfiguration.empty(typeToLoad);
        });
    }

    private boolean tenantPatternMatchesAnyTenant(Template<Pattern> tenantPattern, ImmutableSet<String> tenantNames) {
        return !tenantNames.isEmpty() && !((Pattern)tenantPattern.getConstantValue()).getMatching(tenantNames).isEmpty();
    }

    private <T> Map<String, T> getStaticConfigEntries(SgDynamicConfiguration<T> config) {
        ImmutableSet nonStaticConfigNames = config.withoutStatic().getCEntries().keySet();
        return config.getCEntries().entrySet().stream().filter(arg_0 -> ConfigsRelationsValidator.lambda$getStaticConfigEntries$9((Set)nonStaticConfigNames, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static /* synthetic */ boolean lambda$getStaticConfigEntries$9(Set nonStaticConfigNames, Map.Entry configEntry) {
        return !nonStaticConfigNames.contains(configEntry.getKey());
    }
}

