/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.variables.ConfigVar;
import com.floragunn.searchguard.configuration.variables.ConfigVarApi;
import com.floragunn.searchguard.configuration.variables.ConfigVarRefreshAction;
import com.floragunn.searchguard.configuration.variables.ConfigVarServiceNotYetAvailableException;
import com.floragunn.searchguard.configuration.variables.EncryptionException;
import com.floragunn.searchguard.configuration.variables.EncryptionKeys;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.client.Actions;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class ConfigVarService
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(ConfigVarService.class);
    private final Client client;
    private final PrivilegedConfigClient privilegedConfigClient;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Map<String, RequestedValue> requestedValues = new ConcurrentHashMap<String, RequestedValue>();
    private final ComponentState componentState = new ComponentState(1000, null, "config_var_storage", ConfigVarService.class);
    private final String indexName = ".searchguard_config_vars";
    private volatile Map<String, Object> values;
    private final List<Runnable> changeListeners = new ArrayList<Runnable>();
    private final EncryptionKeys encryptionKeys;

    public ConfigVarService(Client client, ClusterService clusterService, ThreadPool threadPool, ProtectedConfigIndexService protectedConfigIndexService, EncryptionKeys encryptionKeys) {
        this.client = client;
        this.privilegedConfigClient = PrivilegedConfigClient.adapt(client);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.encryptionKeys = encryptionKeys;
        this.componentState.addPart(protectedConfigIndexService.createIndex(new ProtectedConfigIndexService.ConfigIndex(".searchguard_config_vars").mapping(ConfigVar.INDEX_MAPPING).onIndexReady(onFailure -> this.init(onFailure))));
    }

    public Object get(String id) {
        Map<String, Object> values = this.values;
        if (values == null) {
            throw new ConfigVarServiceNotYetAvailableException("ConfigVarService is not yet initialized");
        }
        return values.get(id);
    }

    public String getAsString(String id) {
        Object object = this.get(id);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public String getAsStringMandatory(String id) throws ConfigValidationException {
        Object object = this.get(id);
        if (object != null) {
            return object.toString();
        }
        throw new ConfigValidationException((ValidationError)new MissingAttribute(id));
    }

    public CompletableFuture<StandardResponse> delete(final String id) {
        final CompletableFuture<StandardResponse> result = new CompletableFuture<StandardResponse>();
        this.privilegedConfigClient.delete((DeleteRequest)new DeleteRequest(".searchguard_config_vars", id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(final DeleteResponse deleteResponse) {
                ConfigVarRefreshAction.send(ConfigVarService.this.client, new ActionListener<ConfigVarRefreshAction.Response>(){

                    public void onResponse(ConfigVarRefreshAction.Response response) {
                        try {
                            log.info("Result of settings update:\n" + (Object)((Object)response));
                            if (response.hasFailures()) {
                                result.complete(new StandardResponse(500).error(null, "Index update was successful, but node refresh partially failed", (Object)response.failures().toString()));
                            } else if (deleteResponse.getResult() == DocWriteResponse.Result.DELETED) {
                                result.complete(new StandardResponse(200).message("Deleted"));
                            } else {
                                result.complete(new StandardResponse(404).error("Not found"));
                            }
                        }
                        catch (Exception e) {
                            log.error("Error in onResponse", (Throwable)e);
                            result.completeExceptionally(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        log.error("settings update failed", (Throwable)e);
                        result.complete(new StandardResponse(500).error("Index update was successful, but node refresh failed"));
                    }
                });
            }

            public void onFailure(Exception e) {
                log.error("Error while deleting " + id, (Throwable)e);
                ConfigVarService.this.componentState.addLastException("delete", (Throwable)e);
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<StandardResponse> update(ConfigVarApi.UpdateAction.Request request) throws EncryptionException {
        final String id = request.getId();
        final CompletableFuture<StandardResponse> result = new CompletableFuture<StandardResponse>();
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        if (request.isEncrypt()) {
            doc.put("encrypted", this.encryptionKeys.getEncryptedData(request.getValue()));
        } else {
            doc.put("value", request.getValue());
        }
        if (request.getScope() != null) {
            doc.put("scope", request.getScope());
        }
        doc.put("updated", Instant.now());
        log.info("Writing secret " + id);
        this.privilegedConfigClient.index(((IndexRequest)new IndexRequest(".searchguard_config_vars").opType(request.mustNotExist() ? DocWriteRequest.OpType.CREATE : DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(id).source(doc), (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(final IndexResponse indexResponse) {
                if (indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                    ConfigVarRefreshAction.send(ConfigVarService.this.client, new ActionListener<ConfigVarRefreshAction.Response>(){

                        public void onResponse(ConfigVarRefreshAction.Response response) {
                            try {
                                log.info("Result of settings update:\n" + (Object)((Object)response));
                                if (response.hasFailures()) {
                                    result.complete(new StandardResponse(500).error(null, "Index update was successful, but node refresh partially failed", (Object)response.failures().toString()));
                                } else if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
                                    result.complete(new StandardResponse(201).message("Created"));
                                } else {
                                    result.complete(new StandardResponse(200).message("Updated"));
                                }
                            }
                            catch (Exception e) {
                                log.error("Error in onResponse", (Throwable)e);
                                result.completeExceptionally(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            log.error("settings update failed", (Throwable)e);
                            result.complete(new StandardResponse(500).error("Index update was successful, but node refresh failed"));
                        }
                    });
                } else if (indexResponse.getResult() == DocWriteResponse.Result.NOOP) {
                    result.complete(new StandardResponse(200).message("Not changed"));
                } else {
                    result.complete(new StandardResponse(500).error(null, "Unexpected response", (Object)(indexResponse.getResult() + "")));
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof VersionConflictEngineException) {
                    if (e.getMessage().contains("document already exists")) {
                        result.complete(new StandardResponse(412).error("Variable does already exist"));
                    } else {
                        result.complete(new StandardResponse(412).error(e.getMessage()));
                    }
                } else {
                    log.error("Error while updating " + id, (Throwable)e);
                    ConfigVarService.this.componentState.addLastException("update", (Throwable)e);
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }

    public CompletableFuture<StandardResponse> updateAll(Map<String, ConfigVar> valueMap) {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ValidationErrors validationErrors = new ValidationErrors();
        for (Map.Entry<String, ConfigVar> entry : valueMap.entrySet()) {
            ConfigVar configVar = entry.getValue();
            if (configVar.getEncValue() != null) {
                try {
                    this.encryptionKeys.getDecryptedData(configVar);
                }
                catch (Exception e) {
                    validationErrors.add(new ValidationError((String)entry.getKey(), e.getMessage()).cause((Throwable)e));
                }
            }
            bulkRequest.add(new IndexRequest(".searchguard_config_vars").id(entry.getKey()).source(DocWriter.json().writeAsString((Document)((ConfigVar)entry.getValue()).updatedNow()), XContentType.JSON));
        }
        if (validationErrors.hasErrors()) {
            return CompletableFuture.completedFuture(new StandardResponse(400).error(validationErrors));
        }
        Set idsForDeletion = this.values.keySet().stream().filter(id -> !valueMap.containsKey(id)).collect(Collectors.toSet());
        for (String idForDeletion : idsForDeletion) {
            bulkRequest.add(new DeleteRequest(".searchguard_config_vars").id(idForDeletion));
        }
        if (bulkRequest.numberOfActions() == 0) {
            return CompletableFuture.completedFuture(new StandardResponse(200).message("Nothing to update"));
        }
        final CompletableFuture<StandardResponse> result = new CompletableFuture<StandardResponse>();
        this.privilegedConfigClient.bulk(bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(final BulkResponse bulkResponse) {
                if (bulkResponse.hasFailures()) {
                    result.complete(new StandardResponse(500).error("Bulk update partially failed"));
                } else {
                    ConfigVarRefreshAction.send(ConfigVarService.this.client, new ActionListener<ConfigVarRefreshAction.Response>(){

                        public void onResponse(ConfigVarRefreshAction.Response response) {
                            log.info("Result of settings update:\n" + (Object)((Object)response));
                            if (response.hasFailures()) {
                                result.complete(new StandardResponse(500).error("Index update was successful, but node refresh partially failed"));
                            } else {
                                result.complete(new StandardResponse(200).message(ConfigVarService.this.getUpdateMessage(bulkResponse)));
                            }
                        }

                        public void onFailure(Exception e) {
                            log.error("settings update failed", (Throwable)e);
                            result.complete(new StandardResponse(500).error("Index update was successful, but node refresh failed"));
                        }
                    });
                }
            }

            public void onFailure(Exception e) {
                log.error("Error while updating secrets", (Throwable)e);
                ConfigVarService.this.componentState.addLastException("update", (Throwable)e);
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    private String getUpdateMessage(BulkResponse bulkResponse) {
        int created = 0;
        int updated = 0;
        int deleted = 0;
        int unchanged = 0;
        int notFound = 0;
        block7: for (BulkItemResponse item : bulkResponse.getItems()) {
            DocWriteResponse response = item.getResponse();
            switch (response.getResult()) {
                case CREATED: {
                    ++created;
                    continue block7;
                }
                case DELETED: {
                    ++deleted;
                    continue block7;
                }
                case NOOP: {
                    ++unchanged;
                    continue block7;
                }
                case NOT_FOUND: {
                    ++notFound;
                    continue block7;
                }
                case UPDATED: {
                    ++updated;
                }
            }
        }
        String result = "Update succesful: " + created + " created; " + updated + " updated; " + deleted + " deleted";
        if (unchanged > 0) {
            result = result + "; " + unchanged + " unchanged";
        }
        if (notFound > 0) {
            result = result + "; " + notFound + " not found";
        }
        return result;
    }

    public synchronized void requestRandomKey(String id, int bits, String scope) {
        this.requestedValues.put(id, new RequestedValue(() -> ConfigVarService.generateKey(bits), scope));
    }

    public synchronized void requestValue(String id, Supplier<Object> supplier, String scope) {
        this.requestedValues.put(id, new RequestedValue(supplier, scope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ConfigVar> getAllFromIndex() {
        SearchResponse response = (SearchResponse)this.privilegedConfigClient.search(new SearchRequest(new String[]{this.indexName}).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000)).scroll(new TimeValue(10000L))).actionGet();
        LinkedHashMap<String, ConfigVar> result = new LinkedHashMap<String, ConfigVar>();
        try {
            do {
                for (SearchHit searchHit : response.getHits().getHits()) {
                    try {
                        result.put(searchHit.getId(), new ConfigVar(DocNode.wrap((Object)searchHit.getSourceAsMap())));
                    }
                    catch (Exception e) {
                        log.error("Error while reading " + searchHit, (Throwable)e);
                    }
                }
            } while ((response = (SearchResponse)this.client.prepareSearchScroll(response.getScrollId()).setScroll(new TimeValue(10000L)).execute().actionGet()).getHits().getHits().length != 0);
        }
        finally {
            Actions.clearScrollAsync((Client)this.client, (SearchResponse)response);
        }
        return result;
    }

    public ConfigVar getFromIndex(String id) {
        GetResponse response = (GetResponse)this.privilegedConfigClient.get(new GetRequest(this.indexName, id)).actionGet();
        if (response.isExists()) {
            try {
                return new ConfigVar(DocNode.wrap((Object)response.getSourceAsMap()));
            }
            catch (ConfigValidationException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private synchronized void init(ProtectedConfigIndexService.FailureListener failureListener) {
        HashMap<String, RequestedValue> requestedValues = new HashMap<String, RequestedValue>(this.requestedValues);
        try {
            HashMap<String, Object> existingValues = new HashMap<String, Object>(this.readValues());
            if (log.isDebugEnabled()) {
                log.debug("Read existing values: " + existingValues.keySet());
            }
            if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
                if (requestedValues.isEmpty()) {
                    log.debug("No secrets need to be generated");
                } else {
                    log.info("Creating secrets: " + requestedValues);
                }
                HashMap<String, Object> newValues = new HashMap<String, Object>();
                for (Map.Entry entry : requestedValues.entrySet()) {
                    String id = (String)entry.getKey();
                    try {
                        if (existingValues.containsKey(id)) continue;
                        Object value = ((RequestedValue)entry.getValue()).valueSupplier.get();
                        newValues.put(id, value);
                        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
                        doc.put("encrypted", this.encryptionKeys.getEncryptedData(value));
                        String scope = ((RequestedValue)entry.getValue()).scope;
                        if (scope != null) {
                            doc.put("scope", scope);
                        }
                        doc.put("updated", Instant.now());
                        IndexResponse response = (IndexResponse)this.privilegedConfigClient.index((IndexRequest)new IndexRequest(this.indexName).id(id).source(doc).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
                        this.requestedValues.remove(id);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Written " + id + ": " + response);
                    }
                    catch (Exception e) {
                        throw new Exception("Error while initializing value for " + id, e);
                    }
                }
                if (!newValues.isEmpty()) {
                    existingValues.putAll(newValues);
                    ConfigVarRefreshAction.send(this.client);
                }
            }
            this.values = existingValues;
            this.componentState.setInitialized();
            this.notifyChangeListeners();
            failureListener.onSuccess();
        }
        catch (Exception e) {
            failureListener.onFailure(e);
        }
    }

    public synchronized void addChangeListener(Runnable changeLister) {
        this.changeListeners.add(changeLister);
    }

    private void notifyChangeListeners() {
        for (Runnable changeListener : this.changeListeners) {
            try {
                changeListener.run();
            }
            catch (Exception e) {
                this.componentState.addLastException("notifyChangeListeners", (Throwable)e);
                log.error("Exception in change listener: " + changeListener, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readValues() {
        if (log.isTraceEnabled()) {
            log.trace("SecretsService.readValues()");
        }
        SearchResponse response = (SearchResponse)this.privilegedConfigClient.search(new SearchRequest(new String[]{this.indexName}).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000)).scroll(new TimeValue(10000L))).actionGet();
        HashMap<String, Object> values = new HashMap<String, Object>();
        try {
            do {
                for (SearchHit searchHit : response.getHits().getHits()) {
                    try {
                        Map source = searchHit.getSourceAsMap();
                        if (source.containsKey("value")) {
                            values.put(searchHit.getId(), source.get("value"));
                            continue;
                        }
                        if (source.containsKey("encrypted")) {
                            values.put(searchHit.getId(), this.encryptionKeys.getDecryptedData(source));
                            continue;
                        }
                        throw new Exception("Unexpected doc: " + Strings.toString((ToXContent)searchHit));
                    }
                    catch (Exception e) {
                        this.componentState.getOrCreatePart("entry", searchHit.getId()).setFailed((Throwable)e);
                        log.error("Error while reading " + searchHit, (Throwable)e);
                    }
                }
            } while ((response = (SearchResponse)this.client.prepareSearchScroll(response.getScrollId()).setScroll(new TimeValue(10000L)).execute().actionGet()).getHits().getHits().length != 0);
        }
        finally {
            Actions.clearScrollAsync((Client)this.client, (SearchResponse)response);
        }
        log.debug("Read " + values.size() + " secrets");
        return values;
    }

    public void refresh() {
        log.info("Refreshing config variables");
        this.threadPool.generic().submit(() -> this.refreshSync());
    }

    private synchronized void refreshSync() {
        try {
            this.componentState.setState(ComponentState.State.INITIALIZING, "refreshing");
            Map<String, Object> newValues = this.readValues();
            if (this.values == null || !this.values.equals(newValues)) {
                log.info("Config variables changed");
                this.values = newValues;
                this.componentState.setState(ComponentState.State.INITIALIZED);
                this.notifyChangeListeners();
            } else {
                this.componentState.setState(ComponentState.State.INITIALIZED);
                log.debug("Config variables did not change");
            }
        }
        catch (Exception e) {
            log.error("Error while refreshing. Trying again.", (Throwable)e);
            this.componentState.addLastException("refresh", (Throwable)e);
            this.threadPool.generic().submit(() -> {
                try {
                    Thread.sleep(10000 + new Random().nextInt(10000));
                    this.refreshSync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    private static String generateKey(int bits) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[bits / 8];
        random.nextBytes(bytes);
        return BaseEncoding.base64().encode(bytes);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private static class RequestedValue {
        final Supplier<Object> valueSupplier;
        final String scope;

        RequestedValue(Supplier<Object> valueSupplier, String scope) {
            this.valueSupplier = valueSupplier;
            this.scope = scope;
        }

        public String toString() {
            return "[scope=" + this.scope + "]";
        }
    }
}

