/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.variables;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.configuration.variables.ConfigVar;
import com.floragunn.searchguard.configuration.variables.EncryptionException;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class EncryptionKeys
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(EncryptionKeys.class);
    public static final Setting<?> ENCRYPTION_KEYS_SETTING = Setting.groupSetting((String)"searchguard.config_vars.encryption_keys.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Entry DEFAULT_ENTRY = new Entry("default", "AES/CBC/PKCS5Padding", new SecretKeySpec(BaseEncoding.base64().decode((CharSequence)"v9hGHVFiTgj+eAhjJrDgAEy5GUoTBUwXkAKEpfCL6dQ="), "AES"), false);
    private final Map<String, Entry> entries;
    private final Entry active;
    private final ComponentState componentState = new ComponentState(1000, null, "encryption_keys", EncryptionKeys.class);

    public EncryptionKeys(Settings settings) {
        this.entries = EncryptionKeys.createEntryMap(settings, this.componentState);
        this.active = EncryptionKeys.getActive(this.entries);
        this.componentState.updateStateFromParts();
        this.componentState.setMessage("active: " + this.active.id);
    }

    Map<String, Object> getEncryptedData(Object value) throws EncryptionException {
        byte[] plainBytes = DocWriter.json().writeAsBytes(value);
        try {
            SecureRandom random;
            Entry entry = this.active;
            if (entry == null) {
                throw new EncryptionException("Could not find active encryption key");
            }
            Cipher cipher = Cipher.getInstance(entry.cipher);
            byte[] iv = null;
            if (entry.gcm) {
                random = new SecureRandom();
                iv = new byte[16];
                random.nextBytes(iv);
                cipher.init(1, (Key)entry.secretKeySpec, new GCMParameterSpec(128, iv));
            } else {
                random = new SecureRandom();
                iv = new byte[16];
                random.nextBytes(iv);
                cipher.init(1, (Key)entry.secretKeySpec, new IvParameterSpec(iv));
            }
            byte[] encryptedBytes = cipher.doFinal(plainBytes);
            ImmutableMap immutableMap = ImmutableMap.ofNonNull((Object)"value", (Object)BaseEncoding.base64().encode(encryptedBytes), (Object)"key", (Object)entry.id, (Object)"iv", iv != null ? BaseEncoding.base16().encode(iv) : null);
            return immutableMap;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
        finally {
            Arrays.fill(plainBytes, (byte)0);
        }
    }

    Object getDecryptedData(Map<String, Object> source) throws EncryptionException, DocumentParseException {
        Map encrypted = (Map)source.get("encrypted");
        return this.getDecryptedData((String)encrypted.get("value"), (String)encrypted.get("key"), (String)encrypted.get("iv"));
    }

    Object getDecryptedData(ConfigVar configVar) throws DocumentParseException, EncryptionException {
        return this.getDecryptedData(configVar.getEncValue(), configVar.getEncKey(), configVar.getEncIv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDecryptedData(String value, String key, String iv) throws EncryptionException, DocumentParseException {
        Object object;
        byte[] encryptedBytes = BaseEncoding.base64().decode((CharSequence)value);
        Entry entry = this.entries.get(key);
        if (entry == null) {
            throw new EncryptionException("Unknown encryption key: " + key);
        }
        Cipher cipher = Cipher.getInstance(entry.cipher);
        if (entry.gcm) {
            cipher.init(2, (Key)entry.secretKeySpec, new GCMParameterSpec(128, BaseEncoding.base16().decode((CharSequence)iv)));
        } else {
            cipher.init(2, (Key)entry.secretKeySpec, new IvParameterSpec(BaseEncoding.base16().decode((CharSequence)iv)));
        }
        byte[] plainBytes = cipher.doFinal(encryptedBytes);
        try {
            object = DocReader.json().read(plainBytes);
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(plainBytes, (byte)0);
                throw throwable;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new EncryptionException(e);
            }
        }
        Arrays.fill(plainBytes, (byte)0);
        return object;
    }

    private static Map<String, Entry> createEntryMap(Settings settings, ComponentState componentState) {
        Map groups = settings.getGroups(ENCRYPTION_KEYS_SETTING.getKey());
        HashMap<String, Entry> map = new HashMap<String, Entry>();
        map.put(EncryptionKeys.DEFAULT_ENTRY.id, DEFAULT_ENTRY);
        for (Map.Entry settingsGroup : groups.entrySet()) {
            String id = (String)settingsGroup.getKey();
            try {
                map.put(id, Entry.fromSettings(id, (Settings)settingsGroup.getValue()));
                componentState.getOrCreatePart("encryption_key", id).setInitialized();
            }
            catch (Exception e) {
                componentState.getOrCreatePart("encryption_key", id).setFailed((Throwable)e);
                log.error("Error while creating encryption key " + id, (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static Entry getActive(Map<String, Entry> map) {
        for (Entry entry : map.values()) {
            if (!entry.active) continue;
            return entry;
        }
        return map.get("default");
    }

    public ComponentState getComponentState() {
        return null;
    }

    static class Entry {
        final String id;
        final SecretKeySpec secretKeySpec;
        final String cipher;
        final boolean gcm;
        final boolean active;

        Entry(String id, String cipher, SecretKeySpec secretKeySpec, boolean active) {
            this.id = id;
            this.cipher = cipher;
            this.secretKeySpec = secretKeySpec;
            this.gcm = cipher.contains("/GCM/");
            this.active = active;
        }

        static Entry fromFile(String id, String cipher, File file, boolean active) throws IOException {
            String content = Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).read();
            return new Entry(id, cipher, new SecretKeySpec(BaseEncoding.base64().decode((CharSequence)content), "AES"), active);
        }

        static Entry fromSettings(String id, Settings settings) throws IOException {
            String cipher = settings.get("cipher", "AES/CBC/NoPadding");
            boolean active = settings.getAsBoolean("active", Boolean.valueOf(false));
            if (settings.hasValue("key_file")) {
                return Entry.fromFile(id, cipher, new File(settings.get("file")), active);
            }
            if (settings.hasValue("key")) {
                return new Entry(id, cipher, new SecretKeySpec(BaseEncoding.base64().decode((CharSequence)settings.get("key")), "AES"), active);
            }
            throw new RuntimeException("Encryption key must be specified as key_file or key");
        }
    }
}

