/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.license.LicenseRepository;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchguard.modules.api.GetComponentStateAction;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;

public class SearchGuardLicenseInfoAction
extends Action<StandardRequests.EmptyRequest, Response> {
    public static final SearchGuardLicenseInfoAction INSTANCE = new SearchGuardLicenseInfoAction();
    public static final String NAME = "cluster:admin:searchguard:get_license_info";
    public static final RestApi REST_API = new RestApi().handlesGet("/_searchguard/license/info").with((Action)INSTANCE).name("/_searchguard/license/info");

    protected SearchGuardLicenseInfoAction() {
        super(NAME, StandardRequests.EmptyRequest::new, Response::new);
    }

    public static class Handler
    extends Action.Handler<StandardRequests.EmptyRequest, Response> {
        private final LicenseRepository licenseRepository;
        private final NodeClient nodeClient;

        @Inject
        public Handler(Action.HandlerDependencies handlerDependencies, LicenseRepository licenseRepository, NodeClient nodeClient) {
            super((Action)INSTANCE, handlerDependencies);
            this.licenseRepository = licenseRepository;
            this.nodeClient = nodeClient;
        }

        protected CompletableFuture<Response> doExecute(StandardRequests.EmptyRequest request) {
            final CompletableFuture<Response> result = new CompletableFuture<Response>();
            final SearchGuardLicense license = this.licenseRepository.getLicense();
            this.nodeClient.execute((ActionType)GetComponentStateAction.INSTANCE, (ActionRequest)new GetComponentStateAction.Request(null, true), (ActionListener)new ActionListener<GetComponentStateAction.Response>(){

                public void onResponse(GetComponentStateAction.Response response) {
                    result.complete(new Response(license, response.getComponentsGroupedByLicense()));
                }

                public void onFailure(Exception e) {
                    result.completeExceptionally(e);
                }
            });
            return result;
        }
    }

    public static class Response
    extends Action.Response {
        private SearchGuardLicense license;
        private Map<String, Set<String>> licensesRequired;

        public Response(SearchGuardLicense license, Map<String, Set<String>> licensesRequired) {
            this.license = license;
            this.licensesRequired = licensesRequired;
        }

        public Response(Action.UnparsedMessage message) throws ConfigValidationException {
            super(message);
            DocNode docNode = message.requiredDocNode();
            this.license = new SearchGuardLicense((Map<String, Object>)docNode.getAsNode("license"));
            this.licensesRequired = this.toMultiMap((Map<String, Object>)docNode.getAsNode("licenses_required").toMap());
        }

        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("license", this.license.toBasicObject());
            result.put("licenses_required", this.licensesRequired);
            return result;
        }

        private Map<String, Set<String>> toMultiMap(Map<String, Object> map) {
            LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    result.put(entry.getKey(), ((Collection)entry.getValue()).stream().map(e -> String.valueOf(e)).collect(Collectors.toSet()));
                    continue;
                }
                result.put(entry.getKey(), (Set<String>)ImmutableSet.of((Object)String.valueOf(entry.getValue())));
            }
            return result;
        }
    }
}

