/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges.extended_action_handling;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.indices.IndexCleanupAgent;
import com.google.common.base.Objects;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;

public class ResourceOwnerService
implements ComponentStateProvider,
ProtectedConfigIndexService.IndexReadyListener {
    public static final Setting<Integer> MAX_CHECK_RETRIES = Setting.intSetting((String)"searchguard.resource_owner_handling.retry_owner_check.max", (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Integer> CHECK_RETRY_DELAY = Setting.intSetting((String)"searchguard.resource_owner_handling.retry_owner_check.delay_ms", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<TimeValue> CLEANUP_INTERVAL = Setting.timeSetting((String)"searchguard.resource_owner_handling.cleanup_interval", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<TimeValue> DEFAULT_RESOURCE_LIFETIME = Setting.timeSetting((String)"searchguard.resource_owner_handling.resource.default_lifetime", (TimeValue)TimeValue.timeValueDays((long)7L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<String> REFRESH_POLICY = Setting.simpleString((String)"searchguard.resource_owner_handling.index.refresh_on_write", (String)WriteRequest.RefreshPolicy.IMMEDIATE.getValue(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final List<Setting<?>> SUPPORTED_SETTINGS = Arrays.asList(MAX_CHECK_RETRIES, CHECK_RETRY_DELAY, CLEANUP_INTERVAL, DEFAULT_RESOURCE_LIFETIME, REFRESH_POLICY);
    private static final Logger log = LogManager.getLogger(ResourceOwnerService.class);
    private final String index = ".searchguard_resource_owner";
    private final PrivilegedConfigClient privilegedConfigClient;
    private IndexCleanupAgent indexCleanupAgent;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final int maxCheckRetries;
    private final long checkRetryDelay;
    private final TimeValue defaultResourceLifetime;
    private final WriteRequest.RefreshPolicy refreshPolicy;
    private final ComponentState componentState = new ComponentState(100, null, "resource_owner_service");
    private final AtomicBoolean indexReady = new AtomicBoolean();

    public ResourceOwnerService(Client client, ClusterService clusterService, ThreadPool threadPool, ProtectedConfigIndexService protectedConfigIndexService, PrivilegesEvaluator privilegesEvaluator, Settings settings) {
        this.privilegedConfigClient = PrivilegedConfigClient.adapt(client);
        this.maxCheckRetries = (Integer)MAX_CHECK_RETRIES.get(settings);
        this.checkRetryDelay = ((Integer)CHECK_RETRY_DELAY.get(settings)).intValue();
        this.defaultResourceLifetime = (TimeValue)DEFAULT_RESOURCE_LIFETIME.get(settings);
        this.refreshPolicy = WriteRequest.RefreshPolicy.parse((String)((String)REFRESH_POLICY.get(settings)));
        this.privilegesEvaluator = privilegesEvaluator;
        ProtectedConfigIndexService.ConfigIndex configIndex = new ProtectedConfigIndexService.ConfigIndex(".searchguard_resource_owner").onIndexReady(this);
        this.componentState.addPart(protectedConfigIndexService.createIndex(configIndex));
        this.indexCleanupAgent = new IndexCleanupAgent(".searchguard_resource_owner", (TimeValue)CLEANUP_INTERVAL.get(settings), (Client)this.privilegedConfigClient, clusterService, threadPool);
        this.componentState.addPart(this.indexCleanupAgent.getComponentState());
    }

    public void storeOwner(String resourceType, Object id, User owner, long expires, ActionListener<IndexResponse> actionListener) {
        if (!this.indexReady.get()) {
            actionListener.onFailure(new Exception("Index .searchguard_resource_owner not ready"));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("storeOwner(" + resourceType + ", " + id + ", " + owner + ", " + expires + ")");
        }
        String docId = resourceType + "_" + id;
        ((IndexRequestBuilder)((IndexRequestBuilder)this.privilegedConfigClient.prepareIndex().setIndex(".searchguard_resource_owner")).setId(docId).setSource(new Object[]{"user_name", owner.getName(), "expires", expires}).setRefreshPolicy(this.refreshPolicy)).execute(actionListener);
    }

    public void deleteOwner(String resourceType, Object id) {
        final String docId = resourceType + "_" + id;
        ((DeleteRequestBuilder)this.privilegedConfigClient.prepareDelete().setIndex(".searchguard_resource_owner")).setId(docId).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (log.isTraceEnabled()) {
                    log.trace("Resource owner document deleted: " + docId + "; " + response);
                }
            }

            public void onFailure(Exception e) {
                log.error("Error while deleting resource owner document " + docId, (Throwable)e);
            }
        });
    }

    public void checkOwner(String resourceType, Object id, User currentUser, ActionListener<CheckOwnerResponse> actionListener) {
        this.checkOwner(resourceType, id, currentUser, actionListener, 0);
    }

    private void checkOwner(final String resourceType, final Object id, final User currentUser, final ActionListener<CheckOwnerResponse> actionListener, final int retry) {
        String docId = resourceType + "_" + id;
        ((GetRequestBuilder)this.privilegedConfigClient.prepareGet().setIndex(".searchguard_resource_owner")).setId(docId).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (response.isExists()) {
                    Object storedUserName = response.getSourceAsMap().get("user_name");
                    if (log.isTraceEnabled()) {
                        log.trace("checkOwner for " + resourceType + ":" + id + ": " + storedUserName + " - " + currentUser);
                    }
                    if (ResourceOwnerService.this.isUserEqual(currentUser, storedUserName)) {
                        actionListener.onResponse((Object)new CheckOwnerResponse(response));
                    } else {
                        actionListener.onFailure((Exception)new ElasticsearchSecurityException("Resource " + resourceType + ":" + id + " is not owned by user " + currentUser.getName(), RestStatus.FORBIDDEN, new Object[0]));
                    }
                } else if (retry < ResourceOwnerService.this.maxCheckRetries) {
                    if (log.isDebugEnabled()) {
                        log.debug("Retrying checkOwner(" + resourceType + ":" + id + ")");
                    }
                    if (ResourceOwnerService.this.checkRetryDelay > 0L) {
                        try {
                            Thread.sleep(ResourceOwnerService.this.checkRetryDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ResourceOwnerService.this.checkOwner(resourceType, id, currentUser, (ActionListener<CheckOwnerResponse>)actionListener, retry + 1);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("checkOwner for " + resourceType + ":" + id + " failed: " + response);
                    }
                    actionListener.onFailure((Exception)new ElasticsearchSecurityException("Owner information of " + resourceType + ":" + id + " could not be found", RestStatus.NOT_FOUND, new Object[0]));
                }
            }

            public void onFailure(Exception e) {
                if (retry < ResourceOwnerService.this.maxCheckRetries) {
                    if (log.isDebugEnabled()) {
                        log.debug("Retrying checkOwner(" + resourceType + ":" + id + ") after " + e, (Throwable)e);
                    }
                    if (ResourceOwnerService.this.checkRetryDelay > 0L) {
                        try {
                            Thread.sleep(ResourceOwnerService.this.checkRetryDelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ResourceOwnerService.this.checkOwner(resourceType, id, currentUser, (ActionListener<CheckOwnerResponse>)actionListener, retry + 1);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn("checkOwner for " + resourceType + ":" + id + " failed: ", (Throwable)e);
                    }
                    actionListener.onFailure((Exception)new ElasticsearchException("Checking owner of " + resourceType + ":" + id + " failed", (Throwable)e, new Object[0]));
                }
            }
        });
    }

    public <Request extends ActionRequest, Response extends ActionResponse> ActionFilterChain<Request, Response> applyOwnerCheckPreAction(Action.WellKnownAction<Request, ?, ?> actionConfig, PrivilegesEvaluationContext context, Request actionRequest, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        ActionFilterChain<Request, Response> extendedChain = chain;
        for (Action.WellKnownAction.Resource usesResource : actionConfig.getResources().getUsesResources()) {
            if (usesResource.getOwnerCheckBypassPermission() != null) {
                try {
                    if (this.privilegesEvaluator.hasClusterPermissions(usesResource.getOwnerCheckBypassPermission(), context)) {
                        continue;
                    }
                }
                catch (PrivilegesEvaluationException e) {
                    log.error("Error while evaluating owner check bypass permission of " + usesResource, (Throwable)e);
                }
            }
            Object resourceId = usesResource.getId().apply(actionRequest);
            extendedChain = new OwnerCheckPreAction<Request, Response>(usesResource, resourceId, context.getUser(), extendedChain);
        }
        return extendedChain;
    }

    public <R extends ActionResponse> ActionListener<R> applyCreatePostAction(final Action.WellKnownAction<?, ?, ?> actionConfig, final User currentUser, final ActionListener<R> actionListener) {
        return new ActionListener<R>(){

            public void onResponse(final R actionResponse) {
                final Action.WellKnownAction.NewResource newResource = actionConfig.getResources().getCreatesResource();
                final Object id = newResource.getId().apply((ActionResponse)actionResponse);
                if (log.isTraceEnabled()) {
                    log.trace("Id for new resource " + newResource + ": " + id);
                }
                if (id != null) {
                    Instant expiresInstant;
                    long expiresMillis = System.currentTimeMillis() + ResourceOwnerService.this.defaultResourceLifetime.millis();
                    if (newResource.getExpiresAfter() != null && (expiresInstant = newResource.getExpiresAfter().apply((ActionResponse)actionResponse)) != null) {
                        expiresMillis = expiresInstant.toEpochMilli();
                    }
                    ResourceOwnerService.this.storeOwner(newResource.getType(), id, currentUser, expiresMillis, new ActionListener<IndexResponse>(){

                        public void onResponse(IndexResponse indexResponse) {
                            actionListener.onResponse((Object)actionResponse);
                        }

                        public void onFailure(Exception e) {
                            actionListener.onFailure((Exception)new ElasticsearchException("Failed to store owner of " + newResource.getType() + ":" + id, (Throwable)e, new Object[0]));
                        }
                    });
                } else {
                    actionListener.onResponse(actionResponse);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        };
    }

    public <Request extends ActionRequest, R extends ActionResponse> ActionListener<R> applyDeletePostAction(Action.WellKnownAction<?, ?, ?> actionConfig, final Action.WellKnownAction.Resource resource, User currentUser, final Request actionRequest, final ActionListener<R> actionListener) {
        return new ActionListener<R>(){

            public void onResponse(R actionResponse) {
                Object id = resource.getId().apply(actionRequest);
                if (id != null) {
                    ResourceOwnerService.this.deleteOwner(resource.getType(), id);
                }
                actionListener.onResponse(actionResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        };
    }

    private boolean isUserEqual(User currentUser, Object storedUserName) {
        return Objects.equal((Object)currentUser.getName(), (Object)storedUserName);
    }

    public void shutdown() {
        this.indexCleanupAgent.shutdown();
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    @Override
    public void onIndexReady(ProtectedConfigIndexService.FailureListener failureListener) {
        this.indexReady.set(true);
        failureListener.onSuccess();
        this.componentState.updateStateFromParts();
    }

    class OwnerCheckPreAction<Request extends ActionRequest, Response extends ActionResponse>
    extends PreAction<Request, Response> {
        private final Action.WellKnownAction.Resource resource;
        private final Object resourceId;
        private final User currentUser;

        OwnerCheckPreAction(Action.WellKnownAction.Resource resource, Object resourceId, User currentUser, ActionFilterChain<Request, Response> next) {
            super(next);
            this.currentUser = currentUser;
            this.resource = resource;
            this.resourceId = resourceId;
        }

        public void proceed(final Task task, final String action, final Request request, final ActionListener<Response> listener) {
            ResourceOwnerService.this.checkOwner(this.resource.getType(), this.resourceId, this.currentUser, new ActionListener<CheckOwnerResponse>(){

                public void onResponse(CheckOwnerResponse response) {
                    OwnerCheckPreAction.this.next.proceed(task, action, request, listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    abstract class PreAction<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        protected final ActionFilterChain<Request, Response> next;

        PreAction(ActionFilterChain<Request, Response> next) {
            this.next = next;
        }
    }

    static class CheckOwnerResponse {
        private GetResponse getResponse;

        CheckOwnerResponse(GetResponse getResponse) {
            this.getResponse = getResponse;
        }

        public GetResponse getGetResponse() {
            return this.getResponse;
        }
    }
}

