/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;

public class ReflectionHelper {
    protected static final Logger log = LogManager.getLogger(ReflectionHelper.class);
    private static boolean enterpriseModulesEnabled;

    private static boolean enterpriseModulesDisabled() {
        return !enterpriseModulesEnabled;
    }

    public static void registerMngtRestApiHandler(Settings settings) {
        block4: {
            if (ReflectionHelper.enterpriseModulesDisabled()) {
                return;
            }
            if (!settings.getAsBoolean("http.enabled", Boolean.valueOf(true)).booleanValue()) {
                try {
                    Class.forName("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions");
                }
                catch (Throwable e) {
                    log.warn("Unable to register Rest Management Api Module due to {}", (Object)e.toString());
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Stacktrace: ", e);
                }
            }
        }
    }

    public static Collection<RestHandler> instantiateMngtRestApiHandler(Settings settings, Path configPath, RestController restController, Client localClient, AdminDNs adminDns, ConfigurationRepository cr, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditlog) {
        if (ReflectionHelper.enterpriseModulesDisabled()) {
            return Collections.emptyList();
        }
        return ReflectionHelper.instantiateRestApiHandler("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions", settings, configPath, restController, localClient, adminDns, cr, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditlog);
    }

    public static Collection<RestHandler> instantiateRestApiHandler(String className, Settings settings, Path configPath, RestController restController, Client localClient, AdminDNs adminDns, ConfigurationRepository cr, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditlog) {
        try {
            Collection result;
            Class<?> clazz = Class.forName(className);
            try {
                result = (Collection)clazz.getDeclaredMethod("getHandler", Settings.class, Path.class, RestController.class, Client.class, AdminDNs.class, ConfigurationRepository.class, StaticSgConfig.class, ClusterService.class, PrincipalExtractor.class, AuthorizationService.class, SpecialPrivilegesEvaluationContextProviderRegistry.class, ThreadPool.class, AuditLog.class).invoke(null, settings, configPath, restController, localClient, adminDns, cr, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditlog);
            }
            catch (NoSuchMethodException e) {
                try {
                    result = (Collection)clazz.getDeclaredMethod("getHandler", Settings.class, Path.class, RestController.class, Client.class, AdminDNs.class, ConfigurationRepository.class, StaticSgConfig.class, ClusterService.class, PrincipalExtractor.class, AuthorizationService.class, ThreadPool.class, AuditLog.class).invoke(null, settings, configPath, restController, localClient, adminDns, cr, staticSgConfig, cs, principalExtractor, authorizationService, threadPool, auditlog);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        result = (Collection)clazz.getDeclaredMethod("getHandler", Settings.class, Path.class, RestController.class, Client.class, AdminDNs.class, ConfigurationRepository.class, ClusterService.class, PrincipalExtractor.class, AuthorizationService.class, ThreadPool.class, AuditLog.class).invoke(null, settings, configPath, restController, localClient, adminDns, cr, cs, principalExtractor, authorizationService, threadPool, auditlog);
                    }
                    catch (NoSuchMethodException e2) {
                        result = (Collection)clazz.getDeclaredMethod("getHandler", Settings.class, Path.class, RestController.class, Client.class, ClusterService.class, ThreadPool.class).invoke(null, settings, configPath, restController, localClient, cs, threadPool);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + result.size() + " REST API handlers in " + className);
            }
            return result;
        }
        catch (Throwable e) {
            log.warn("Unable to enable REST API module {} due to {}", (Object)className, (Object)(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().toString() : e.toString()));
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return Collections.emptyList();
        }
    }

    public static InterClusterRequestEvaluator instantiateInterClusterRequestEvaluator(String clazz, Settings settings) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            InterClusterRequestEvaluator ret = (InterClusterRequestEvaluator)clazz0.getConstructor(Settings.class).newInstance(settings);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load inter cluster request evaluator '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultInterClusterRequestEvaluator(settings);
        }
    }

    public static PrincipalExtractor instantiatePrincipalExtractor(String clazz) {
        try {
            Class<?> clazz0 = Class.forName(clazz);
            PrincipalExtractor ret = (PrincipalExtractor)clazz0.getConstructor(new Class[0]).newInstance(new Object[0]);
            return ret;
        }
        catch (Throwable e) {
            log.warn("Unable to load pricipal extractor '{}' due to {}", (Object)clazz, (Object)e.toString());
            if (log.isDebugEnabled()) {
                log.debug("Stacktrace: ", e);
            }
            return new DefaultPrincipalExtractor();
        }
    }

    public static void init(boolean enterpriseModulesEnabled) {
        ReflectionHelper.enterpriseModulesEnabled = enterpriseModulesEnabled;
    }
}

