/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.base.UserMapping;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class UserMappingTest {
    @Test
    public void userName_from() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.from", (Object)"oidc_id_token.sub"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
        Assert.assertEquals((Object)"sub_value", (Object)mappedCredentials.getUsername());
    }

    @Test
    public void userName_invalidPath() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.from", (Object)"oidc_id_token.suf"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        try {
            AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
            Assert.fail((String)("Mapping succeeded even though it should have failed: " + mappedCredentials));
        }
        catch (CredentialsException e) {
            Assert.assertEquals((Object)"No user name found", (Object)e.getMessage());
        }
    }

    @Test
    public void userName_static() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.static", (Object)"static_value"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
        Assert.assertEquals((Object)"static_value", (Object)mappedCredentials.getUsername());
    }

    @Test
    public void userName_fromBackend() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.from_backend", (Object)"ldap_user_entry.nick_name"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
        Assert.assertEquals((Object)"n/a", (Object)mappedCredentials.getUsername());
        AuthCredentials backendCredentials = mappedCredentials.userMappingAttribute("ldap_user_entry", (Object)ImmutableMap.of((Object)"nick_name", Arrays.asList("cave")));
        User user = userMapping.map(backendCredentials);
        Assert.assertEquals((Object)"cave", (Object)user.getName());
    }

    @Test
    public void userName_fromBackend_multiValue_fail() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.from_backend", (Object)"ldap_user_entry.nick_name"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
        Assert.assertEquals((Object)"n/a", (Object)mappedCredentials.getUsername());
        AuthCredentials backendCredentials = mappedCredentials.userMappingAttribute("ldap_user_entry", (Object)ImmutableMap.of((Object)"nick_name", Arrays.asList("cave", "man")));
        try {
            User user = userMapping.map(backendCredentials);
            Assert.fail((String)("Mapping succeeded even though it should have failed: " + user));
        }
        catch (CredentialsException e) {
            Assert.assertEquals((Object)"More than one candidate for the user name was found", (Object)e.getMessage());
        }
    }

    @Test
    public void userName_fromBackend_multiValue() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"user_name.from_backend", (Object)"ldap_user_entry.nick_name[0]"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("oidc_id_token", (Object)ImmutableMap.of((Object)"sub", (Object)"sub_value", (Object)"foo", (Object)"foo_value")).build();
        AuthCredentials mappedCredentials = userMapping.mapCredentials(baseCredentials);
        Assert.assertEquals((Object)"n/a", (Object)mappedCredentials.getUsername());
        AuthCredentials backendCredentials = mappedCredentials.userMappingAttribute("ldap_user_entry", (Object)ImmutableMap.of((Object)"nick_name", Arrays.asList("cave", "man")));
        User user = userMapping.map(backendCredentials);
        Assert.assertEquals((Object)"cave", (Object)user.getName());
    }

    @Test
    public void roles_from_combiled_with_static() throws Exception {
        UserMapping userMapping = UserMapping.parse((DocNode)DocNode.of((String)"roles.from", (Object)"ldap_user_entry.roles", (String)"roles.static", (Object)"static_role"), null);
        AuthCredentials baseCredentials = AuthCredentials.forUser((String)"n/a").userMappingAttribute("ldap_user_entry", (Object)ImmutableMap.of((Object)"roles", Arrays.asList("a", "b", "c"))).build();
        User user = userMapping.map(baseCredentials);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object[])new String[]{"b", "c", "static_role"}), (Object)user.getRoles());
    }
}

