/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.RestMatchers;
import com.floragunn.searchguard.test.TestAlias;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import org.apache.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IgnoreUnauthorizedCcsWithDisabledSkipUnavailableRemoteClusterIntTest {
    private static TestCertificates certificatesContext = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard").addNodes("CN=node-0.example.com,OU=SearchGuard,O=SearchGuard").addClients("CN=client-0.example.com,OU=SearchGuard,O=SearchGuard").addAdminClients("CN=admin-0.example.com,OU=SearchGuard,O=SearchGuard").build();
    static TestSgConfig.User LIMITED_USER_COORD_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("a*"));
    static TestSgConfig.User LIMITED_USER_REMOTE_A = new TestSgConfig.User("limited_user_A").roles(new TestSgConfig.Role("limited_user_a_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards", "indices:admin/resolve/cluster").on("a*"));
    static TestSgConfig.User LIMITED_USER_COORD_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD").on("b*"));
    static TestSgConfig.User LIMITED_USER_REMOTE_B = new TestSgConfig.User("limited_user_B").roles(new TestSgConfig.Role("limited_user_b_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards").on("b*"));
    static TestSgConfig.User UNLIMITED_USER = new TestSgConfig.User("unlimited_user").roles(new TestSgConfig.Role("unlimited_user_role").clusterPermissions("SGS_CLUSTER_COMPOSITE_OPS_RO").indexPermissions("SGS_CRUD", "indices:admin/search/search_shards", "indices:admin/shards/search_shards", "indices:admin/resolve/cluster").on("*"));
    static TestIndex index_coord_a1 = TestIndex.name("a1").documentCount(100).seed(1).attr("prefix", "a").attr("cluster", "local").build();
    static TestIndex index_coord_a2 = TestIndex.name("a2").documentCount(110).seed(2).attr("prefix", "a").attr("cluster", "local").build();
    static TestIndex index_remote_a1 = TestIndex.name("a1").documentCount(120).seed(11).attr("prefix", "a").attr("cluster", "remote").build();
    static TestIndex index_remote_a2 = TestIndex.name("a2").documentCount(130).seed(12).attr("prefix", "a").attr("cluster", "remote").build();
    static TestIndex index_coord_b1 = TestIndex.name("b1").documentCount(51).seed(4).attr("prefix", "b").attr("cluster", "local").build();
    static TestIndex index_coord_b2 = TestIndex.name("b2").documentCount(52).seed(5).attr("prefix", "b").attr("cluster", "local").build();
    static TestIndex index_remote_b1 = TestIndex.name("b1").documentCount(53).seed(14).attr("prefix", "b").attr("cluster", "remote").build();
    static TestIndex index_remote_b2 = TestIndex.name("b2").documentCount(54).seed(15).attr("prefix", "b").attr("cluster", "remote").build();
    static TestIndex index_coord_c1 = TestIndex.name("c1").documentCount(5).seed(7).attr("prefix", "c").attr("cluster", "local").build();
    static TestIndex index_remote_r1 = TestIndex.name("r1").documentCount(5).seed(8).attr("prefix", "r").attr("cluster", "remote").build();
    static TestAlias xalias_coord_ab1 = new TestAlias("xalias_ab1", index_coord_a1, index_coord_a2, index_coord_b1);
    static TestAlias xalias_remote_ab1 = new TestAlias("xalias_ab1", index_remote_a1, index_remote_a2, index_remote_b1);
    @ClassRule
    public static LocalCluster anotherCluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).nodeSettings("searchguard.diagnosis.action_stack.enabled", true).users(LIMITED_USER_REMOTE_A, LIMITED_USER_REMOTE_B, UNLIMITED_USER).indices(index_remote_a1, index_remote_a2, index_remote_b1, index_remote_b2, index_remote_r1).aliases(xalias_remote_ab1).build();
    @Parameterized.Parameter
    public static String ccsMinimizeRoundtrips;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{"ccs_minimize_roundtrips=false", "ccs_minimize_roundtrips=true"};
    }

    @Test
    public void search_clusterWildcard() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "*:/_search?size=1000&" + ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isNotFound());
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_staticIndices() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:b1/_search?size=1000&" + ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]._index", Matchers.containsInAnyOrder((Object[])new String[]{"my_remote:b1"}))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void search_remoteAlias() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:xalias_ab1/_search?size=1000&" + ccsMinimizeRoundtrips;
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1, index_remote_a2, index_remote_b1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.get(query, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isForbidden());
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    @Test
    public void msearch_staticIndicesInURL() throws Exception {
        GenericRestClient.HttpResponse httpResponse;
        String query = "my_remote:a1/_msearch?" + ccsMinimizeRoundtrips;
        String msearchBody = "{}\n{\"size\":1000, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}\n";
        try (GenericRestClient restClient = cluster.getRestClient(UNLIMITED_USER, new Header[0]);){
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1))}));
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_A, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].hits.hits[*]", RestMatchers.matches("my_remote", index_remote_a1))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
        restClient = cluster.getRestClient(LIMITED_USER_COORD_B, new Header[0]);
        try {
            httpResponse = restClient.postJson(query, msearchBody, new Header[0]);
            Assert.assertThat((Object)httpResponse, RestMatchers.isOk());
            Assert.assertThat((Object)httpResponse, RestMatchers.json(new BaseMatcher[]{RestMatchers.distinctNodesAt("responses[*].error.type", Matchers.containsInAnyOrder((Object[])new String[]{"security_exception"}))}));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }

    static {
        cluster = new LocalCluster.Builder().singleNode().sslEnabled(certificatesContext).remote("my_remote", anotherCluster).nodeSettings("searchguard.diagnosis.action_stack.enabled", true).nodeSettings("cluster.remote.my_remote.skip_unavailable", false).users(LIMITED_USER_COORD_A, LIMITED_USER_COORD_B, UNLIMITED_USER).indices(index_coord_a1, index_coord_a2, index_coord_b1, index_coord_b2, index_coord_c1).aliases(xalias_coord_ab1).embedded().build();
    }
}

