/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.actions;

import com.floragunn.searchguard.authz.SystemIndexAccess;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.authz.actions.ResolvedIndicesMatcher;
import com.floragunn.searchsupport.meta.Meta;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;
import org.junit.Test;

public class ActionRequestIntrospectorTest {
    static final Actions ACTIONS = new Actions(null);
    static final Meta META = Meta.Mock.indices((String[])new String[]{"index_a11", "index_a12", "index_a21", "index_a22", "index_b1", "index_b2"}).dataStream("ds_d11").of(new String[]{".ds-ds_d11-2024.03.22-000001", ".ds-ds_d11-2024.03.22-000002"}).alias("alias_a").of(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"}).alias("alias_a1").of(new String[]{"index_a11", "index_a12"}).alias("alias_a2").of(new String[]{"index_a21", "index_a22"}).alias("alias_b").of(new String[]{"index_b1", "index_b2"});

    @Test
    public void getAliasesRequest() {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{"alias_a1", "alias_a2"}).indices(new String[]{"index_a11", "index_a12", "index_a21", "index_a22"});
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases/get"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasIndices("index_a11", "index_a12", "index_a21", "index_a22").hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.ALIASES).hasNoIndices().hasAliases("alias_a1", "alias_a2").hasNoDataStreams()));
    }

    @Test
    public void getAliasesRequest_aliasPattern_noWildcards() {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{"alias_a*"}).indices(new String[]{"index_a1*"}).indicesOptions(IndicesOptions.strictSingleIndexNoExpandForbidClosed());
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases/get"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasNoIndices().hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.ALIASES).hasNoIndices().hasAliases("alias_a", "alias_a1", "alias_a2").hasNoDataStreams()));
    }

    @Test
    public void indicesAliasesRequest_add_nonExistingAlias() {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias_ax").index("index_a11"));
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasIndices("index_a11").hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.ALIASES).hasNoIndices().hasAliases("alias_ax").hasNoDataStreams()));
    }

    @Test
    public void indicesAliasesRequest_add_aliasPattern() {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias_a*").index("index_a11"));
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasIndices("index_a11").hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.ALIASES).hasNoIndices().hasNoAliases().hasNoDataStreams()));
    }

    @Test
    public void indicesAliasesRequest_remove_aliasPattern() {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().alias("alias_a*").index("index_a11"));
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasIndices("index_a11").hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.ALIASES).hasNoIndices().hasAliases("alias_a", "alias_a1", "alias_a2").hasNoDataStreams()));
    }

    @Test
    public void indicesAliasesRequest_removeIndex_indexPatternSimple() {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index("index_a1*"));
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasNoIndices().hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.DELETE_INDEX).hasIndices("index_a11", "index_a12").hasNoAliases().hasNoDataStreams()));
    }

    @Test
    public void indicesAliasesRequest_removeIndex_indexPatternMulti() {
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index("index_a1*")).addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().indices(new String[]{"index_a11", "-index_a1*"}));
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:admin/aliases"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, ActionRequestIntrospectorTest.resolved(ActionRequestIntrospectorTest.main().hasNoIndices().hasNoAliases().hasNoDataStreams(), ActionRequestIntrospectorTest.additional(Action.AdditionalDimension.DELETE_INDEX).hasIndices("index_a11", "index_a12").hasNoAliases().hasNoDataStreams()));
    }

    @Test
    public void bulkShardRequest_create_datastream() {
        BulkShardRequest request = new BulkShardRequest(null, WriteRequest.RefreshPolicy.NONE, new BulkItemRequest[]{new BulkItemRequest(1, (DocWriteRequest)new IndexRequest("ds_d11"))});
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:data/write/bulk[s]"), (Object)request);
        MatcherAssert.assertThat((Object)requestInfo, (Matcher)ActionRequestIntrospectorTest.main().hasNoIndices().hasNoAliases().hasDataStreams("ds_d11"));
    }

    @Test
    public void unknownIndexRequest_noIndexInformation() {
        ActionRequest request = new ActionRequest(){

            public ActionRequestValidationException validate() {
                return null;
            }
        };
        ActionRequestIntrospector.ActionRequestInfo requestInfo = ActionRequestIntrospectorTest.simple().getActionRequestInfo(ACTIONS.get("indices:unknown"), (Object)request);
        Assert.assertTrue((String)requestInfo.toString(), (boolean)requestInfo.isUnknown());
        Assert.assertTrue((String)requestInfo.toString(), (boolean)requestInfo.getMainResolvedIndices().isLocalAll());
        Assert.assertEquals((Object)META.indexLikeObjects().keySet(), (Object)requestInfo.getMainResolvedIndices().getLocal().getDeepUnion());
    }

    static ActionRequestIntrospector simple() {
        return new ActionRequestIntrospector(() -> META, () -> SystemIndexAccess.DISALLOWED, () -> false, null);
    }

    static DiagnosingMatcher<ActionRequestIntrospector.ActionRequestInfo> resolved(final ActionRequestInfoResolvedIndicesMatcher ... matchers) {
        return new DiagnosingMatcher<ActionRequestIntrospector.ActionRequestInfo>(){

            public void describeTo(Description description) {
                description.appendText("An ActionRequestInfo object where:\n");
                for (ActionRequestInfoResolvedIndicesMatcher matcher : matchers) {
                    description.appendDescriptionOf((SelfDescribing)matcher);
                    description.appendText("\n");
                }
            }

            protected boolean matches(Object item, Description mismatchDescription) {
                boolean result = true;
                for (ActionRequestInfoResolvedIndicesMatcher matcher : matchers) {
                    if (matcher.matches(item, mismatchDescription)) continue;
                    mismatchDescription.appendText("\n");
                    result = false;
                }
                return result;
            }
        };
    }

    static ActionRequestInfoResolvedIndicesMatcher main() {
        return new ActionRequestInfoResolvedIndicesMatcher(null, null, null, null);
    }

    static ActionRequestInfoResolvedIndicesMatcher additional(Action.AdditionalDimension role) {
        return new ActionRequestInfoResolvedIndicesMatcher(role, null, null, null);
    }

    static class ActionRequestInfoResolvedIndicesMatcher
    extends DiagnosingMatcher<ActionRequestIntrospector.ActionRequestInfo> {
        private final Action.AdditionalDimension role;
        private final ResolvedIndicesMatcher.IndicesMatcher indicesMatcher;
        private final ResolvedIndicesMatcher.AliasesMatcher aliasesMatcher;
        private final ResolvedIndicesMatcher.DataStreamsMatcher dataStreamsMatcher;

        ActionRequestInfoResolvedIndicesMatcher(Action.AdditionalDimension role, ResolvedIndicesMatcher.IndicesMatcher indicesMatcher, ResolvedIndicesMatcher.AliasesMatcher aliasesMatcher, ResolvedIndicesMatcher.DataStreamsMatcher dataStreamsMatcher) {
            this.role = role;
            this.indicesMatcher = indicesMatcher;
            this.aliasesMatcher = aliasesMatcher;
            this.dataStreamsMatcher = dataStreamsMatcher;
        }

        public void describeTo(Description description) {
            if (this.role == null) {
                description.appendText("main resolved indices where: ");
            } else {
                description.appendText("additional resolved indices of role " + this.role + " where: ");
            }
            if (this.indicesMatcher != null) {
                description.appendDescriptionOf((SelfDescribing)this.indicesMatcher).appendText("; ");
            }
            if (this.aliasesMatcher != null) {
                description.appendDescriptionOf((SelfDescribing)this.aliasesMatcher).appendText("; ");
            }
            if (this.dataStreamsMatcher != null) {
                description.appendDescriptionOf((SelfDescribing)this.dataStreamsMatcher).appendText("; ");
            }
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            ResolvedIndices resolvedIndices;
            if (!(item instanceof ActionRequestIntrospector.ActionRequestInfo)) {
                mismatchDescription.appendValue(item).appendText(" is not an ActionRequestInfo object");
                return false;
            }
            ActionRequestIntrospector.ActionRequestInfo actionRequestInfo = (ActionRequestIntrospector.ActionRequestInfo)item;
            ResolvedIndices resolvedIndices2 = resolvedIndices = this.role == null ? actionRequestInfo.getMainResolvedIndices() : (ResolvedIndices)actionRequestInfo.getAdditionalResolvedIndices().get((Object)this.role);
            if (resolvedIndices == null) {
                if (this.role == null) {
                    mismatchDescription.appendText("main resolved indices are missing.");
                } else {
                    mismatchDescription.appendText("additional resolved indices with role " + this.role + " are missing. Available roles: ").appendValue((Object)actionRequestInfo.getAdditionalResolvedIndices().keySet());
                }
                return false;
            }
            boolean match = true;
            if (this.indicesMatcher != null) {
                match &= this.indicesMatcher.matches(resolvedIndices, mismatchDescription);
            }
            if (this.aliasesMatcher != null) {
                match &= this.aliasesMatcher.matches(resolvedIndices, mismatchDescription);
            }
            if (this.dataStreamsMatcher != null) {
                match &= this.dataStreamsMatcher.matches(resolvedIndices, mismatchDescription);
            }
            if (!match) {
                mismatchDescription.appendText("\n").appendText(this.role == null ? "main" : this.role.toString()).appendText(": ").appendValue((Object)resolvedIndices);
            }
            return match;
        }

        public ActionRequestInfoResolvedIndicesMatcher hasIndices(String ... expected) {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, new ResolvedIndicesMatcher.IndicesMatcher(expected), this.aliasesMatcher, this.dataStreamsMatcher);
        }

        public ActionRequestInfoResolvedIndicesMatcher hasAliases(String ... expected) {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, this.indicesMatcher, new ResolvedIndicesMatcher.AliasesMatcher(expected), this.dataStreamsMatcher);
        }

        public ActionRequestInfoResolvedIndicesMatcher hasDataStreams(String ... expected) {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, this.indicesMatcher, this.aliasesMatcher, new ResolvedIndicesMatcher.DataStreamsMatcher(expected));
        }

        public ActionRequestInfoResolvedIndicesMatcher hasNoIndices() {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, new ResolvedIndicesMatcher.IndicesMatcher(new String[0]), this.aliasesMatcher, this.dataStreamsMatcher);
        }

        public ActionRequestInfoResolvedIndicesMatcher hasNoAliases() {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, this.indicesMatcher, new ResolvedIndicesMatcher.AliasesMatcher(new String[0]), this.dataStreamsMatcher);
        }

        public ActionRequestInfoResolvedIndicesMatcher hasNoDataStreams() {
            return new ActionRequestInfoResolvedIndicesMatcher(this.role, this.indicesMatcher, this.aliasesMatcher, new ResolvedIndicesMatcher.DataStreamsMatcher(new String[0]));
        }
    }
}

