/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class BulkConfigApiTest {
    private static final TestSgConfig.User ADMIN_USER = new TestSgConfig.User("admin").roles(new TestSgConfig.Role("allaccess").indexPermissions("*").on("*").clusterPermissions("*"));
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().sslEnabled().user(ADMIN_USER).build();

    @Test
    public void getTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            Assert.assertEquals((String)response.getBody(), (Object)"basic/internal_users_db", (Object)((DocNode)responseDoc.getAsNode("authc").getAsNode("content").getAsListOfNodes("auth_domains").get(0)).get("type"));
        }
    }

    @Test
    public void putTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            LinkedHashMap<String, ImmutableMap> tenants = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("tenants").getAsNode("content"));
            tenants.put("my_new_test_tenant", ImmutableMap.of((Object)"description", (Object)"Test Tenant"));
            DocNode updateRequestDoc = DocNode.of((String)"tenants.content", tenants);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", updateRequestDoc.toJsonString(), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)200L, (long)updateResponse.getStatusCode());
            Assert.assertNotNull((String)updateResponse.getBody(), (Object)updateResponse.getBodyAsDocNode().get("data", new String[]{"tenants", "etag"}));
            Thread.sleep(300L);
            GenericRestClient.HttpResponse newGetResponse = client.get("/_searchguard/config", new Header[0]);
            DocNode newGetResponseDoc = DocNode.wrap((Object)DocReader.json().read(newGetResponse.getBody()));
            Assert.assertTrue((String)newGetResponse.getBody(), (newGetResponseDoc.getAsNode("tenants").getAsNode("content").get("my_new_test_tenant") != null ? 1 : 0) != 0);
            Assert.assertEquals((String)newGetResponse.getBody(), (Object)responseDoc.get("config"), (Object)newGetResponseDoc.get("config"));
        }
    }

    @Test
    public void configVarTest() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/config/vars/bulk_test", (Document<?>)DocNode.of((String)"value", (Object)"bar"));
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.putJson("/_searchguard/config/vars/bulk_test_encrypted", (Document<?>)DocNode.of((String)"value", (Object)"foo", (String)"encrypt", (Object)true));
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            Assert.assertEquals((String)response.getBody(), (Object)"bar", (Object)responseDoc.get("config_vars", new String[]{"content", "bulk_test", "value"}));
            Assert.assertNotNull((String)response.getBody(), (Object)responseDoc.get("config_vars", new String[]{"content", "bulk_test_encrypted", "encrypted"}));
            Assert.assertNull((String)response.getBody(), (Object)responseDoc.get("config_vars", new String[]{"content", "bulk_test_encrypted", "value"}));
            response = client.delete("/_searchguard/config/vars/bulk_test_encrypted", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Thread.sleep(20L);
            response = client.get("/_searchguard/config/vars/bulk_test_encrypted", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)404L, (long)response.getStatusCode());
            DocNode updateRequestDoc = DocNode.of((String)"config_vars.content", (Object)responseDoc.get("config_vars", new String[]{"content"}));
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", (Document<?>)updateRequestDoc);
            Assert.assertEquals((String)updateResponse.getBody(), (long)200L, (long)updateResponse.getStatusCode());
            Thread.sleep(20L);
            response = client.get("/_searchguard/config/vars/bulk_test_encrypted", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
        }
    }

    @Test
    public void putTestValidationError1() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            LinkedHashMap<String, ImmutableMap> tenants = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("tenants").getAsNode("content"));
            tenants.put("my_new_test_tenant", ImmutableMap.of((Object)"xxx", (Object)"Test Tenant"));
            DocNode updateRequestDoc = DocNode.of((String)"tenants.content", tenants);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", updateRequestDoc.toJsonString(), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)400L, (long)updateResponse.getStatusCode());
            DocNode updateResponseDoc = updateResponse.getBodyAsDocNode();
            Assert.assertEquals((String)updateResponse.getBody(), (Object)"'tenants.my_new_test_tenant.xxx': Unsupported attribute", (Object)updateResponseDoc.getAsNode("error").get("message"));
        }
    }

    @Test
    public void putTestValidationError2() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            LinkedHashMap<String, ImmutableMap> tenants = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("tenants").getAsNode("content"));
            tenants.put("my_new_test_tenant", ImmutableMap.of((Object)"xxx", (Object)"Test Tenant"));
            DocNode updateRequestDoc = DocNode.of((String)"tenants.content", tenants, (String)"foo.content", (Object)ImmutableMap.of((Object)"yyy", (Object)"Bla"));
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", updateRequestDoc.toJsonString(), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)400L, (long)updateResponse.getStatusCode());
            DocNode updateResponseDoc = updateResponse.getBodyAsDocNode();
            Assert.assertEquals((String)updateResponse.getBody(), (Object)"'foo': Invalid config type: foo", (Object)updateResponseDoc.getAsNode("error").get("message"));
        }
    }

    @Test
    public void putTestValidationError3_staticEntriesShouldBeRejected() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            LinkedHashMap<String, ImmutableMap> tenants = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("tenants").getAsNode("content"));
            tenants.put("my_new_test_tenant", ImmutableMap.of((Object)"description", (Object)"Test Tenant", (Object)"static", (Object)true));
            DocNode updateRequestDoc = DocNode.of((String)"tenants.content", tenants);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", updateRequestDoc.toJsonString(), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)400L, (long)updateResponse.getStatusCode());
            DocNode updateResponseDoc = updateResponse.getBodyAsDocNode();
            Assert.assertEquals((String)updateResponse.getBody(), (Object)"'tenants.content.my_new_test_tenant': Invalid value", (Object)updateResponseDoc.getAsNode("error").get("message"));
            Assert.assertEquals((String)updateResponse.getBody(), (Object)"Non-static entry", (Object)((DocNode)updateResponseDoc.getAsNode("error").getAsNode("details").getAsListOfNodes("tenants.content.my_new_test_tenant").get(0)).get("expected"));
        }
    }

    @Test
    public void putTestValidationError4_frontendAuthcLoginPageWithRelativePathShouldBeRejected() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = DocNode.wrap((Object)DocReader.json().read(response.getBody()));
            LinkedHashMap<String, ImmutableMap> frontendAuthc = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("frontend_authc").getAsNode("content"));
            frontendAuthc.put("default", ImmutableMap.of((Object)"login_page", (Object)ImmutableMap.of((Object)"brand_image", (Object)"/relative/img.png")));
            DocNode updateRequestDoc = DocNode.of((String)"frontend_authc.content", frontendAuthc);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", updateRequestDoc.toJsonString(), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)400L, (long)updateResponse.getStatusCode());
            DocNode updateResponseDoc = updateResponse.getBodyAsDocNode();
            Assert.assertEquals((String)updateResponse.getBody(), (Object)"'frontend_authc.default.login_page.brand_image': Must be an absolute URI", (Object)updateResponseDoc.getAsNode("error").get("message"));
        }
    }

    @Test
    public void putTestValidationError5_rolesWhichAssignsPermsToNoExistentTenantsShouldBeRejected() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String existingTenant = "existing-tenant";
            String missingTenant = "missing-tenant";
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = response.getBodyAsDocNode();
            LinkedHashMap<String, ImmutableMap> roles = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("roles").getAsNode("content"));
            roles.put("my-correct-role", ImmutableMap.of((Object)"tenant_permissions", (Object)ImmutableMap.of((Object)"tenant_patterns", Collections.singletonList(existingTenant + "*"), (Object)"allowed_actions", Collections.singletonList("*"))));
            roles.put("my-invalid-role", ImmutableMap.of((Object)"tenant_permissions", (Object)ImmutableMap.of((Object)"tenant_patterns", Collections.singletonList(missingTenant + "*"), (Object)"allowed_actions", Collections.singletonList("*"))));
            LinkedHashMap<String, ImmutableMap> tenants = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("tenants").getAsNode("content"));
            tenants.put(existingTenant, ImmutableMap.of((Object)"description", (Object)existingTenant));
            DocNode updateRequestDoc = DocNode.of((String)"roles.content", roles, (String)"tenants.content", tenants);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", (Document<?>)updateRequestDoc);
            Assert.assertEquals((String)updateResponse.getBody(), (long)400L, (long)updateResponse.getStatusCode());
            DocNode updateResponseDoc = updateResponse.getBodyAsDocNode();
            Assert.assertEquals((String)updateResponse.getBody(), (long)1L, (long)updateResponseDoc.getAsNode("error").getAsNode("details").size());
            Assert.assertEquals((String)updateResponse.getBody(), (Object)("Tenant pattern: '" + missingTenant + "*' does not match any tenant"), (Object)((DocNode)updateResponseDoc.getAsNode("error").getAsNode("details").getAsListOfNodes("roles.my-invalid-role").get(0)).get("error"));
            tenants.put(missingTenant, ImmutableMap.of((Object)"description", (Object)"tenant added to fix role"));
            response = client.putJson("/_searchguard/config", (Document<?>)DocNode.of((String)"tenants.content", tenants));
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            updateResponse = client.putJson("/_searchguard/config", (Document<?>)DocNode.of((String)"roles.content", roles));
            Assert.assertEquals((String)updateResponse.getBody(), (long)200L, (long)updateResponse.getStatusCode());
        }
    }

    @Test
    public void putRoleWhichAssignsPermsToGlobalTenant() throws Exception {
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String tenantName = "SGS_GLOBAL_TENANT";
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config", new Header[0]);
            DocNode responseDoc = response.getBodyAsDocNode();
            LinkedHashMap<String, ImmutableMap> roles = new LinkedHashMap<String, ImmutableMap>((Map<String, ImmutableMap>)responseDoc.getAsNode("roles").getAsNode("content"));
            roles.put("my-role", ImmutableMap.of((Object)"tenant_permissions", (Object)ImmutableMap.of((Object)"tenant_patterns", Collections.singletonList(tenantName + "*"), (Object)"allowed_actions", Collections.singletonList("*"))));
            DocNode updateRequestDoc = DocNode.of((String)"roles.content", roles);
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", (Document<?>)updateRequestDoc);
            Assert.assertEquals((String)updateResponse.getBody(), (long)200L, (long)updateResponse.getStatusCode());
        }
    }

    @Test
    public void putTestWithoutAdminCert() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse updateResponse = client.putJson("/_searchguard/config", DocWriter.json().writeAsString((Document)DocNode.of((String)"a", (Object)"b")), new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)403L, (long)updateResponse.getStatusCode());
        }
    }

    @Test
    public void getTestWithoutAdminCert() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse updateResponse = client.get("/_searchguard/config", new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)403L, (long)updateResponse.getStatusCode());
        }
    }

    @Test
    public void getTestWithoutAdminCertWithAllowedAction() throws Exception {
        try (LocalCluster cluster = new LocalCluster.Builder().sslEnabled().user(ADMIN_USER).nodeSettings("searchguard.admin_only_actions", Collections.singletonList("x/x")).start();
             GenericRestClient client = cluster.getRestClient(ADMIN_USER, new Header[0]);){
            GenericRestClient.HttpResponse updateResponse = client.get("/_searchguard/config", new Header[0]);
            Assert.assertEquals((String)updateResponse.getBody(), (long)200L, (long)updateResponse.getStatusCode());
        }
    }
}

