/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SearchGuardHttpServerTransportTest {
    @Mock
    private HttpRequest request;
    @Mock
    private HttpBody.Stream streamBody;
    @Mock
    private HttpBody.Full fullBody;
    @Mock
    private BytesReference bytesReference;

    @Test
    public void shouldHaveBody() {
        Mockito.when((Object)this.streamBody.isFull()).thenReturn((Object)false);
        Mockito.when((Object)this.request.body()).thenReturn((Object)this.streamBody);
        boolean empty = SearchGuardHttpServerTransport.hasEmptyBody((HttpRequest)this.request);
        MatcherAssert.assertThat((Object)empty, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldHaveFullEmptyBodyWhenByteReferenceIsZero() {
        Mockito.when((Object)this.fullBody.isFull()).thenReturn((Object)true);
        Mockito.when((Object)this.fullBody.bytes()).thenReturn((Object)this.bytesReference);
        Mockito.when((Object)this.fullBody.asFull()).thenReturn((Object)this.fullBody);
        Mockito.when((Object)this.request.body()).thenReturn((Object)this.fullBody);
        Mockito.when((Object)this.bytesReference.length()).thenReturn((Object)0);
        boolean empty = SearchGuardHttpServerTransport.hasEmptyBody((HttpRequest)this.request);
        MatcherAssert.assertThat((Object)empty, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldHaveFullEmptyBodyWhenByteReferenceIsNull() {
        Mockito.when((Object)this.fullBody.isFull()).thenReturn((Object)true);
        Mockito.when((Object)this.fullBody.bytes()).thenReturn(null);
        Mockito.when((Object)this.fullBody.asFull()).thenReturn((Object)this.fullBody);
        Mockito.when((Object)this.request.body()).thenReturn((Object)this.fullBody);
        boolean empty = SearchGuardHttpServerTransport.hasEmptyBody((HttpRequest)this.request);
        MatcherAssert.assertThat((Object)empty, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldHaveNonEmptyFullBody() {
        Mockito.when((Object)this.fullBody.isFull()).thenReturn((Object)true);
        Mockito.when((Object)this.fullBody.bytes()).thenReturn((Object)this.bytesReference);
        Mockito.when((Object)this.fullBody.asFull()).thenReturn((Object)this.fullBody);
        Mockito.when((Object)this.request.body()).thenReturn((Object)this.fullBody);
        Mockito.when((Object)this.bytesReference.length()).thenReturn((Object)1);
        boolean empty = SearchGuardHttpServerTransport.hasEmptyBody((HttpRequest)this.request);
        MatcherAssert.assertThat((Object)empty, (Matcher)Matchers.is((Object)false));
    }
}

