/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;

public class GenericRestClient
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(GenericRestClient.class);
    public boolean enableHTTPClientSSL = true;
    public boolean enableHTTPClientSSLv3Only = false;
    private final InetSocketAddress nodeHttpAddress;
    private GenericSSLConfig sslConfig;
    private RequestConfig requestConfig;
    private final List<Header> headers = new ArrayList<Header>();
    private final Header CONTENT_TYPE_JSON = new BasicHeader("Content-Type", "application/json");
    private final Header CONTENT_TYPE_JSON_MERGE = new BasicHeader("Content-Type", "application/merge-patch+json");
    private final Header CONTENT_TYPE_NDJSON = new BasicHeader("Content-Type", "application/x-ndjson");
    private boolean trackResources = false;
    private GenericRestClient clientForTrackedResourceDeletion;
    private Consumer<RequestInfo> requestInfoConsumer;
    private final Set<String> puttedResourcesSet = new HashSet<String>();
    private final List<String> puttedResourcesList = new ArrayList<String>();
    private final SSLContext sslContext;
    private final EsClientProvider.UserCredentialsHolder user;

    public GenericRestClient(InetSocketAddress nodeHttpAddress, List<Header> headers, SSLContext sslContext, EsClientProvider.UserCredentialsHolder user, Consumer<RequestInfo> requestInfoConsumer) {
        this.nodeHttpAddress = nodeHttpAddress;
        this.headers.addAll(headers);
        this.sslContext = sslContext;
        this.user = user;
        this.requestInfoConsumer = requestInfoConsumer;
    }

    public HttpResponse get(String path, Header ... headers) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpGet(this.getHttpServerUri() + "/" + path), new RequestInfo().path(path).method("GET"), headers);
    }

    public HttpResponse head(String path, Header ... headers) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpHead(this.getHttpServerUri() + "/" + path), new RequestInfo().path(path).method("HEAD"), headers);
    }

    public HttpResponse options(String path, Header ... headers) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpOptions(this.getHttpServerUri() + "/" + path), new RequestInfo().path(path).method("OPTIONS"), headers);
    }

    public HttpResponse putJson(String path, String body, Header ... headers) throws Exception {
        HttpPut uriRequest = new HttpPut(this.getHttpServerUri() + "/" + path);
        uriRequest.setEntity((HttpEntity)new StringEntity(body, org.apache.http.entity.ContentType.APPLICATION_JSON));
        HttpResponse response = this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PUT").requestBody(body), this.mergeHeaders(this.CONTENT_TYPE_JSON, headers));
        if (response.getStatusCode() < 400 && this.trackResources && !this.puttedResourcesSet.contains(path)) {
            this.puttedResourcesSet.add(path);
            this.puttedResourcesList.add(path);
        }
        return response;
    }

    public HttpResponse putJson(String path, Document<?> body) throws Exception {
        return this.putJson(path, body.toJsonString(), new Header[0]);
    }

    public HttpResponse putJson(String path, Document<?> body, Header ... headers) throws Exception {
        return this.putJson(path, body.toJsonString(), headers);
    }

    public HttpResponse putJson(String path, ToXContentObject body) throws Exception {
        return this.putJson(path, Strings.toString((ToXContent)body), new Header[0]);
    }

    public HttpResponse put(String path) throws Exception {
        HttpPut uriRequest = new HttpPut(this.getHttpServerUri() + "/" + path);
        HttpResponse response = this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PUT"), new Header[0]);
        if (response.getStatusCode() < 400 && this.trackResources && !this.puttedResourcesSet.contains(path)) {
            this.puttedResourcesSet.add(path);
            this.puttedResourcesList.add(path);
        }
        return response;
    }

    public HttpResponse putNdJson(String path, Document<?> ... bodyElements) throws Exception {
        HttpPut uriRequest = new HttpPut(this.getHttpServerUri() + "/" + path);
        StringBuilder body = new StringBuilder();
        for (Document<?> bodyElement : bodyElements) {
            body.append(bodyElement.toJsonString());
            body.append("\n");
        }
        uriRequest.setEntity((HttpEntity)new StringEntity(body.toString(), org.apache.http.entity.ContentType.APPLICATION_JSON));
        HttpResponse response = this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PUT").requestBody(body.toString()), this.CONTENT_TYPE_NDJSON);
        if (response.getStatusCode() < 400 && this.trackResources && !this.puttedResourcesSet.contains(path)) {
            this.puttedResourcesSet.add(path);
            this.puttedResourcesList.add(path);
        }
        return response;
    }

    public HttpResponse delete(String path, Header ... headers) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpDelete(this.getHttpServerUri() + "/" + path), new RequestInfo().path(path).method("DELETE"), headers);
    }

    public HttpResponse deleteJson(final String path, Map<String, Object> body, Header ... headers) throws Exception {
        HttpEntityEnclosingRequestBase uriRequest = new HttpEntityEnclosingRequestBase(){
            {
                this.setURI(URI.create(GenericRestClient.this.getHttpServerUri() + "/" + path));
            }

            public String getMethod() {
                return "DELETE";
            }
        };
        uriRequest.setEntity((HttpEntity)new StringEntity(DocWriter.json().writeAsString(body), org.apache.http.entity.ContentType.APPLICATION_JSON));
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("DELETE"), headers);
    }

    public HttpResponse postJson(String path, String body, Header ... headers) throws Exception {
        HttpPost uriRequest = new HttpPost(this.getHttpServerUri() + "/" + path);
        uriRequest.setEntity((HttpEntity)new StringEntity(body, org.apache.http.entity.ContentType.APPLICATION_JSON));
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("POST").requestBody(body), this.mergeHeaders(this.CONTENT_TYPE_JSON, headers));
    }

    public HttpResponse postJson(String path, ToXContentObject body) throws Exception {
        return this.postJson(path, Strings.toString((ToXContent)body), new Header[0]);
    }

    public HttpResponse postJson(String path, Map<String, Object> body, Header ... headers) throws Exception {
        return this.postJson(path, DocWriter.json().writeAsString(body), headers);
    }

    public HttpResponse post(String path) throws Exception {
        HttpPost uriRequest = new HttpPost(this.getHttpServerUri() + "/" + path);
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("POST"), new Header[0]);
    }

    public HttpResponse post(String path, Header ... headers) throws Exception {
        HttpPost uriRequest = new HttpPost(this.getHttpServerUri() + "/" + path);
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("POST"), headers);
    }

    public HttpResponse patch(String path, String body) throws Exception {
        HttpPatch uriRequest = new HttpPatch(this.getHttpServerUri() + "/" + path);
        uriRequest.setEntity((HttpEntity)new StringEntity(body));
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PATCH").requestBody(body), this.CONTENT_TYPE_JSON);
    }

    public HttpResponse patch(String path, DocPatch docPatch, Header ... headers) throws Exception {
        HttpPatch uriRequest = new HttpPatch(this.getHttpServerUri() + "/" + path);
        uriRequest.setEntity((HttpEntity)new StringEntity(docPatch.toJsonString(), org.apache.http.entity.ContentType.APPLICATION_JSON));
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PATCH").requestBody(docPatch.toJsonString()), this.mergeHeaders((Header)new BasicHeader("Content-Type", docPatch.getMediaType()), headers));
    }

    public HttpResponse patchJsonMerge(String path, Document<?> body, Header ... headers) throws Exception {
        return this.patchJsonMerge(path, body.toJsonString(), headers);
    }

    public HttpResponse patchJsonMerge(String path, String body, Header ... headers) throws Exception {
        HttpPatch uriRequest = new HttpPatch(this.getHttpServerUri() + "/" + path);
        uriRequest.setEntity((HttpEntity)new StringEntity(body, org.apache.http.entity.ContentType.APPLICATION_JSON));
        return this.executeRequest((HttpUriRequest)uriRequest, new RequestInfo().path(path).method("PUT").requestBody(body), this.mergeHeaders(this.CONTENT_TYPE_JSON_MERGE, headers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse executeRequest(HttpUriRequest uriRequest, RequestInfo requestInfo, Header ... requestSpecificHeaders) throws Exception {
        CloseableHttpClient httpClient = null;
        try {
            requestInfo.user(this.user);
            httpClient = this.getHTTPClient();
            if (requestSpecificHeaders != null && requestSpecificHeaders.length > 0) {
                for (int i = 0; i < requestSpecificHeaders.length; ++i) {
                    Header h = requestSpecificHeaders[i];
                    uriRequest.addHeader(h);
                }
            }
            for (Header header : this.headers) {
                uriRequest.addHeader(header);
            }
            HttpResponse response = new HttpResponse(this.innerExecuteRequest(httpClient, uriRequest));
            requestInfo.response(response);
            log.debug(response.getBody());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (this.requestInfoConsumer != null) {
                this.requestInfoConsumer.accept(requestInfo);
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    protected CloseableHttpResponse innerExecuteRequest(CloseableHttpClient httpClient, HttpUriRequest uriRequest) throws ClientProtocolException, IOException {
        return httpClient.execute(uriRequest);
    }

    public GenericRestClient trackResources() {
        this.trackResources = true;
        this.clientForTrackedResourceDeletion = this;
        return this;
    }

    public GenericRestClient trackResources(GenericRestClient clientForTrackedResourceDeletion) {
        this.trackResources = true;
        this.clientForTrackedResourceDeletion = clientForTrackedResourceDeletion;
        return this;
    }

    public GenericRestClient recordRequests(Consumer<RequestInfo> requestInfoConsumer) {
        this.requestInfoConsumer = requestInfoConsumer;
        return this;
    }

    public GenericRestClient deleteWhenClosed(String ... paths) {
        if (this.clientForTrackedResourceDeletion == null) {
            this.clientForTrackedResourceDeletion = this;
        }
        for (String path : paths) {
            if (this.puttedResourcesSet.contains(path)) continue;
            this.puttedResourcesSet.add(path);
            this.puttedResourcesList.add(path);
        }
        return this;
    }

    private void cleanupResources() {
        if (this.puttedResourcesList.size() > 0) {
            log.info("Cleaning up " + this.puttedResourcesList);
            for (String resource : Lists.reverse(this.puttedResourcesList)) {
                try {
                    this.clientForTrackedResourceDeletion.delete(resource, new Header[0]);
                }
                catch (Exception e) {
                    log.error("Error cleaning up created resources " + resource, (Throwable)e);
                }
            }
        }
    }

    protected final String getHttpServerUri() {
        return "http" + (this.enableHTTPClientSSL ? "s" : "") + "://" + this.nodeHttpAddress.getHostString() + ":" + this.nodeHttpAddress.getPort();
    }

    protected final CloseableHttpClient getHTTPClient() throws Exception {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (this.sslConfig != null) {
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslConfig.toSSLConnectionSocketFactory());
        } else if (this.enableHTTPClientSSL) {
            log.debug("Configure HTTP client with SSL");
            String[] protocols = null;
            protocols = this.enableHTTPClientSSLv3Only ? new String[]{"SSLv3"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(this.sslContext, protocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        clientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(20000).build());
        if (this.requestConfig != null) {
            clientBuilder.setDefaultRequestConfig(this.requestConfig);
        }
        this.configureHttpClientBuilder(clientBuilder);
        return clientBuilder.build();
    }

    protected void configureHttpClientBuilder(HttpClientBuilder clientBuilder) {
    }

    private Header[] mergeHeaders(Header header, Header ... headers) {
        if (headers == null || headers.length == 0) {
            return new Header[]{header};
        }
        Header[] result = new Header[headers.length + 1];
        result[0] = header;
        System.arraycopy(headers, 0, result, 1, headers.length);
        return result;
    }

    public GenericSSLConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(GenericSSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public String toString() {
        return "RestHelper [server=" + this.getHttpServerUri() + ", node=" + this.nodeHttpAddress + ", sslConfig=" + this.sslConfig + "]";
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.requestConfig = this.requestConfig == null ? RequestConfig.custom().setLocalAddress(inetAddress).build() : RequestConfig.copy((RequestConfig)this.requestConfig).setLocalAddress(inetAddress).build();
    }

    @Override
    public void close() throws IOException {
        this.cleanupResources();
    }

    public EsClientProvider.UserCredentialsHolder getUser() {
        return this.user;
    }

    public static class RequestInfo {
        private EsClientProvider.UserCredentialsHolder user;
        private String path;
        private String method;
        private String requestBody;
        private HttpResponse response;

        public EsClientProvider.UserCredentialsHolder getUser() {
            return this.user;
        }

        public RequestInfo user(EsClientProvider.UserCredentialsHolder user) {
            this.user = user;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public RequestInfo path(String path) {
            if (((String)path).length() == 0) {
                path = "/";
            } else if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            this.path = path;
            return this;
        }

        public String getMethod() {
            return this.method;
        }

        public RequestInfo method(String method) {
            this.method = method;
            return this;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public RequestInfo requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public RequestInfo response(HttpResponse response) {
            this.response = response;
            return this;
        }

        public String toString() {
            StringBuilder result;
            block8: {
                result = new StringBuilder();
                if (this.user != null) {
                    result.append(this.user.getName()).append(": ");
                }
                result.append(this.method).append(" ").append(this.path).append("\n");
                if (this.requestBody != null) {
                    result.append(this.requestBody).append("\n");
                }
                result.append("\n");
                if (this.response != null) {
                    result.append(this.response.statusCode).append(" ").append(this.response.statusReason).append("\n");
                    if (this.response.isJsonContentType()) {
                        try {
                            String prettyJson = this.response.getBodyAsDocNode().toPrettyJsonString();
                            if (this.countOfLines(prettyJson) <= 25) {
                                result.append(prettyJson).append("\n");
                                break block8;
                            }
                            result.append(this.response.getBody()).append("\n");
                        }
                        catch (DocumentParseException | Format.UnknownDocTypeException e) {
                            result.append(this.response.getBody()).append("\n");
                        }
                    } else {
                        result.append(this.response.getBody()).append("\n");
                    }
                }
            }
            return result.toString();
        }

        private int countOfLines(String s) {
            int result = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '\n') continue;
                ++result;
            }
            return result;
        }
    }

    public static class HttpResponse {
        private final CloseableHttpResponse inner;
        private final String body;
        private final Header[] headers;
        private final int statusCode;
        private final String statusReason;
        private DocNode parsedBody;

        public HttpResponse(CloseableHttpResponse inner) throws IllegalStateException, IOException {
            this.inner = inner;
            HttpEntity entity = inner.getEntity();
            this.body = entity == null ? "" : IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            this.headers = inner.getAllHeaders();
            this.statusCode = inner.getStatusLine().getStatusCode();
            this.statusReason = inner.getStatusLine().getReasonPhrase();
            inner.close();
        }

        public String getContentType() {
            Header h = this.getInner().getFirstHeader("content-type");
            if (h != null) {
                return h.getValue();
            }
            return null;
        }

        public boolean isJsonContentType() {
            String ct = this.getContentType();
            if (ct == null) {
                return false;
            }
            return ct.contains("application/json");
        }

        public CloseableHttpResponse getInner() {
            return this.inner;
        }

        public String getBody() {
            return this.body;
        }

        public DocNode getBodyAsDocNode() throws DocumentParseException, Format.UnknownDocTypeException {
            DocNode result = this.parsedBody;
            if (result != null) {
                return result;
            }
            this.parsedBody = result = DocNode.parse((ContentType)ContentType.parseHeader((String)this.getContentType())).from(this.body);
            return result;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusReason() {
            return this.statusReason;
        }

        public List<Header> getHeaders() {
            return this.headers == null ? Collections.emptyList() : Arrays.asList(this.headers);
        }

        public String getHeaderValue(String name) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                return header.getValue();
            }
            return null;
        }

        public String toString() {
            return "HttpResponse [inner=" + this.inner + ", body=" + this.body + ", header=" + Arrays.toString(this.headers) + ", statusCode=" + this.statusCode + ", statusReason=" + this.statusReason + "]";
        }
    }
}

