/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestIndex;
import com.floragunn.searchguard.test.TestIndexLike;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

public class IndexApiMatchers {
    private static final Pattern DS_BACKING_INDEX_PATTERN = Pattern.compile("\\.ds-(.+)-[0-9\\.]+-[0-9]+");
    private static final TestIndexLike SEARCH_GUARD_INDICES = new TestIndexLike(){

        @Override
        public String getName() {
            return ".searchguard*";
        }

        @Override
        public Map<String, Map<String, ?>> getDocuments() {
            return null;
        }

        @Override
        public Set<String> getDocumentIds() {
            return null;
        }
    };
    private static final TestIndexLike ES_INTERNAL_INDICES = new TestIndexLike(){

        @Override
        public String getName() {
            return ".es-internal*";
        }

        @Override
        public Map<String, Map<String, ?>> getDocuments() {
            return null;
        }

        @Override
        public Set<String> getDocumentIds() {
            return null;
        }
    };

    public static IndexMatcher containsExactly(TestIndexLike ... testIndices) {
        HashMap<String, TestIndexLike> indexNameMap = new HashMap<String, TestIndexLike>();
        boolean containsSearchGuardIndices = false;
        boolean containsEsInternalIndices = false;
        for (TestIndexLike testIndex : testIndices) {
            if (testIndex == SEARCH_GUARD_INDICES) {
                containsSearchGuardIndices = true;
                continue;
            }
            if (testIndex == ES_INTERNAL_INDICES) {
                containsEsInternalIndices = true;
                continue;
            }
            indexNameMap.put(testIndex.getName(), testIndex);
        }
        return new ContainsExactlyMatcher(indexNameMap, containsSearchGuardIndices, containsEsInternalIndices);
    }

    public static IndexMatcher limitedTo(TestIndexLike ... testIndices) {
        HashMap<String, TestIndexLike> indexNameMap = new HashMap<String, TestIndexLike>();
        for (TestIndexLike testIndex : testIndices) {
            indexNameMap.put(testIndex.getName(), testIndex);
        }
        return new LimitedToMatcher(indexNameMap);
    }

    public static IndexMatcher unlimited() {
        return new UnlimitedMatcher();
    }

    public static IndexMatcher unlimitedIncludingEsInternalIndices() {
        return new UnlimitedMatcher(false, true);
    }

    public static IndexMatcher unlimitedIncludingSearchGuardIndices() {
        return new UnlimitedMatcher(true, true);
    }

    public static IndexMatcher limitedToNone() {
        return new LimitedToMatcher(Collections.emptyMap());
    }

    public static TestIndexLike searchGuardIndices() {
        return SEARCH_GUARD_INDICES;
    }

    public static TestIndexLike esInternalIndices() {
        return ES_INTERNAL_INDICES;
    }

    private static String formatResponse(GenericRestClient.HttpResponse response) {
        if (response == null) {
            return "";
        }
        String start = response.getStatusCode() + " " + response.getStatusReason() + "\n";
        if (response.getContentType().startsWith("application/json")) {
            try {
                return start + response.getBodyAsDocNode().toPrettyJsonString();
            }
            catch (DocumentParseException | Format.UnknownDocTypeException e) {
                return start + response.getBody();
            }
        }
        return start + response.getBody();
    }

    public static class ContainsExactlyMatcher
    extends AbstractIndexMatcher
    implements IndexMatcher {
        public ContainsExactlyMatcher(Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices) {
            super(indexNameMap, containsSearchGuardIndices, containsEsInternalIndices);
        }

        public ContainsExactlyMatcher(Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices, String jsonPath, int statusCodeWhenEmpty) {
            super(indexNameMap, containsSearchGuardIndices, containsEsInternalIndices, jsonPath, statusCodeWhenEmpty);
        }

        public void describeTo(Description description) {
            if (this.indexNameMap.isEmpty()) {
                if (this.statusCodeWhenEmpty == 200) {
                    description.appendText("a 200 OK response with an empty result set");
                } else {
                    description.appendText("a response with status code " + this.statusCodeWhenEmpty);
                }
            } else {
                description.appendText("a 200 OK response with exactly the indices " + this.indexNameMap.keySet().stream().collect(Collectors.joining(", ")));
            }
        }

        @Override
        protected boolean matchesImpl(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            boolean checkDocs = false;
            Iterator iterator = (collection = (Collection)collection.stream().flatMap(e -> e instanceof Collection ? ((Collection)e).stream() : Stream.of(e)).collect(Collectors.toSet())).iterator();
            if (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    checkDocs = false;
                } else if (object instanceof Map && ((Map)object).containsKey("_index")) {
                    checkDocs = true;
                } else {
                    mismatchDescription.appendText("unexpected value ").appendValue((Object)collection);
                    return false;
                }
            }
            if (checkDocs) {
                return this.matchesByDocs(collection, mismatchDescription, response);
            }
            return this.matchesByIndices(collection, mismatchDescription, response);
        }

        protected boolean matchesByDocs(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            Set<String> pendingDocuments = this.getExpectedDocuments();
            ImmutableSet.Builder seenSearchGuardIndicesBuilder = new ImmutableSet.Builder();
            for (Object object : collection) {
                DocNode docNode = DocNode.wrap(object);
                String indexName = docNode.getAsString("_index");
                if (this.containsSearchGuardIndices && (indexName.startsWith(".searchguard") || indexName.equals("searchguard"))) {
                    seenSearchGuardIndicesBuilder.add((Object)indexName);
                    continue;
                }
                TestIndexLike index = (TestIndexLike)this.indexNameMap.get(indexName);
                if (index == null) {
                    mismatchDescription.appendText("result contains unknown index: ").appendValue((Object)docNode.getAsString("_index")).appendText("; expected: ").appendValue(this.indexNameMap.keySet()).appendText("\ndocument: ").appendText(docNode.toJsonString());
                    mismatchDescription.appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
                    return false;
                }
                Map<String, ?> document = index.getDocuments().get(docNode.getAsString("_id"));
                if (document == null) {
                    mismatchDescription.appendText("result contains unknown document id ").appendValue((Object)docNode.getAsString("_id")).appendText(" for index ").appendValue((Object)docNode.getAsString("_index")).appendText("\ndocument: ").appendText(docNode.toJsonString());
                    mismatchDescription.appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
                    return false;
                }
                if (!document.equals(docNode.get("_source"))) {
                    mismatchDescription.appendText("result document ").appendValue((Object)docNode.getAsString("_id")).appendText(" in index ").appendValue((Object)docNode.getAsString("_index")).appendText(" does not match expected document:\n").appendText(docNode.getAsNode("_source").toJsonString()).appendText("\n").appendText(DocNode.wrap(document).toJsonString());
                    mismatchDescription.appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
                    return false;
                }
                pendingDocuments.remove(docNode.getAsString("_index") + "/" + docNode.getAsString("_id"));
            }
            if (!pendingDocuments.isEmpty()) {
                mismatchDescription.appendText("result does not contain expected documents: ").appendValue(pendingDocuments);
                mismatchDescription.appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
                return false;
            }
            if (this.containsSearchGuardIndices && seenSearchGuardIndicesBuilder.size() == 0) {
                mismatchDescription.appendText("result does not contain expected .searchguard index");
                mismatchDescription.appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
                return false;
            }
            return true;
        }

        protected boolean matchesByIndices(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            ImmutableSet<String> expectedIndices = this.getExpectedIndices();
            ImmutableSet.Builder seenIndicesBuilder = new ImmutableSet.Builder(expectedIndices.size());
            ImmutableSet.Builder seenSearchGuardIndicesBuilder = new ImmutableSet.Builder();
            for (Object object : collection) {
                String index = object.toString();
                if (this.containsSearchGuardIndices && (index.startsWith(".searchguard") || index.equals("searchguard"))) {
                    seenSearchGuardIndicesBuilder.add((Object)index);
                    continue;
                }
                if (this.containsEsInternalIndices && (index.startsWith(".logs-deprecation") || index.startsWith(".ds-.logs-deprecation"))) continue;
                if (index.startsWith(".ds-")) {
                    java.util.regex.Matcher matcher = DS_BACKING_INDEX_PATTERN.matcher(index);
                    if (matcher.matches() && expectedIndices.contains((Object)matcher.group(1))) {
                        seenIndicesBuilder.add((Object)matcher.group(1));
                        continue;
                    }
                    seenIndicesBuilder.add((Object)index);
                    continue;
                }
                seenIndicesBuilder.add((Object)index);
            }
            ImmutableSet seenIndices = seenIndicesBuilder.build();
            ImmutableSet unexpectedIndices = seenIndices.without(expectedIndices);
            ImmutableSet missingIndices = expectedIndices.without((Collection)seenIndices);
            if (this.containsSearchGuardIndices && seenSearchGuardIndicesBuilder.size() == 0) {
                missingIndices = missingIndices.with((Object)".searchguard indices");
            }
            if (unexpectedIndices.isEmpty() && missingIndices.isEmpty()) {
                return true;
            }
            if (!missingIndices.isEmpty()) {
                mismatchDescription.appendText("result does not contain expected indices; found: ").appendValue((Object)seenIndices).appendText("; missing: ").appendValue((Object)missingIndices).appendText("\n\n").appendText(IndexApiMatchers.formatResponse(response));
            }
            if (!unexpectedIndices.isEmpty()) {
                mismatchDescription.appendText("result does contain indices that were not expected: ").appendValue((Object)unexpectedIndices).appendText("\n\n").appendText(IndexApiMatchers.formatResponse(response));
            }
            return false;
        }

        private Set<String> getExpectedDocuments() {
            HashSet<String> pendingDocuments = new HashSet<String>();
            for (Map.Entry entry : this.indexNameMap.entrySet()) {
                for (String id : ((TestIndexLike)entry.getValue()).getDocumentIds()) {
                    pendingDocuments.add((String)entry.getKey() + "/" + id);
                }
            }
            return pendingDocuments;
        }

        private ImmutableSet<String> getExpectedIndices() {
            return ImmutableSet.of(this.indexNameMap.keySet());
        }

        @Override
        public IndexMatcher but(IndexMatcher other) {
            if (other instanceof LimitedToMatcher) {
                return new ContainsExactlyMatcher(this.intersection(this.indexNameMap, ((LimitedToMatcher)other).indexNameMap), this.containsSearchGuardIndices && other.containsSearchGuardIndices(), this.containsEsInternalIndices && other.containsEsInternalIndices(), this.jsonPath, this.statusCodeWhenEmpty);
            }
            if (other instanceof ContainsExactlyMatcher) {
                return new ContainsExactlyMatcher(this.intersection(this.indexNameMap, ((ContainsExactlyMatcher)other).indexNameMap), this.containsSearchGuardIndices && other.containsSearchGuardIndices(), this.containsEsInternalIndices && other.containsEsInternalIndices(), this.jsonPath, this.statusCodeWhenEmpty);
            }
            if (other instanceof UnlimitedMatcher) {
                return new ContainsExactlyMatcher(this.indexNameMap, this.containsSearchGuardIndices && other.containsSearchGuardIndices(), this.containsEsInternalIndices && other.containsEsInternalIndices(), this.jsonPath, this.statusCodeWhenEmpty);
            }
            throw new RuntimeException("Unexpected argument " + other);
        }

        private Map<String, TestIndexLike> intersection(Map<String, TestIndexLike> map1, Map<String, TestIndexLike> map2) {
            HashMap<String, TestIndexLike> result = new HashMap<String, TestIndexLike>();
            for (Map.Entry<String, TestIndexLike> entry : map1.entrySet()) {
                String key = entry.getKey();
                TestIndexLike index1 = entry.getValue();
                TestIndexLike index2 = map2.get(key);
                if (index2 == null) continue;
                result.put(key, index1.intersection(index2));
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        public boolean isCoveredBy(IndexMatcher other) {
            if (other instanceof LimitedToMatcher) {
                return ((LimitedToMatcher)other).getExpectedIndices().containsAll(this.getExpectedIndices());
            }
            if (other instanceof ContainsExactlyMatcher) {
                return ((ContainsExactlyMatcher)other).getExpectedIndices().containsAll(this.getExpectedIndices());
            }
            if (other instanceof UnlimitedMatcher) {
                return true;
            }
            throw new RuntimeException("Unexpected argument " + other);
        }

        @Override
        public IndexMatcher at(String jsonPath) {
            return new ContainsExactlyMatcher(this.indexNameMap, this.containsSearchGuardIndices, this.containsEsInternalIndices, jsonPath, this.statusCodeWhenEmpty);
        }

        @Override
        public IndexMatcher whenEmpty(int statusCode) {
            return new ContainsExactlyMatcher(this.indexNameMap, this.containsSearchGuardIndices, this.containsEsInternalIndices, this.jsonPath, statusCode);
        }

        @Override
        public boolean covers(TestIndex testIndex) {
            return this.indexNameMap.containsKey(testIndex.getName());
        }
    }

    public static class LimitedToMatcher
    extends AbstractIndexMatcher
    implements IndexMatcher {
        public LimitedToMatcher(Map<String, TestIndexLike> indexNameMap) {
            super(indexNameMap, false, false);
        }

        public LimitedToMatcher(Map<String, TestIndexLike> indexNameMap, String jsonPath, int statusCodeWhenEmpty) {
            super(indexNameMap, false, false, jsonPath, statusCodeWhenEmpty);
        }

        public void describeTo(Description description) {
            if (this.indexNameMap.isEmpty()) {
                if (this.statusCodeWhenEmpty == 200) {
                    description.appendText("a 200 OK response with an empty result set");
                } else {
                    description.appendText("a response with status code " + this.statusCodeWhenEmpty);
                }
            } else {
                description.appendText("a 200 OK response no indices other than " + this.indexNameMap.keySet().stream().collect(Collectors.joining(", ")));
            }
        }

        @Override
        protected boolean matchesImpl(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            boolean checkDocs = false;
            Iterator<?> iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof String) {
                    checkDocs = false;
                } else if (object instanceof Map && ((Map)object).containsKey("_index")) {
                    checkDocs = true;
                } else {
                    mismatchDescription.appendText("unexpected value ").appendValue(object).appendText(" (").appendValue((Object)(object != null ? object.getClass().toString() : "null")).appendText(")\n\n").appendText(IndexApiMatchers.formatResponse(response));
                    return false;
                }
            }
            if (checkDocs) {
                return this.matchesByDocs(collection, mismatchDescription, response);
            }
            return this.matchesByIndices(collection, mismatchDescription, response);
        }

        @Override
        public IndexMatcher but(IndexMatcher other) {
            if (other instanceof LimitedToMatcher) {
                return new LimitedToMatcher((Map<String, TestIndexLike>)ImmutableMap.of((Map)this.indexNameMap).intersection(((LimitedToMatcher)other).getExpectedIndices()), this.jsonPath, this.statusCodeWhenEmpty);
            }
            if (other instanceof ContainsExactlyMatcher) {
                return new ContainsExactlyMatcher((Map<String, TestIndexLike>)ImmutableMap.of((Map)this.indexNameMap).intersection(((ContainsExactlyMatcher)other).getExpectedIndices()), false, false, this.jsonPath, this.statusCodeWhenEmpty);
            }
            if (other instanceof UnlimitedMatcher) {
                return this;
            }
            throw new RuntimeException("Unexpected argument " + other);
        }

        @Override
        public boolean covers(TestIndex testIndex) {
            return this.indexNameMap.containsKey(testIndex.getName());
        }

        @Override
        public boolean isCoveredBy(IndexMatcher other) {
            if (other instanceof LimitedToMatcher) {
                return ((LimitedToMatcher)other).getExpectedIndices().containsAll(this.getExpectedIndices());
            }
            if (other instanceof ContainsExactlyMatcher) {
                return ((ContainsExactlyMatcher)other).getExpectedIndices().containsAll(this.getExpectedIndices());
            }
            if (other instanceof UnlimitedMatcher) {
                return true;
            }
            throw new RuntimeException("Unexpected argument " + other);
        }

        protected boolean matchesByDocs(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            ImmutableSet<String> expectedIndices = this.getExpectedIndices();
            ImmutableSet.Builder seenIndicesBuilder = new ImmutableSet.Builder(expectedIndices.size());
            for (Object object : collection) {
                seenIndicesBuilder.add((Object)DocNode.wrap(object).getAsString("_index"));
            }
            ImmutableSet seenIndices = seenIndicesBuilder.build();
            ImmutableSet unexpectedIndices = seenIndices.without(expectedIndices);
            if (unexpectedIndices.isEmpty()) {
                return true;
            }
            mismatchDescription.appendText("result does contain indices that were not expected: ").appendValue((Object)unexpectedIndices).appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
            return false;
        }

        protected boolean matchesByIndices(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            ImmutableSet<String> expectedIndices = this.getExpectedIndices();
            ImmutableSet.Builder seenIndicesBuilder = new ImmutableSet.Builder(expectedIndices.size());
            for (Object object : collection) {
                seenIndicesBuilder.add((Object)object.toString());
            }
            ImmutableSet seenIndices = seenIndicesBuilder.build();
            ImmutableSet unexpectedIndices = seenIndices.without(expectedIndices);
            if (unexpectedIndices.isEmpty()) {
                return true;
            }
            mismatchDescription.appendText("result does contain indices that were not expected: ").appendValue((Object)unexpectedIndices).appendText("\n\n").appendValue((Object)IndexApiMatchers.formatResponse(response));
            return false;
        }

        private ImmutableSet<String> getExpectedIndices() {
            return ImmutableSet.of(this.indexNameMap.keySet());
        }

        @Override
        public IndexMatcher at(String jsonPath) {
            return new ContainsExactlyMatcher(this.indexNameMap, this.containsSearchGuardIndices, this.containsEsInternalIndices, jsonPath, this.statusCodeWhenEmpty);
        }

        @Override
        public IndexMatcher whenEmpty(int statusCode) {
            return new ContainsExactlyMatcher(this.indexNameMap, this.containsSearchGuardIndices, this.containsEsInternalIndices, this.jsonPath, statusCode);
        }
    }

    public static class UnlimitedMatcher
    extends DiagnosingMatcher<Object>
    implements IndexMatcher {
        private final boolean containsSearchGuardIndices;
        private final boolean containsEsInternalIndices;

        public UnlimitedMatcher() {
            this.containsSearchGuardIndices = false;
            this.containsEsInternalIndices = false;
        }

        public UnlimitedMatcher(boolean containsSearchGuardIndices, boolean containsEsInternalIndices) {
            this.containsSearchGuardIndices = containsSearchGuardIndices;
            this.containsEsInternalIndices = containsEsInternalIndices;
        }

        public void describeTo(Description description) {
            description.appendText("unlimited indices");
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            GenericRestClient.HttpResponse response;
            if (item instanceof GenericRestClient.HttpResponse && (response = (GenericRestClient.HttpResponse)item).getStatusCode() != 200) {
                mismatchDescription.appendText("Expected status code 200 but status was: ").appendValue((Object)(response.getStatusCode() + " " + response.getStatusReason()));
                return false;
            }
            return true;
        }

        @Override
        public IndexMatcher but(IndexMatcher other) {
            return other;
        }

        @Override
        public boolean isCoveredBy(IndexMatcher other) {
            return other instanceof UnlimitedMatcher;
        }

        @Override
        public IndexMatcher at(String jsonPath) {
            return this;
        }

        @Override
        public IndexMatcher whenEmpty(int statusCode) {
            return this;
        }

        @Override
        public IndexMatcher butFailIfIncomplete(IndexMatcher other, int statusCode) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsSearchGuardIndices() {
            return this.containsSearchGuardIndices;
        }

        @Override
        public boolean containsEsInternalIndices() {
            return this.containsEsInternalIndices;
        }

        @Override
        public int size() {
            throw new IllegalStateException("The UnlimitedMatcher cannot specify a size");
        }

        @Override
        public IndexMatcher aggregateTerm(String term) {
            return null;
        }

        @Override
        public boolean containsDocument(String id) {
            return true;
        }

        @Override
        public boolean covers(TestIndex testIndex) {
            return true;
        }
    }

    static class TermAggregationMatcher
    extends AbstractIndexMatcher
    implements IndexMatcher {
        private IndexMatcher base;
        private final String term;

        TermAggregationMatcher(String term, Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices, AbstractIndexMatcher base) {
            super(indexNameMap, containsSearchGuardIndices, containsEsInternalIndices);
            this.term = term;
            this.base = base;
        }

        TermAggregationMatcher(String term, Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices, String jsonPath, int statusCodeWhenEmpty, AbstractIndexMatcher base) {
            super(indexNameMap, containsSearchGuardIndices, containsEsInternalIndices, jsonPath, statusCodeWhenEmpty);
            this.term = term;
            this.base = base;
        }

        public void describeTo(Description description) {
            this.base.describeTo(description);
        }

        @Override
        protected boolean matchesImpl(Collection<?> collection, Description mismatchDescription, GenericRestClient.HttpResponse response) {
            HashMap<String, List> aggregatedDocIds = new HashMap<String, List>();
            for (TestIndexLike indexLike : this.indexNameMap.values()) {
                for (Map.Entry<String, Map<String, ?>> entry : indexLike.getDocuments().entrySet()) {
                    String id = entry.getKey();
                    Map<String, ?> doc = entry.getValue();
                    String termValue = String.valueOf(doc.get(this.term));
                    aggregatedDocIds.computeIfAbsent(termValue, k -> new ArrayList()).add(id);
                }
            }
            collection = collection.stream().flatMap(e -> e instanceof Collection ? ((Collection)e).stream() : Stream.of(e)).collect(Collectors.toSet());
            int errors = 0;
            for (Object object : collection) {
                int docCount;
                DocNode docNode = DocNode.wrap(object);
                String key = docNode.getAsString("key");
                if (key == null) {
                    mismatchDescription.appendText("Unexpected value ").appendValue((Object)docNode).appendText("\n");
                    ++errors;
                    continue;
                }
                try {
                    docCount = docNode.getNumber("doc_count").intValue();
                }
                catch (Exception e1) {
                    mismatchDescription.appendText("Error while reading ").appendValue((Object)key).appendText(" ").appendValue((Object)e1.toString()).appendText("\n");
                    ++errors;
                    continue;
                }
                List reference = (List)aggregatedDocIds.remove(key);
                if (reference == null) {
                    mismatchDescription.appendText("Unexpected key ").appendValue((Object)key).appendText("\n");
                    ++errors;
                    continue;
                }
                if (reference.size() == docCount) continue;
                mismatchDescription.appendText("doc_count mismatch for ").appendValue((Object)key).appendText("; got: ").appendValue((Object)docCount).appendText("; expected: ").appendValue((Object)reference.size());
                ++errors;
            }
            if (!aggregatedDocIds.isEmpty()) {
                for (String key : aggregatedDocIds.keySet()) {
                    mismatchDescription.appendText("Missing expected key ").appendValue((Object)key).appendText("\n");
                    ++errors;
                }
            }
            return errors == 0;
        }

        @Override
        public IndexMatcher but(IndexMatcher other) {
            AbstractIndexMatcher base = (AbstractIndexMatcher)this.base.but(other);
            return new TermAggregationMatcher(this.term, base.indexNameMap, base.containsSearchGuardIndices, base.containsEsInternalIndices, base.jsonPath, base.statusCodeWhenEmpty, base);
        }

        @Override
        public boolean isCoveredBy(IndexMatcher other) {
            return this.base.isCoveredBy(other);
        }

        @Override
        public IndexMatcher at(String jsonPath) {
            AbstractIndexMatcher base = (AbstractIndexMatcher)this.base.at(jsonPath);
            return new TermAggregationMatcher(this.term, base.indexNameMap, base.containsSearchGuardIndices, base.containsEsInternalIndices, jsonPath, base.statusCodeWhenEmpty, base);
        }

        @Override
        public IndexMatcher whenEmpty(int statusCode) {
            AbstractIndexMatcher base = (AbstractIndexMatcher)this.base.whenEmpty(statusCode);
            return new TermAggregationMatcher(this.term, base.indexNameMap, base.containsSearchGuardIndices, base.containsEsInternalIndices, base.jsonPath, statusCode, base);
        }

        @Override
        public boolean covers(TestIndex testIndex) {
            return this.base.covers(testIndex);
        }
    }

    static abstract class AbstractIndexMatcher
    extends DiagnosingMatcher<Object>
    implements IndexMatcher {
        protected final Map<String, TestIndexLike> indexNameMap;
        protected final String jsonPath;
        protected final int statusCodeWhenEmpty;
        protected final boolean containsSearchGuardIndices;
        protected final boolean containsEsInternalIndices;

        AbstractIndexMatcher(Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices) {
            this.indexNameMap = indexNameMap;
            this.jsonPath = null;
            this.statusCodeWhenEmpty = 200;
            this.containsSearchGuardIndices = containsSearchGuardIndices;
            this.containsEsInternalIndices = containsEsInternalIndices;
        }

        AbstractIndexMatcher(Map<String, TestIndexLike> indexNameMap, boolean containsSearchGuardIndices, boolean containsEsInternalIndices, String jsonPath, int statusCodeWhenEmpty) {
            this.indexNameMap = indexNameMap;
            this.jsonPath = jsonPath;
            this.statusCodeWhenEmpty = statusCodeWhenEmpty;
            this.containsSearchGuardIndices = containsSearchGuardIndices;
            this.containsEsInternalIndices = containsEsInternalIndices;
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            Configuration config;
            GenericRestClient.HttpResponse response = null;
            if (item instanceof GenericRestClient.HttpResponse) {
                response = (GenericRestClient.HttpResponse)item;
                if (this.indexNameMap.isEmpty()) {
                    if (response.getStatusCode() != this.statusCodeWhenEmpty) {
                        mismatchDescription.appendText("Status was: ").appendValue((Object)(response.getStatusCode() + " " + response.getStatusReason())).appendText("\n\n").appendText(IndexApiMatchers.formatResponse(response));
                        return false;
                    }
                    if (response.getStatusCode() != 200) {
                        return true;
                    }
                }
                try {
                    item = DocReader.json().read(((GenericRestClient.HttpResponse)item).getBody());
                }
                catch (DocumentParseException e) {
                    mismatchDescription.appendText("Unable to parse body: ").appendValue((Object)e.getMessage());
                    return false;
                }
            } else if (item instanceof DocNode) {
                item = ((DocNode)item).toDeepBasicObject();
            }
            if (this.jsonPath != null && (item = JsonPath.using((Configuration)(config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(BasicJsonPathDefaultConfiguration.JSON_PROVIDER).mappingProvider(BasicJsonPathDefaultConfiguration.MAPPING_PROVIDER).build())).parse(item).read(this.jsonPath, new Predicate[0])) == null) {
                mismatchDescription.appendText("Unable to find JSON Path: ").appendValue((Object)this.jsonPath).appendText("\n\n").appendText(IndexApiMatchers.formatResponse(response));
                return false;
            }
            if (!(item instanceof Collection)) {
                item = Collections.singleton(item);
            }
            return this.matchesImpl((Collection)item, mismatchDescription, response);
        }

        protected abstract boolean matchesImpl(Collection<?> var1, Description var2, GenericRestClient.HttpResponse var3);

        @Override
        public IndexMatcher butFailIfIncomplete(IndexMatcher other, int statusCode) {
            if (other instanceof UnlimitedMatcher) {
                return this;
            }
            HashMap<String, TestIndexLike> unmatched = new HashMap<String, TestIndexLike>(this.indexNameMap);
            unmatched.keySet().removeAll(((AbstractIndexMatcher)other).indexNameMap.keySet());
            if (!unmatched.isEmpty()) {
                return new StatusCodeMatcher(statusCode);
            }
            return this.but(other);
        }

        @Override
        public boolean isEmpty() {
            return this.indexNameMap.isEmpty();
        }

        @Override
        public int size() {
            if (!this.containsSearchGuardIndices) {
                return this.indexNameMap.size();
            }
            throw new RuntimeException("Size cannot be exactly specified because containsSearchGuardIndices is true");
        }

        @Override
        public boolean containsSearchGuardIndices() {
            return this.containsSearchGuardIndices;
        }

        @Override
        public boolean containsEsInternalIndices() {
            return this.containsEsInternalIndices;
        }

        @Override
        public IndexMatcher aggregateTerm(String term) {
            return new TermAggregationMatcher(term, this.indexNameMap, this.containsSearchGuardIndices, this.containsEsInternalIndices, this);
        }

        @Override
        public boolean containsDocument(String id) {
            for (TestIndexLike indexLike : this.indexNameMap.values()) {
                if (!indexLike.getDocumentIds().contains(id)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface IndexMatcher
    extends Matcher<Object> {
        public IndexMatcher but(IndexMatcher var1);

        public IndexMatcher butFailIfIncomplete(IndexMatcher var1, int var2);

        public IndexMatcher at(String var1);

        public IndexMatcher whenEmpty(int var1);

        public IndexMatcher aggregateTerm(String var1);

        public boolean isEmpty();

        public int size();

        public boolean isCoveredBy(IndexMatcher var1);

        default public IndexMatcher butForbiddenIfIncomplete(IndexMatcher other) {
            return this.butFailIfIncomplete(other, 403);
        }

        public boolean containsSearchGuardIndices();

        public boolean containsEsInternalIndices();

        public boolean containsDocument(String var1);

        public boolean covers(TestIndex var1);
    }

    public static class StatusCodeMatcher
    extends DiagnosingMatcher<Object>
    implements IndexMatcher {
        private int expectedStatusCode = 403;

        public StatusCodeMatcher(int expectedStatusCode) {
            this.expectedStatusCode = expectedStatusCode;
        }

        public StatusCodeMatcher withStatus(int expectedStatusCode) {
            this.expectedStatusCode = expectedStatusCode;
            return this;
        }

        @Override
        public IndexMatcher but(IndexMatcher other) {
            return this;
        }

        @Override
        public IndexMatcher at(String jsonPath) {
            return this;
        }

        @Override
        public IndexMatcher whenEmpty(int statusCode) {
            return this;
        }

        public void describeTo(Description description) {
            description.appendText("a response with status code " + this.expectedStatusCode);
        }

        @Override
        public IndexMatcher butFailIfIncomplete(IndexMatcher other, int statusCode) {
            return new StatusCodeMatcher(statusCode);
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            if (item instanceof GenericRestClient.HttpResponse) {
                GenericRestClient.HttpResponse response = (GenericRestClient.HttpResponse)item;
                if (response.getStatusCode() != this.expectedStatusCode) {
                    mismatchDescription.appendText("Status was: ").appendValue((Object)(response.getStatusCode() + " " + response.getStatusReason())).appendText("\n\n").appendText(IndexApiMatchers.formatResponse(response));
                    return false;
                }
                return true;
            }
            mismatchDescription.appendText("Did not get HttpResponse ").appendValue(item);
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsSearchGuardIndices() {
            return true;
        }

        @Override
        public boolean isCoveredBy(IndexMatcher other) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean containsEsInternalIndices() {
            return true;
        }

        @Override
        public IndexMatcher aggregateTerm(String term) {
            return null;
        }

        @Override
        public boolean containsDocument(String id) {
            return false;
        }

        @Override
        public boolean covers(TestIndex testIndex) {
            return false;
        }
    }
}

