/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.test.GenericRestClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;

public class TestData {
    private static final Logger log = LogManager.getLogger(TestData.class);
    public static final String DEFAULT_TIMESTAMP_COLUMN = "timestamp";
    public static int DEFAULT_SEED = 1234;
    public static int DEFAULT_DOCUMENT_COUNT = 300;
    public static final TestData DEFAULT;
    private static final Cache<Key, TestData> cache;
    private String[] ipAddresses;
    private String[] locationNames;
    private String[] departments = new String[]{"dept_a_1", "dept_a_2", "dept_a_3", "dept_b_1", "dept_b_2", "dept_c", "dept_d"};
    private int size;
    private int deletedDocumentCount;
    private int refreshAfter;
    private int rolloverAfter;
    private Map<String, Map<String, ?>> allDocuments;
    private Map<String, Map<String, ?>> retainedDocuments;
    private Map<String, Map<String, Map<String, ?>>> documentsByDepartment;
    private ImmutableMap<String, Object> additionalAttributes;
    private Set<String> deletedDocuments;
    private long subRandomSeed;
    private final String timestampColumn;

    public static TestData get() {
        return DEFAULT;
    }

    public static Builder documentCount(int documentCount) {
        return new Builder().documentCount(documentCount);
    }

    public TestData(int seed, int size, int deletedDocumentCount, int refreshAfter, int rolloverAfter, ImmutableMap<String, Object> additionalAttributes, String timestampColumn, Map<String, Map<String, Object>> customDocuments) {
        Random random = new Random(seed);
        this.ipAddresses = this.createRandomIpAddresses(random);
        this.locationNames = this.createRandomLocationNames(random);
        this.size = size;
        this.deletedDocumentCount = deletedDocumentCount;
        this.refreshAfter = refreshAfter;
        this.rolloverAfter = rolloverAfter;
        this.additionalAttributes = additionalAttributes;
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "Timestamp column name must not be null");
        this.createTestDocuments(random, customDocuments);
        this.subRandomSeed = random.nextLong();
    }

    private TestData(String[] ipAddresses, String[] locationNames, String[] departments, int size, int deletedDocumentCount, int refreshAfter, int rolloverAfter, Map<String, Map<String, ?>> allDocuments, Map<String, Map<String, ?>> retainedDocuments, Map<String, Map<String, Map<String, ?>>> documentsByDepartment, ImmutableMap<String, Object> additionalAttributes, Set<String> deletedDocuments, long subRandomSeed, String timestampColumn) {
        this.ipAddresses = ipAddresses;
        this.locationNames = locationNames;
        this.departments = departments;
        this.size = size;
        this.deletedDocumentCount = deletedDocumentCount;
        this.refreshAfter = refreshAfter;
        this.rolloverAfter = rolloverAfter;
        this.allDocuments = allDocuments;
        this.retainedDocuments = retainedDocuments;
        this.documentsByDepartment = documentsByDepartment;
        this.additionalAttributes = additionalAttributes;
        this.deletedDocuments = deletedDocuments;
        this.subRandomSeed = subRandomSeed;
        this.timestampColumn = timestampColumn;
    }

    public TestData withAdditionalDocument(String id, Map<String, Object> content) {
        return new TestData(this.ipAddresses, this.locationNames, this.departments, this.size, this.deletedDocumentCount, this.refreshAfter, this.rolloverAfter, (Map<String, Map<String, ?>>)ImmutableMap.of(this.allDocuments).with((Object)id, content), (Map<String, Map<String, ?>>)ImmutableMap.of(this.retainedDocuments).with((Object)id, content), this.documentsByDepartment, this.additionalAttributes, this.deletedDocuments, this.subRandomSeed, this.timestampColumn);
    }

    public String createIndex(Client client, String name, Settings settings) {
        log.info("creating test index " + name + "; size: " + this.size + "; deletedDocumentCount: " + this.deletedDocumentCount + "; refreshAfter: " + this.refreshAfter);
        Random random = new Random(this.subRandomSeed);
        long start = System.currentTimeMillis();
        client.admin().indices().create(new CreateIndexRequest(name).settings(settings).simpleMapping(new String[]{this.timestampColumn, "type=date,format=date_optional_time"})).actionGet();
        int nextRefresh = (int)Math.floor((random.nextGaussian() * 0.5 + 0.5) * (double)this.refreshAfter);
        int i = 0;
        for (Map.Entry<String, Map<String, ?>> entry : this.allDocuments.entrySet()) {
            String id = entry.getKey();
            Map<String, ?> document = entry.getValue();
            client.index(new IndexRequest(name).source(document, XContentType.JSON).id(id)).actionGet();
            if (i > nextRefresh) {
                client.admin().indices().refresh(new RefreshRequest(new String[]{name})).actionGet();
                double g = random.nextGaussian();
                nextRefresh = (int)Math.floor((g * 0.5 + 1.0) * (double)this.refreshAfter) + i + 1;
                log.debug("refresh at " + i + " " + g + " " + (g * 0.5 + 1.0));
            }
            ++i;
        }
        client.admin().indices().refresh(new RefreshRequest(new String[]{name})).actionGet();
        for (String id : this.deletedDocuments) {
            client.delete(new DeleteRequest(name, id)).actionGet();
        }
        client.admin().indices().refresh(new RefreshRequest(new String[]{name})).actionGet();
        log.info("Test index creation finished after " + (System.currentTimeMillis() - start) + " ms");
        return TestData.getIndexMode(client, name);
    }

    public String createIndex(GenericRestClient client, String indexName, Settings settings) {
        try {
            log.info("creating test index " + indexName + "; size: " + this.size + "; deletedDocumentCount: " + this.deletedDocumentCount + "; refreshAfter: " + this.refreshAfter);
            DocNode settingsDocNode = DocNode.EMPTY;
            for (String key : settings.keySet()) {
                settingsDocNode = settingsDocNode.with(key, (Object)settings.get(key));
            }
            GenericRestClient.HttpResponse response = client.putJson(indexName, (Document<?>)DocNode.of((String)"mappings.properties.timestamp", (Object)DocNode.of((String)"type", (Object)"date", (String)"format", (Object)"date_optional_time"), (String)"settings", (Object)settingsDocNode));
            if (response.getStatusCode() != 200) {
                throw new RuntimeException("Error while creating index " + indexName + "\n" + response);
            }
            this.putDocuments(client, indexName);
            return TestData.getIndexMode(client, indexName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating test index " + indexName, e);
        }
    }

    public void putDocuments(GenericRestClient client, String indexName) {
        try {
            Random random = new Random(this.subRandomSeed);
            long start = System.currentTimeMillis();
            int nextRefresh = (int)Math.floor((random.nextGaussian() * 0.5 + 0.5) * (double)this.refreshAfter);
            int nextRollover = this.rolloverAfter != -1 ? this.rolloverAfter : Integer.MAX_VALUE;
            int i = 0;
            for (Map.Entry<String, Map<String, ?>> entry : this.allDocuments.entrySet()) {
                String id = entry.getKey();
                Map<String, ?> document = entry.getValue();
                GenericRestClient.HttpResponse response = client.putJson(indexName + "/_create/" + id, (Document<?>)DocNode.wrap(document));
                if (response.getStatusCode() != 201) {
                    throw new RuntimeException("Error while creating document " + id + " in " + indexName + "\n" + response);
                }
                if (i > nextRefresh) {
                    client.post(indexName + "/_refresh");
                    double g = random.nextGaussian();
                    nextRefresh = (int)Math.floor((g * 0.5 + 1.0) * (double)this.refreshAfter) + i + 1;
                    log.debug("refresh at " + i + " " + g + " " + (g * 0.5 + 1.0));
                }
                if (i > nextRollover) {
                    response = client.post(indexName + "/_rollover/");
                    if (response.getStatusCode() != 200) {
                        throw new RuntimeException("Error while performing rollover of " + indexName + "\n" + response);
                    }
                    nextRollover += this.rolloverAfter;
                }
                ++i;
            }
            client.post(indexName + "/_refresh");
            for (String id : this.deletedDocuments) {
                client.delete(indexName + "/_doc/" + id, new Header[0]);
            }
            client.post(indexName + "/_refresh");
            log.info("Test index creation finished after " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while wring test documents to index " + indexName, e);
        }
    }

    public static String getIndexMode(Client client, String indexName) {
        return ((GetSettingsResponse)client.admin().indices().prepareGetSettings(new String[]{indexName}).get()).getSetting(indexName, "index.mode");
    }

    public static String getIndexMode(GenericRestClient client, String indexName) {
        try {
            GenericRestClient.HttpResponse response = client.get(indexName + "/_settings", new Header[0]);
            return response.getBodyAsDocNode().getAsNode(indexName).getAsNode("settings").getAsNode("index").getAsString("mode");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting index mode for " + indexName, e);
        }
    }

    private void createTestDocuments(Random random, Map<String, Map<String, Object>> customDocuments) {
        Map<String, Map<String, Object>> customDocumentsWithTestAttributes = this.addTestDocAttributesToCustomDocuments(random, customDocuments);
        HashMap<String, Object> allDocuments = new HashMap<String, Object>(this.size + customDocumentsWithTestAttributes.size());
        for (int i = 0; i < this.size; ++i) {
            ImmutableMap<String, Object> document = this.randomDocument(random);
            String id = TestData.randomId(random);
            allDocuments.put(id, document);
        }
        ArrayList createdDocIds = new ArrayList(allDocuments.keySet());
        Collections.shuffle(createdDocIds, random);
        HashSet<String> deletedDocuments = new HashSet<String>(this.deletedDocumentCount);
        HashMap<String, Map<String, Object>> retainedDocuments = new HashMap<String, Map<String, Object>>(allDocuments);
        for (int i = 0; i < this.deletedDocumentCount; ++i) {
            String id = (String)createdDocIds.get(i);
            deletedDocuments.add(id);
            retainedDocuments.remove(id);
        }
        allDocuments.putAll(customDocumentsWithTestAttributes);
        retainedDocuments.putAll(customDocumentsWithTestAttributes);
        HashMap documentsByDepartment = new HashMap();
        for (Map.Entry entry : retainedDocuments.entrySet()) {
            String dept = (String)((Map)entry.getValue()).get("dept");
            documentsByDepartment.computeIfAbsent(dept, k -> new HashMap()).put((String)entry.getKey(), (Map)entry.getValue());
        }
        this.allDocuments = Collections.unmodifiableMap(allDocuments);
        this.retainedDocuments = Collections.unmodifiableMap(retainedDocuments);
        this.deletedDocuments = Collections.unmodifiableSet(deletedDocuments);
        this.documentsByDepartment = documentsByDepartment;
    }

    private String[] createRandomIpAddresses(Random random) {
        String[] result = new String[2000];
        for (int i = 0; i < result.length; ++i) {
            result[i] = random.nextInt(10) + 100 + "." + (random.nextInt(5) + 100) + "." + random.nextInt(255) + "." + random.nextInt(255);
        }
        return result;
    }

    private String[] createRandomLocationNames(Random random) {
        String[] p1 = new String[]{"Sch\u00f6n", "Sch\u00f6ner", "Tempel", "Friedens", "Friedrichs", "Blanken", "Rosen", "Charlotten", "Malch", "Lichten", "Lichter", "Hasel", "Kreuz", "Pank", "Marien", "Adlers", "Zehlen", "Haken", "Witten", "Jungfern", "Hellers", "Finster", "Birken", "Falken", "Freders", "Karls", "Gr\u00fcn", "Wilmers", "Heiners", "Lieben", "Marien", "Wiesen", "Biesen", "Schmachten", "Rahns", "Rangs", "Herms", "R\u00fcders", "Wuster", "Hoppe"};
        String[] p2 = new String[]{"au", "ow", "berg", "feld", "felde", "tal", "thal", "h\u00f6he", "burg", "horst", "hausen", "dorf", "hof", "heide", "weide", "hain", "walde", "linde", "hagen", "eiche", "witz", "rade", "werder", "see", "flie\u00df", "krug", "mark"};
        ArrayList<CallSite> result = new ArrayList<CallSite>(p1.length * p2.length);
        for (int i = 0; i < p1.length; ++i) {
            for (int k = 0; k < p2.length; ++k) {
                result.add((CallSite)((Object)(p1[i] + p2[k])));
            }
        }
        Collections.shuffle(result, random);
        return result.toArray(new String[result.size()]);
    }

    private ImmutableMap<String, Object> randomDocument(Random random) {
        return ImmutableMap.of((Object)"source_ip", (Object)this.randomIpAddress(random), (Object)"dest_ip", (Object)this.randomIpAddress(random), (Object)"source_loc", (Object)this.randomLocationName(random), (Object)"dest_loc", (Object)this.randomLocationName(random), (Object)"dept", (Object)this.randomDepartmentName(random)).with((Object)this.timestampColumn, (Object)this.randomTimestamp(random)).with(Optional.ofNullable(this.additionalAttributes).orElse((ImmutableMap<String, Object>)ImmutableMap.empty()));
    }

    private Map<String, Map<String, Object>> addTestDocAttributesToCustomDocuments(Random random, Map<String, Map<String, Object>> customDocuments) {
        HashMap<String, Map<String, Object>> customDocsWithTestAttributes = new HashMap<String, Map<String, Object>>(customDocuments.size());
        customDocuments.forEach((customDocId, customDocSource) -> {
            ImmutableMap customDocWithTestAttributes = this.randomDocument(random).with(ImmutableMap.of((Map)customDocSource));
            customDocsWithTestAttributes.put((String)customDocId, (Map<String, Object>)customDocWithTestAttributes);
        });
        return customDocsWithTestAttributes;
    }

    private String randomIpAddress(Random random) {
        return this.ipAddresses[random.nextInt(this.ipAddresses.length)];
    }

    private String randomLocationName(Random random) {
        int i = (int)Math.floor(random.nextGaussian() * (double)this.locationNames.length * 0.333 + (double)this.locationNames.length);
        if (i < 0 || i >= this.locationNames.length) {
            i = random.nextInt(this.locationNames.length);
        }
        return this.locationNames[i];
    }

    private String randomDepartmentName(Random random) {
        return this.departments[random.nextInt(this.departments.length)];
    }

    private String randomTimestamp(Random random) {
        long epochMillis = random.longs(1L, -2857691960709L, 2857691960709L).findFirst().getAsLong();
        return Instant.ofEpochMilli(epochMillis).toString();
    }

    private static String randomId(Random random) {
        UUID uuid = new UUID(random.nextLong(), random.nextLong());
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return Base64.getUrlEncoder().encodeToString(byteBuffer.array()).replace("=", "");
    }

    public int getSize() {
        return this.size - this.deletedDocumentCount;
    }

    public int getDeletedDocumentCount() {
        return this.deletedDocumentCount;
    }

    public Map<String, Map<String, ?>> getAllDocuments() {
        return this.allDocuments;
    }

    public Map<String, Map<String, ?>> getRetainedDocuments() {
        return this.retainedDocuments;
    }

    public Set<String> getDeletedDocuments() {
        return this.deletedDocuments;
    }

    public TestDocument anyDocument() {
        Map.Entry<String, Map<String, ?>> entry = this.retainedDocuments.entrySet().iterator().next();
        return new TestDocument(entry.getKey(), entry.getValue());
    }

    public TestDocument anyDocumentForDepartment(String dept) {
        Map<String, Map<String, ?>> docs = this.documentsByDepartment.get(dept);
        if (docs == null) {
            return null;
        }
        Map.Entry<String, Map<String, ?>> entry = docs.entrySet().iterator().next();
        return new TestDocument(entry.getKey(), entry.getValue());
    }

    static {
        cache = CacheBuilder.newBuilder().softValues().initialCapacity(3).build();
        DEFAULT = TestData.documentCount(DEFAULT_DOCUMENT_COUNT).get();
    }

    public static class Builder {
        private int seed = DEFAULT_SEED;
        private int size = DEFAULT_DOCUMENT_COUNT;
        private int deletedDocumentCount = -1;
        private double deletedDocumentFraction = 0.06;
        private int refreshAfter = -1;
        private int rolloverAfter = -1;
        private int segmentCount = 17;
        private Map<String, Object> additionalAttributes = new HashMap<String, Object>();
        private String timestampColumnName = "timestamp";
        private Map<String, Map<String, Object>> customDocuments = new HashMap<String, Map<String, Object>>();

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder documentCount(int size) {
            this.size = size;
            return this;
        }

        public Builder deletedDocumentCount(int deletedDocumentCount) {
            this.deletedDocumentCount = deletedDocumentCount;
            return this;
        }

        public Builder refreshAfter(int refreshAfter) {
            this.refreshAfter = refreshAfter;
            return this;
        }

        public Builder rolloverAfter(int rolloverAfter) {
            this.rolloverAfter = rolloverAfter;
            return this;
        }

        public Builder deletedDocumentFraction(double deletedDocumentFraction) {
            this.deletedDocumentFraction = deletedDocumentFraction;
            return this;
        }

        public Builder segmentCount(int segmentCount) {
            this.segmentCount = segmentCount;
            return this;
        }

        public Builder attr(String name, Object value) {
            this.additionalAttributes.put(name, value);
            return this;
        }

        public Builder timestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
            return this;
        }

        public Builder customDocument(String id, Map<String, Object> source) {
            this.customDocuments.put(id, source);
            return this;
        }

        public Key toKey() {
            if (this.deletedDocumentCount == -1) {
                this.deletedDocumentCount = (int)((double)this.size * this.deletedDocumentFraction);
            }
            if (this.refreshAfter == -1) {
                this.refreshAfter = this.size / this.segmentCount;
            }
            return new Key(this.seed, this.size, this.deletedDocumentCount, this.refreshAfter, (ImmutableMap<String, Object>)ImmutableMap.of(this.additionalAttributes), this.timestampColumnName, (ImmutableMap<String, Map<String, Object>>)ImmutableMap.of(this.customDocuments));
        }

        public TestData get() {
            Key key = this.toKey();
            try {
                return (TestData)cache.get((Object)key, () -> new TestData(this.seed, this.size, this.deletedDocumentCount, this.refreshAfter, this.rolloverAfter, (ImmutableMap<String, Object>)ImmutableMap.of(this.additionalAttributes), key.timestampColumnName, (Map<String, Map<String, Object>>)ImmutableMap.of(this.customDocuments)));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TestDocument {
        private final String id;
        private final Map<String, ?> content;

        TestDocument(String id, Map<String, ?> content) {
            this.id = id;
            this.content = content;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, ?> getContent() {
            return this.content;
        }

        public String getUri(String index) {
            return "/" + index + "/_doc/" + this.id;
        }
    }

    private static class Key {
        private final int seed;
        private final int size;
        private final int deletedDocumentCount;
        private final int refreshAfter;
        private final ImmutableMap<String, Object> additionalAttributes;
        private final String timestampColumnName;
        private final ImmutableMap<String, Map<String, Object>> customDocuments;

        public Key(int seed, int size, int deletedDocumentCount, int refreshAfter, ImmutableMap<String, Object> additionalAttributes, String timestampColumnName, ImmutableMap<String, Map<String, Object>> customDocuments) {
            this.seed = seed;
            this.size = size;
            this.deletedDocumentCount = deletedDocumentCount;
            this.refreshAfter = refreshAfter;
            this.additionalAttributes = additionalAttributes;
            this.timestampColumnName = Objects.requireNonNull(timestampColumnName);
            this.customDocuments = customDocuments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.deletedDocumentCount;
            result = 31 * result + this.refreshAfter;
            result = 31 * result + this.seed;
            result = 31 * result + this.size;
            result = 31 * result + this.additionalAttributes.hashCode();
            result = 31 * result + this.timestampColumnName.hashCode();
            result = 31 * result + this.customDocuments.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.deletedDocumentCount != other.deletedDocumentCount) {
                return false;
            }
            if (this.refreshAfter != other.refreshAfter) {
                return false;
            }
            if (this.seed != other.seed) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (!this.additionalAttributes.equals(other.additionalAttributes)) {
                return false;
            }
            if (!this.timestampColumnName.equals(other.timestampColumnName)) {
                return false;
            }
            return this.customDocuments.equals(other.customDocuments);
        }
    }
}

