/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestData;
import com.floragunn.searchguard.test.TestIndexLike;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;

public class TestIndex
implements TestIndexLike {
    private final String name;
    private final Settings settings;
    private final TestData testData;

    public TestIndex(String name, Settings settings, TestData testData) {
        this.name = name;
        this.settings = settings;
        this.testData = testData;
    }

    public void create(Client client) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        try (ThreadContext.StoredContext stored = threadContext.newStoredContext();){
            threadContext.putHeader("_system_index_access_allowed", "true");
            try {
                client.admin().indices().getIndex((GetIndexRequest)new GetIndexRequest().indices(new String[]{this.name})).actionGet();
            }
            catch (IndexNotFoundException e) {
                this.testData.createIndex(client, this.name, this.settings);
            }
        }
    }

    public void create(GenericRestClient client) throws Exception {
        GenericRestClient.HttpResponse response = client.head(this.name, new Header[0]);
        if (response.getStatusCode() == 200) {
            return;
        }
        this.testData.createIndex(client, this.name, this.settings);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "TestIndex '" + this.name + "'";
    }

    public TestData getTestData() {
        return this.testData;
    }

    public TestIndex withAdditionalDocument(String id, DocNode docNode) {
        return new TestIndex(this.name, this.settings, this.testData.withAdditionalDocument(id, (Map<String, Object>)docNode.toMap()));
    }

    public static Builder name(String name) {
        return new Builder().name(name);
    }

    @Override
    public Set<String> getDocumentIds() {
        return this.getTestData().getRetainedDocuments().keySet();
    }

    @Override
    public Map<String, Map<String, ?>> getDocuments() {
        return this.getTestData().getRetainedDocuments();
    }

    public static class Builder {
        private String name;
        private Settings.Builder settings = Settings.builder();
        private TestData.Builder testDataBuilder = new TestData.Builder();
        private TestData testData;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder setting(String name, int value) {
            this.settings.put(name, value);
            return this;
        }

        public Builder shards(int value) {
            this.settings.put("index.number_of_shards", 5);
            return this;
        }

        public Builder hidden() {
            this.settings.put("index.hidden", true);
            return this;
        }

        public Builder data(TestData data) {
            this.testData = data;
            return this;
        }

        public Builder seed(int seed) {
            this.testDataBuilder.seed(seed);
            return this;
        }

        public Builder documentCount(int size) {
            this.testDataBuilder.documentCount(size);
            return this;
        }

        public Builder deletedDocumentCount(int deletedDocumentCount) {
            this.testDataBuilder.deletedDocumentCount(deletedDocumentCount);
            return this;
        }

        public Builder refreshAfter(int refreshAfter) {
            this.testDataBuilder.refreshAfter(refreshAfter);
            return this;
        }

        public Builder deletedDocumentFraction(double deletedDocumentFraction) {
            this.testDataBuilder.deletedDocumentFraction(deletedDocumentFraction);
            return this;
        }

        public Builder segmentCount(int segmentCount) {
            this.testDataBuilder.segmentCount(segmentCount);
            return this;
        }

        public Builder attr(String name, Object value) {
            this.testDataBuilder.attr(name, value);
            return this;
        }

        public Builder customDocument(String id, Map<String, Object> source) {
            this.testDataBuilder.customDocument(id, source);
            return this;
        }

        public TestIndex build() {
            if (this.testData == null) {
                this.testData = this.testDataBuilder.get();
            }
            return new TestIndex(this.name, this.settings.build(), this.testData);
        }
    }
}

