/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate;

import com.floragunn.searchguard.test.helper.certificate.CertificateType;
import com.floragunn.searchguard.test.helper.certificate.utils.CertificateAndPrivateKeyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TestCertificate {
    private static final Provider DEFAULT_SECURITY_PROVIDER = new BouncyCastleProvider();
    private final X509CertificateHolder certificate;
    private final KeyPair keyPair;
    private final String privateKeyPassword;
    private final File certificateFile;
    private final File privateKeyFile;
    private final CertificateType certificateType;
    private final File directory;
    private String certificateString;
    private File jksFile;

    public TestCertificate(X509CertificateHolder certificate, KeyPair keyPair, String privateKeyPassword, CertificateType certificateType, File directory) {
        this.certificate = certificate;
        this.keyPair = keyPair;
        this.privateKeyPassword = privateKeyPassword;
        this.certificateType = certificateType;
        this.directory = directory;
        switch (certificateType) {
            case ca: {
                this.certificateFile = new File(directory, "ca.pem");
                this.privateKeyFile = new File(directory, "ca-key.pem");
                break;
            }
            case admin_client: {
                this.certificateFile = new File(directory, String.format("admin-client-%s.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("admin-client-%s-key.pem", certificate.getSubject()));
                break;
            }
            case client: {
                this.certificateFile = new File(directory, String.format("client-%s.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("client-%s-key.pem", certificate.getSubject()));
                break;
            }
            case node_rest: {
                this.certificateFile = new File(directory, String.format("node-%s-rest.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("node-%s-rest-key.pem", certificate.getSubject()));
                break;
            }
            case node_transport: {
                this.certificateFile = new File(directory, String.format("node-%s-transport.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("node-%s-transport-key.pem", certificate.getSubject()));
                break;
            }
            case node_transport_rest: {
                this.certificateFile = new File(directory, String.format("node-%s-transport-rest.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("node-%s-transport-rest-key.pem", certificate.getSubject()));
                break;
            }
            case other: {
                this.certificateFile = new File(directory, String.format("cert-%s.pem", certificate.getSubject()));
                this.privateKeyFile = new File(directory, String.format("cert-%s-key.pem", certificate.getSubject()));
                break;
            }
            default: {
                throw new RuntimeException("Not supported");
            }
        }
        this.certificateString = CertificateAndPrivateKeyWriter.writeCertificate(certificate);
        CertificateAndPrivateKeyWriter.saveCertificate(this.certificateFile, certificate);
        CertificateAndPrivateKeyWriter.savePrivateKey(this.privateKeyFile, keyPair.getPrivate(), privateKeyPassword);
    }

    public X509CertificateHolder getCertificate() {
        return this.certificate;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public String getCertificateString() {
        return this.certificateString;
    }

    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public CertificateType getCertificateType() {
        return this.certificateType;
    }

    public File getJksFile() {
        if (this.jksFile == null) {
            this.jksFile = this.saveAsJksFile();
        }
        return this.jksFile;
    }

    public TestCertificate at(File directory) {
        return new TestCertificate(this.certificate, this.keyPair, this.privateKeyPassword, this.certificateType, directory);
    }

    private File saveAsJksFile() {
        try {
            File file = new File(this.directory, String.format("cert-%s.pem", this.certificate.getSubject()));
            X509Certificate x509certificate = new JcaX509CertificateConverter().setProvider(DEFAULT_SECURITY_PROVIDER).getCertificate(this.certificate);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            keyStore.setKeyEntry("cert", this.keyPair.getPrivate(), this.privateKeyPassword.toCharArray(), new X509Certificate[]{x509certificate});
            keyStore.store(new FileOutputStream(file), this.privateKeyPassword.toCharArray());
            return file;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

