/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.certificate.utils;

import com.google.common.base.Strings;
import java.util.function.Function;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;

@FunctionalInterface
public interface DnGenerator
extends Function<String, X500Name> {
    public static final DnGenerator rootDn = dn -> DnGenerator.createDn(dn, "root");
    public static final DnGenerator nodeDn = dn -> DnGenerator.createDn(dn, "node");
    public static final DnGenerator clientDn = dn -> DnGenerator.createDn(dn, "client");

    public static X500Name createDn(String dn, String role) {
        if (Strings.isNullOrEmpty((String)dn)) {
            throw new RuntimeException(String.format("No DN specified for %s certificate", role));
        }
        try {
            return new X500Name(RFC4519Style.INSTANCE, dn);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Invalid DN specified for %s certificate: %s", role, dn), e);
        }
    }
}

