/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.client.RestHighLevelClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.certificate.TestCertificate;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.SSLContextProvider;
import com.floragunn.searchguard.test.helper.cluster.TestCertificateBasedSSLContextProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public interface EsClientProvider {
    public String getClusterName();

    public TestCertificates getTestCertificates();

    public InetSocketAddress getHttpAddress();

    public InetSocketAddress getTransportAddress();

    default public URI getHttpAddressAsURI() {
        InetSocketAddress address = this.getHttpAddress();
        return URI.create("https://" + address.getHostString() + ":" + address.getPort());
    }

    default public SSLContextProvider getAdminClientSslContextProvider() {
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), this.getTestCertificates().getAdminCertificate());
    }

    default public SSLContextProvider getUserClientSslContextProvider(String subjectDistinguishedName) {
        TestCertificate userCertificate = this.getTestCertificates().create(subjectDistinguishedName);
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), userCertificate);
    }

    default public SSLContextProvider getAnyClientSslContextProvider() {
        return new TestCertificateBasedSSLContextProvider(this.getTestCertificates().getCaCertificate(), this.getTestCertificates().getAnyClientCertificate());
    }

    default public GenericRestClient getRestClient(UserCredentialsHolder user, Header ... headers) {
        ImmutableList headersList = ImmutableList.ofArray((Object[])headers);
        if (user.isAdminCertUser()) {
            return this.getAdminCertRestClient(user, (List<Header>)headersList);
        }
        return this.getRestClient(user, (List<Header>)headersList.with((Object)this.getBasicAuthHeader(user.getName(), user.getPassword())));
    }

    default public GenericRestClient getRestClient(String user, String password, String tenant) {
        return this.getRestClient(user, password, new Header[]{new BasicHeader("sgtenant", tenant)});
    }

    default public GenericRestClient getRestClient(String user, String password, Header ... headers) {
        return this.getRestClient(UserCredentialsHolder.basic(user, password), headers);
    }

    default public GenericRestClient getRestClient(Header ... headers) {
        return this.getRestClient(null, Arrays.asList(headers));
    }

    default public GenericRestClient getRestClient(UserCredentialsHolder user, List<Header> headers) {
        return new GenericRestClient(this.getHttpAddress(), headers, this.getAnyClientSslContextProvider().getSslContext(false), user, this.getRequestInfoConsumer());
    }

    default public GenericRestClient getAdminCertRestClient() {
        return this.getAdminCertRestClient(UserCredentialsHolder.ADMIN, (List<Header>)ImmutableList.empty());
    }

    default public GenericRestClient getAdminCertRestClient(UserCredentialsHolder user, List<Header> headers) {
        return new GenericRestClient(this.getHttpAddress(), headers, this.getAdminClientSslContextProvider().getSslContext(true), user, this.getRequestInfoConsumer());
    }

    default public GenericRestClient getUserCertRestClient(String subject, Header ... headers) {
        SSLContext sslContext = this.getUserClientSslContextProvider(subject).getSslContext(true);
        return new GenericRestClient(this.getHttpAddress(), Arrays.asList(headers), sslContext, UserCredentialsHolder.basic(subject, null), this.getRequestInfoConsumer());
    }

    @Deprecated
    default public RestHighLevelClient getRestHighLevelClient(UserCredentialsHolder user) {
        return this.getRestHighLevelClient(user.getName(), user.getPassword());
    }

    @Deprecated
    default public RestHighLevelClient getRestHighLevelClient(String user, String password) {
        return this.getRestHighLevelClient(user, password, null);
    }

    @Deprecated
    default public RestHighLevelClient getRestHighLevelClient(String user, String password, String tenant) {
        InetSocketAddress httpAddress = this.getHttpAddress();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        RestClientBuilder.HttpClientConfigCallback configCallback = arg_0 -> this.lambda$getRestHighLevelClient$1((CredentialsProvider)credentialsProvider, tenant, arg_0);
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(httpAddress.getHostString(), httpAddress.getPort(), "https")}).setHttpClientConfigCallback(configCallback);
        return new RestHighLevelClient(builder);
    }

    @Deprecated
    default public RestHighLevelClient getRestHighLevelClient(Header ... headers) {
        InetSocketAddress httpAddress = this.getHttpAddress();
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(httpAddress.getHostString(), httpAddress.getPort(), "https")}).setDefaultHeaders(headers).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(this.getAnyClientSslContextProvider().getSslContext(false), null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)));
        return new RestHighLevelClient(builder);
    }

    default public RestClientBuilder getLowLevelRestClientBuilder(Header ... headers) {
        InetSocketAddress httpAddress = this.getHttpAddress();
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(httpAddress.getHostString(), httpAddress.getPort(), "https")}).setDefaultHeaders(headers).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(this.getAnyClientSslContextProvider().getSslContext(false), null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)));
    }

    default public RestClient getLowLevelRestClient(Header ... headers) {
        return this.getLowLevelRestClientBuilder(headers).build();
    }

    default public BasicHeader getBasicAuthHeader(String user, String password) {
        return new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((user + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    public Consumer<GenericRestClient.RequestInfo> getRequestInfoConsumer();

    private /* synthetic */ HttpAsyncClientBuilder lambda$getRestHighLevelClient$1(CredentialsProvider credentialsProvider, String tenant, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(this.getAnyClientSslContextProvider().getSslContext(false), null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        if (tenant != null) {
            httpClientBuilder.addInterceptorLast((request, context) -> request.setHeader("sgtenant", tenant));
        }
        return httpClientBuilder;
    }

    public static interface UserCredentialsHolder {
        public static final UserCredentialsHolder ADMIN = new UserCredentialsHolder(){

            @Override
            public String getName() {
                return "<admin cert user>";
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public boolean isAdminCertUser() {
                return true;
            }

            public String toString() {
                return this.getName();
            }
        };

        public String getName();

        public String getPassword();

        default public boolean isAdminCertUser() {
            return false;
        }

        public static UserCredentialsHolder basic(final String name, final String password) {
            return new UserCredentialsHolder(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getPassword() {
                    return password;
                }

                public String toString() {
                    return this.getName();
                }
            };
        }
    }
}

