/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.test.helper.cluster.EsInstallation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EsDownload {
    private static final Logger log = LogManager.getLogger(EsDownload.class);
    private static final Map<String, EsDownload> instancesByVersion = Collections.synchronizedMap(new HashMap());
    private static final ExecutorService executorService = new ThreadPoolExecutor(0, 12, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
    private final String esVersion;

    static EsDownload get(String version) {
        return instancesByVersion.computeIfAbsent(version, k -> new EsDownload(version));
    }

    EsDownload(String esVersion) {
        this.esVersion = esVersion;
    }

    synchronized File getReleaseArchive() throws EsInstallationUnavailableException {
        File downloadFile;
        block9: {
            String esArchive;
            File downloadDirectory = System.getProperty("sg.tests.es_download_cache.dir") != null ? new File(System.getProperty("sg.tests.es_download_cache.dir")) : new File(FileUtils.getUserDirectory(), "searchguard-test/download-cache/");
            if (!downloadDirectory.exists()) {
                downloadDirectory.mkdirs();
            }
            String os = System.getProperty("os.name").toLowerCase();
            String arch = System.getProperty("os.arch").toLowerCase();
            if (arch.equals("amd64")) {
                arch = "x86_64";
            }
            if (!(downloadFile = new File(downloadDirectory, esArchive = "elasticsearch-" + this.esVersion + "-" + os + "-" + arch + ".tar.gz")).exists()) {
                try {
                    URL url = new URL("https://artifacts.elastic.co/downloads/elasticsearch/" + esArchive);
                    long start = System.currentTimeMillis();
                    try {
                        log.info("Downloading {}", (Object)url);
                        FileUtils.copyURLToFile((URL)url, (File)downloadFile);
                        log.info("Downloading {} took {} seconds", (Object)url, (Object)((System.currentTimeMillis() - start) / 1000L));
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break block9;
                    }
                    catch (IOException e) {
                        throw new EsInstallationUnavailableException("Error while downloading " + url, e);
                    }
                }
                catch (MalformedURLException e) {
                    throw new EsInstallationUnavailableException(e);
                }
            }
            log.info("Using {}", (Object)downloadFile);
        }
        return downloadFile;
    }

    EsInstallation extract(File targetDir) throws EsInstallationUnavailableException {
        return this.extract(targetDir, 0);
    }

    CompletableFuture<EsInstallation> extractAsync(File targetDir) {
        CompletableFuture<EsInstallation> future = new CompletableFuture<EsInstallation>();
        executorService.submit(() -> {
            try {
                future.complete(this.extract(targetDir));
            }
            catch (EsInstallationUnavailableException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private EsInstallation extract(File targetDir, int retry) throws EsInstallationUnavailableException {
        File releaseArchive = this.getReleaseArchive();
        targetDir.mkdirs();
        try {
            log.info("Extracting {} to {}", (Object)releaseArchive, (Object)targetDir);
            long start = System.currentTimeMillis();
            Process process = Runtime.getRuntime().exec(new String[]{"tar", "xfz", releaseArchive.getAbsolutePath(), "-C", targetDir.getAbsolutePath(), "--strip-components", "1"});
            StringBuilder result = new StringBuilder();
            executorService.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(l -> result.append((String)l).append("\n")));
            executorService.submit(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(l -> result.append((String)l).append("\n")));
            int rc = process.waitFor();
            if (rc != 0) {
                log.error("Command failed with rc {}\n{}", (Object)rc, (Object)result);
                if (result.indexOf("Unexpected EOF in archive") != -1) {
                    if (retry <= 3) {
                        releaseArchive.delete();
                        return this.extract(targetDir, retry + 1);
                    }
                    throw new Exception("Invalid archive: Unexpected EOF");
                }
                throw new Exception("Command failed with rc " + rc);
            }
            log.info("Extracting {} took {} seconds", (Object)releaseArchive, (Object)((System.currentTimeMillis() - start) / 1000L));
            return new EsInstallation(targetDir, this.esVersion, executorService);
        }
        catch (Exception e) {
            throw new EsInstallationUnavailableException("Error while extracting " + releaseArchive, e);
        }
    }

    static class EsInstallationUnavailableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        EsInstallationUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }

        EsInstallationUnavailableException(String message) {
            super(message);
        }

        EsInstallationUnavailableException(Throwable cause) {
            super(cause);
        }
    }
}

