/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.FilePermissionUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.jdk.JarHell;

public class EsJavaSecurity {
    static Policy getBaseEsSecurityPolicy() {
        return EsJavaSecurity.readPolicy(BootstrapInfo.class.getResource("security.policy"), EsJavaSecurity.getCodebases());
    }

    static Policy getSgPluginSecurityPolicy() {
        return EsJavaSecurity.readPolicy(EsJavaSecurity.class.getResource("/sg-plugin-security.policy"), EsJavaSecurity.getCodebases());
    }

    @SuppressForbidden(reason="find URL path")
    static Map<String, URL> getCodebaseJarMap(Set<URL> urls) {
        LinkedHashMap<String, URL> codebases = new LinkedHashMap<String, URL>();
        for (URL url : urls) {
            try {
                String fileName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                if (!fileName.endsWith(".jar")) continue;
                codebases.put(fileName, url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return codebases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, Map<String, URL> codebases) {
        Policy policy;
        ArrayList<CallSite> propertiesSet = new ArrayList<CallSite>();
        try {
            for (Map.Entry<String, URL> codebase : codebases.entrySet()) {
                String string = codebase.getKey();
                URL url = codebase.getValue();
                String property = "codebase." + string;
                String aliasProperty = "codebase." + string.replaceFirst("-\\d+\\.\\d+.*\\.jar", "");
                if (!aliasProperty.equals(property)) {
                    propertiesSet.add((CallSite)((Object)aliasProperty));
                    System.setProperty(aliasProperty, url.toString());
                }
                propertiesSet.add((CallSite)((Object)property));
                System.setProperty(property, url.toString());
            }
            policy = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
        }
        catch (Throwable throwable) {
            try {
                for (String string : propertiesSet) {
                    System.clearProperty(string);
                }
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", e);
            }
        }
        for (String string : propertiesSet) {
            System.clearProperty(string);
        }
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Permissions getClasspathPermissions() {
        try {
            Permissions perms = new Permissions();
            for (URL url : JarHell.parseClassPath()) {
                Path path;
                try {
                    path = PathUtils.get((URI)url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"class.path", (Path)path, (String)"read,readlink", (boolean)false);
                    continue;
                }
                FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)path, (String)"read,readlink");
            }
            return perms;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Permissions getMiscPermissions() {
        try {
            Permissions perms = new Permissions();
            Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
            FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"java.io.tmpdir", (Path)javaTmpDir, (String)"read,readlink,write,delete", (boolean)false);
            perms.add(new RuntimePermission("getStackWalkerWithClassReference"));
            return perms;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, URL> getCodebases() {
        Map<String, URL> codebases = EsJavaSecurity.getCodebaseJarMap(JarHell.parseClassPath());
        EsJavaSecurity.addClassCodebase(codebases, "elasticsearch", "org.elasticsearch.plugins.PluginsService");
        if (System.getProperty("tests.gradle") == null) {
            EsJavaSecurity.addClassCodebase(codebases, "plugin-classloader", "org.elasticsearch.plugins.ExtendedPluginsClassLoader");
            EsJavaSecurity.addClassCodebase(codebases, "elasticsearch-nio", "org.elasticsearch.nio.ChannelFactory");
            EsJavaSecurity.addClassCodebase(codebases, "elasticsearch-secure-sm", "org.elasticsearch.secure_sm.SecureSM");
            EsJavaSecurity.addClassCodebase(codebases, "elasticsearch-rest-client", "org.elasticsearch.client.RestClient");
        }
        return codebases;
    }

    private static void addClassCodebase(Map<String, URL> codebases, String name, String classname) {
        try {
            Class<?> clazz = EsJavaSecurity.class.getClassLoader().loadClass(classname);
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (!location.toString().endsWith(".jar") && codebases.put(name, location) != null) {
                throw new IllegalStateException("Already added " + name + " codebase for testing");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

