/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.PortAllocator;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public abstract class LocalEsCluster {
    private static final Logger log = LogManager.getLogger(LocalEsCluster.class);
    protected final String clusterName;
    protected final ClusterConfiguration clusterConfiguration;
    protected final NodeSettingsSupplier nodeSettingsSupplier;
    protected final TestCertificates testCertificates;
    protected final File clusterHomeDir;
    protected final Random random = new Random();
    protected List<String> seedHosts;
    protected List<String> initialMasterHosts;
    protected int retry = 0;
    protected boolean started;
    protected boolean portCollisionDetected = false;

    public LocalEsCluster(String clusterName, ClusterConfiguration clusterConfiguration, NodeSettingsSupplier nodeSettingsSupplier, TestCertificates testCertificates) {
        this.clusterName = clusterName;
        this.clusterConfiguration = clusterConfiguration;
        this.nodeSettingsSupplier = nodeSettingsSupplier;
        this.clusterHomeDir = FileHelper.createTempDirectory("sg_local_cluster_" + clusterName);
        this.clusterHomeDir.deleteOnExit();
        this.testCertificates = testCertificates;
    }

    public abstract boolean isStarted();

    public abstract void destroy();

    public abstract List<? extends Node> getAllNodes();

    public abstract List<? extends Node> clientNodes();

    public abstract List<? extends Node> dataNodes();

    public abstract List<? extends Node> masterNodes();

    public abstract void waitForGreenCluster() throws Exception;

    protected abstract CompletableFuture<? extends Node> startNode(ClusterConfiguration.NodeSettings var1, int var2, int var3);

    protected abstract void destroyNodes();

    public Node getNodeByName(String name) {
        return this.getAllNodes().stream().filter(node -> node.getNodeName().equals(name)).findAny().orElseThrow(() -> new RuntimeException("No such node with name: " + name + "; available: " + this.getAllNodes().stream().map(Node::getNodeName).collect(Collectors.toList())));
    }

    public void start() throws Exception {
        log.info("Starting {}", (Object)this.clusterName);
        this.portCollisionDetected = false;
        int forkNumber = LocalEsCluster.getUnitTestForkNumber();
        int masterNodeCount = this.clusterConfiguration.getMasterNodes();
        int nonMasterNodeCount = this.clusterConfiguration.getDataNodes() + this.clusterConfiguration.getClientNodes();
        SortedSet<Integer> masterNodeTransportPorts = PortAllocator.TCP.allocate(this.clusterName, Math.max(masterNodeCount, 4), 5000 + forkNumber * 1000 + 300);
        SortedSet<Integer> masterNodeHttpPorts = PortAllocator.TCP.allocate(this.clusterName, masterNodeCount, 5000 + forkNumber * 1000 + 200);
        this.seedHosts = LocalEsCluster.toHostList(masterNodeTransportPorts);
        this.initialMasterHosts = LocalEsCluster.toHostList(masterNodeTransportPorts.stream().limit(masterNodeCount).collect(Collectors.toSet()));
        this.started = true;
        CompletableFuture<Void> masterNodeFuture = this.startNodes(this.clusterConfiguration.getMasterNodeSettings(), masterNodeTransportPorts, masterNodeHttpPorts);
        SortedSet<Integer> nonMasterNodeTransportPorts = PortAllocator.TCP.allocate(this.clusterName, nonMasterNodeCount, 5000 + forkNumber * 1000 + 310);
        SortedSet<Integer> nonMasterNodeHttpPorts = PortAllocator.TCP.allocate(this.clusterName, nonMasterNodeCount, 5000 + forkNumber * 1000 + 210);
        CompletableFuture<Void> nonMasterNodeFuture = this.startNodes(this.clusterConfiguration.getNonMasterNodeSettings(), nonMasterNodeTransportPorts, nonMasterNodeHttpPorts);
        try {
            CompletableFuture.allOf(masterNodeFuture, nonMasterNodeFuture).get();
        }
        catch (ExecutionException e) {
            if (this.portCollisionDetected) {
                log.info("Detected port collision. Retrying.");
                this.retry();
                return;
            }
            throw new Exception("Error while starting cluster " + this, e.getCause());
        }
        log.info("Startup finished. Waiting for GREEN");
        this.waitForGreenCluster();
        log.info("Started: {}", (Object)this);
    }

    protected CompletableFuture<Void> startNodes(List<ClusterConfiguration.NodeSettings> nodeSettingList, SortedSet<Integer> transportPorts, SortedSet<Integer> httpPorts) {
        Iterator transportPortIterator = transportPorts.iterator();
        Iterator httpPortIterator = httpPorts.iterator();
        ArrayList<CompletableFuture<? extends Node>> futures = new ArrayList<CompletableFuture<? extends Node>>();
        for (ClusterConfiguration.NodeSettings nodeSettings : nodeSettingList) {
            futures.add(this.startNode(nodeSettings, (Integer)httpPortIterator.next(), (Integer)transportPortIterator.next()));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void stop() {
        log.info("Stopping " + this);
        for (Node node : this.clientNodes()) {
            node.stop();
        }
        for (Node node : this.dataNodes()) {
            node.stop();
        }
        for (Node node : this.masterNodes()) {
            node.stop();
        }
        this.destroyNodes();
    }

    public Node clientNode() {
        return this.findRunningNode(this.clientNodes(), this.dataNodes(), this.masterNodes());
    }

    public Node randomClientNode() {
        return this.randomRunningNode(this.clientNodes(), this.dataNodes(), this.masterNodes());
    }

    public Node masterNode() {
        return this.findRunningNode(this.masterNodes(), new List[0]);
    }

    @SafeVarargs
    private final Node findRunningNode(List<? extends Node> nodes, List<? extends Node> ... moreNodes) {
        for (Node node : nodes) {
            if (!node.isRunning()) continue;
            return node;
        }
        if (moreNodes != null && moreNodes.length > 0) {
            for (List<? extends Node> nodesList : moreNodes) {
                for (Node node : nodesList) {
                    if (!node.isRunning()) continue;
                    return node;
                }
            }
        }
        return null;
    }

    @SafeVarargs
    private final Node randomRunningNode(List<? extends Node> nodes, List<? extends Node> ... moreNodes) {
        ArrayList<Node> runningNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!node.isRunning()) continue;
            runningNodes.add(node);
        }
        if (moreNodes != null && moreNodes.length > 0) {
            for (List<? extends Node> nodesList : moreNodes) {
                for (Node node : nodesList) {
                    if (!node.isRunning()) continue;
                    runningNodes.add(node);
                }
            }
        }
        if (runningNodes.size() == 0) {
            return null;
        }
        int index = this.random.nextInt(runningNodes.size());
        return (Node)runningNodes.get(index);
    }

    protected Settings getMinimalEsSettings() {
        return Settings.builder().put("cluster.name", this.clusterName).putList("cluster.initial_master_nodes", this.initialMasterHosts).put("discovery.initial_state_timeout", "8s").putList("discovery.seed_hosts", this.seedHosts).put("cluster.routing.allocation.disk.threshold_enabled", false).put("discovery.probe.connect_timeout", "10s").put("discovery.probe.handshake_timeout", "10s").put("http.cors.enabled", true).build();
    }

    protected static Settings joinedSettings(Settings ... settings) {
        Settings.Builder result = Settings.builder();
        for (Settings s : settings) {
            result.put(s);
        }
        return result.build();
    }

    protected void retry() throws Exception {
        ++this.retry;
        if (this.retry > 10) {
            throw new RuntimeException("Detected port collisions for master node. Giving up.");
        }
        this.stop();
        this.seedHosts = null;
        this.initialMasterHosts = null;
        FileUtils.cleanDirectory((File)this.clusterHomeDir);
        this.start();
    }

    private static List<String> toHostList(Collection<Integer> ports) {
        return ports.stream().map(port -> "127.0.0.1:" + port).collect(Collectors.toList());
    }

    private static int getUnitTestForkNumber() {
        String forkno = System.getProperty("forkno");
        if (forkno != null && forkno.length() > 0) {
            return Integer.parseInt(forkno.split("_")[1]);
        }
        return 42;
    }

    public static interface Node
    extends EsClientProvider {
        @Override
        public InetSocketAddress getTransportAddress();

        @Override
        public InetSocketAddress getHttpAddress();

        public String getNodeName();

        public boolean isRunning();

        public void stop();
    }
}

